/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.ZipFileCodeBaseEntry;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipFileCodeBase
extends AbstractScannableCodeBase {
    ZipFile zipFile;

    public ZipFileCodeBase(ICodeBaseLocator codeBaseLocator, File file) throws IOException {
        super(codeBaseLocator);
        try {
            this.zipFile = new ZipFile(file);
            this.setLastModifiedTime(file.lastModified());
        }
        catch (IOException e) {
            int magicBytes;
            if (!file.exists()) {
                File parent = file.getParentFile();
                if (!(parent.exists() && parent.isDirectory() && parent.canRead())) {
                    throw new IOException("Can't read directory containing zip file: " + file);
                }
                throw new IOException("Zip file doesn't exist: " + file);
            }
            if (!file.canRead()) {
                throw new IOException("Can't read file zip file: " + file);
            }
            if (!file.isFile()) {
                throw new IOException("Zip file isn't a normal file: " + file);
            }
            if (file.length() == 0L) {
                throw new IOException("Zip file is empty: " + file);
            }
            if (!(e instanceof ZipException)) {
                IOException ioException = new IOException("Error opening zip file " + file + " of " + file.length() + " bytes");
                ioException.initCause(e);
                throw ioException;
            }
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            try {
                magicBytes = in.readInt();
                in.close();
            }
            catch (IOException e3) {
                throw new IOException(String.format("Unable read first 4 bytes of zip file %s of %d bytes", file, file.length()));
            }
            if (magicBytes != 1347093252) {
                throw new IOException(String.format("Wrong magic bytes of %x for zip file %s of %d bytes", magicBytes, file, file.length()));
            }
            ZipException e2 = new ZipException("Error opening zip file " + file + " of " + file.length() + " bytes");
            e2.initCause(e);
            throw e2;
        }
    }

    public ICodeBaseEntry lookupResource(String resourceName) {
        resourceName = this.translateResourceName(resourceName);
        try {
            ZipEntry entry = this.zipFile.getEntry(resourceName);
            if (entry == null) {
                return null;
            }
            return new ZipFileCodeBaseEntry(this, entry);
        }
        catch (IllegalStateException ise) {
            return null;
        }
    }

    public ICodeBaseIterator iterator() {
        final Enumeration<? extends ZipEntry> zipEntryEnumerator = this.zipFile.entries();
        return new ICodeBaseIterator(){
            ZipFileCodeBaseEntry nextEntry;

            public boolean hasNext() {
                this.scanForNextEntry();
                return this.nextEntry != null;
            }

            public ICodeBaseEntry next() throws InterruptedException {
                this.scanForNextEntry();
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                ZipFileCodeBaseEntry result = this.nextEntry;
                this.nextEntry = null;
                return result;
            }

            private void scanForNextEntry() {
                while (this.nextEntry == null) {
                    if (!zipEntryEnumerator.hasMoreElements()) {
                        return;
                    }
                    ZipEntry zipEntry = (ZipEntry)zipEntryEnumerator.nextElement();
                    if (zipEntry.isDirectory()) continue;
                    ZipFileCodeBase.this.addLastModifiedTime(zipEntry.getTime());
                    this.nextEntry = new ZipFileCodeBaseEntry(ZipFileCodeBase.this, zipEntry);
                    break;
                }
            }
        };
    }

    public String getPathName() {
        return this.zipFile.getName();
    }

    public void close() {
        try {
            this.zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.zipFile.getName();
    }
}

