/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ReversePostOrder;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkInfo;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkType;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierDatabase;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierDataflowAnalysis;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValueSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.meta.When;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LocalVariableInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardTypeQualifierDataflowAnalysis
extends TypeQualifierDataflowAnalysis {
    private final DepthFirstSearch dfs;

    public ForwardTypeQualifierDataflowAnalysis(DepthFirstSearch dfs, XMethod xmethod, CFG cfg, ValueNumberDataflow vnaDataflow, ConstantPoolGen cpg, TypeQualifierValue<?> typeQualifierValue) {
        super(xmethod, cfg, vnaDataflow, cpg, typeQualifierValue);
        this.dfs = dfs;
    }

    @Override
    public BlockOrder getBlockOrder(CFG cfg1) {
        return new ReversePostOrder(cfg1, this.dfs);
    }

    @Override
    public boolean isForwards() {
        return true;
    }

    @Override
    public void registerSourceSinkLocations() throws DataflowAnalysisException {
        this.registerParameterSources();
        this.registerInstructionSources();
    }

    private void registerInstructionSources() throws DataflowAnalysisException {
        Iterator<Location> i = this.cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            Instruction instruction = location.getHandle().getInstruction();
            short opcode = instruction.getOpcode();
            int produces = instruction.produceStack(this.cpg);
            if (instruction instanceof InvokeInstruction) {
                this.registerReturnValueSource(location);
                continue;
            }
            if (opcode == 180 || opcode == 178) {
                this.registerFieldLoadSource(location);
                continue;
            }
            if (instruction instanceof LDC) {
                this.registerLDCValueSource(location);
                continue;
            }
            if (instruction instanceof LDC2_W) {
                this.registerLDC2ValueSource(location);
                continue;
            }
            if (instruction instanceof ConstantPushInstruction) {
                this.registerConstantPushSource(location);
                continue;
            }
            if (instruction instanceof ACONST_NULL) {
                this.registerPushNullSource(location);
                continue;
            }
            if (produces != 1 && produces != 2 || instruction instanceof LocalVariableInstruction || instruction instanceof CHECKCAST) continue;
            this.registerOtherSource(location);
        }
    }

    private void registerLDCValueSource(Location location) throws DataflowAnalysisException {
        LDC instruction = (LDC)location.getHandle().getInstruction();
        Object constantValue = instruction.getValue(this.cpg);
        this.registerConstantSource(location, constantValue);
    }

    private void registerLDC2ValueSource(Location location) throws DataflowAnalysisException {
        LDC2_W instruction = (LDC2_W)location.getHandle().getInstruction();
        Number constantValue = instruction.getValue(this.cpg);
        this.registerConstantSource(location, constantValue);
    }

    private void registerPushNullSource(Location location) throws DataflowAnalysisException {
        this.registerConstantSource(location, null);
    }

    private void registerConstantSource(Location location, @CheckForNull Object constantValue) throws DataflowAnalysisException {
        When w;
        if (this.typeQualifierValue.canValidate(constantValue)) {
            w = this.typeQualifierValue.validate(constantValue);
        } else {
            if (this.typeQualifierValue.isStrictQualifier()) {
                return;
            }
            w = When.UNKNOWN;
        }
        this.registerTopOfStackSource(SourceSinkType.CONSTANT_VALUE, location, w, false, constantValue);
    }

    private void registerOtherSource(Location location) throws DataflowAnalysisException {
        this.registerTopOfStackSource(SourceSinkType.OTHER, location, When.UNKNOWN, false, null);
    }

    private void registerConstantPushSource(Location location) throws DataflowAnalysisException {
        ConstantPushInstruction instruction = (ConstantPushInstruction)((Object)location.getHandle().getInstruction());
        Number constantValue = instruction.getValue();
        this.registerConstantSource(location, constantValue);
    }

    private void registerReturnValueSource(Location location) throws DataflowAnalysisException {
        InvokeInstruction inv = (InvokeInstruction)location.getHandle().getInstruction();
        String calledMethodSig = inv.getSignature(this.cpg);
        if (calledMethodSig.endsWith(")V")) {
            return;
        }
        XMethod calledXMethod = XFactory.createXMethod(inv, this.cpg);
        if (TypeQualifierDataflowAnalysis.isIdentifyFunctionForTypeQualifiers(calledXMethod)) {
            return;
        }
        if (calledXMethod.isResolved()) {
            TypeQualifierDatabase tqdb;
            TypeQualifierAnnotation tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(calledXMethod, this.typeQualifierValue);
            boolean interproc = false;
            if (TypeQualifierDatabase.USE_DATABASE && tqa == null && (tqa = (tqdb = Global.getAnalysisCache().getDatabase(TypeQualifierDatabase.class)).getReturnValue(calledXMethod.getMethodDescriptor(), this.typeQualifierValue)) != null) {
                interproc = true;
            }
            When when = tqa != null ? tqa.when : When.UNKNOWN;
            this.registerTopOfStackSource(SourceSinkType.RETURN_VALUE_OF_CALLED_METHOD, location, when, interproc, null);
        }
    }

    private void registerFieldLoadSource(Location location) throws DataflowAnalysisException {
        XField loadedField = XFactory.createXField((FieldInstruction)location.getHandle().getInstruction(), this.cpg);
        if (loadedField.isResolved()) {
            TypeQualifierAnnotation tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(loadedField, this.typeQualifierValue);
            When when = tqa != null ? tqa.when : When.UNKNOWN;
            this.registerTopOfStackSource(SourceSinkType.FIELD_LOAD, location, when, false, null);
        }
    }

    private void registerTopOfStackSource(SourceSinkType sourceSinkType, Location location, When when, boolean interproc, @CheckForNull Object constantValue) throws DataflowAnalysisException {
        if (when == When.UNKNOWN && !this.typeQualifierValue.isStrictQualifier()) {
            return;
        }
        ValueNumberFrame vnaFrameAfterInstruction = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(location);
        if (vnaFrameAfterInstruction.isValid()) {
            ValueNumber tosValue = (ValueNumber)vnaFrameAfterInstruction.getTopValue();
            SourceSinkInfo sourceSinkInfo = new SourceSinkInfo(sourceSinkType, location, tosValue, when);
            sourceSinkInfo.setInterproc(interproc);
            sourceSinkInfo.setConstantValue(constantValue);
            this.registerSourceSink(sourceSinkInfo);
        }
    }

    private void registerParameterSources() {
        ValueNumberFrame vnaFrameAtEntry = (ValueNumberFrame)this.vnaDataflow.getStartFact(this.cfg.getEntry());
        SignatureParser sigParser = new SignatureParser(this.xmethod.getSignature());
        int firstParamSlot = this.xmethod.isStatic() ? 0 : 1;
        int param = 0;
        int slotOffset = 0;
        for (String paramSig : sigParser.parameterSignatures()) {
            TypeQualifierAnnotation tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(this.xmethod, param, this.typeQualifierValue);
            When when = tqa != null ? tqa.when : When.UNKNOWN;
            ValueNumber vn = (ValueNumber)vnaFrameAtEntry.getValue(slotOffset + firstParamSlot);
            SourceSinkInfo info = new SourceSinkInfo(SourceSinkType.PARAMETER, this.cfg.getLocationAtEntry(), vn, when);
            info.setParameterAndLocal(param, slotOffset + firstParamSlot);
            this.registerSourceSink(info);
            ++param;
            slotOffset += SignatureParser.getNumSlotsForType(paramSig);
        }
    }

    @Override
    protected void propagateAcrossPhiNode(TypeQualifierValueSet fact, ValueNumber sourceVN, ValueNumber targetVN) {
        fact.propagateAcrossPhiNode(sourceVN, targetVN);
    }
}

