/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ReverseDFSOrder;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.FlowValue;
import edu.umd.cs.findbugs.ba.jsr305.ForwardTypeQualifierDataflow;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkInfo;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkType;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierDatabase;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierDataflowAnalysis;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValueSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.meta.When;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReturnInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackwardTypeQualifierDataflowAnalysis
extends TypeQualifierDataflowAnalysis {
    private static final boolean PRUNE_CONFLICTING_VALUES = true;
    private final DepthFirstSearch dfs;
    private final ReverseDepthFirstSearch rdfs;
    private ForwardTypeQualifierDataflow forwardTypeQualifierDataflow;

    public BackwardTypeQualifierDataflowAnalysis(DepthFirstSearch dfs, ReverseDepthFirstSearch rdfs, XMethod xmethod, CFG cfg, ValueNumberDataflow vnaDataflow, ConstantPoolGen cpg, TypeQualifierValue<?> typeQualifierValue) {
        super(xmethod, cfg, vnaDataflow, cpg, typeQualifierValue);
        this.dfs = dfs;
        this.rdfs = rdfs;
    }

    public void setForwardTypeQualifierDataflow(ForwardTypeQualifierDataflow forwardTypeQualifierDataflow) {
        this.forwardTypeQualifierDataflow = forwardTypeQualifierDataflow;
    }

    @Override
    public void edgeTransfer(Edge edge, TypeQualifierValueSet fact) throws DataflowAnalysisException {
        if (this.forwardTypeQualifierDataflow != null) {
            this.pruneConflictingValues(fact, (TypeQualifierValueSet)this.forwardTypeQualifierDataflow.getFactOnEdge(edge));
        }
        super.edgeTransfer(edge, fact);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, TypeQualifierValueSet fact) throws DataflowAnalysisException {
        if (!fact.isValid()) {
            return;
        }
        if (this.forwardTypeQualifierDataflow != null) {
            Location location = new Location(handle, basicBlock);
            this.pruneConflictingValues(fact, (TypeQualifierValueSet)this.forwardTypeQualifierDataflow.getFactAfterLocation(location));
        }
        super.transferInstruction(handle, basicBlock, fact);
    }

    private void pruneConflictingValues(TypeQualifierValueSet fact, TypeQualifierValueSet forwardFact) {
        if (forwardFact.isValid()) {
            HashSet<? extends ValueNumber> valueNumbers = new HashSet<ValueNumber>();
            valueNumbers.addAll(fact.getValueNumbers());
            valueNumbers.retainAll(forwardFact.getValueNumbers());
            for (ValueNumber valueNumber : valueNumbers) {
                if (!FlowValue.valuesConflict(this.typeQualifierValue.isStrictQualifier() && !this.xmethod.isIdentity(), forwardFact.getValue(valueNumber), fact.getValue(valueNumber))) continue;
                fact.pruneValue(valueNumber);
            }
        }
    }

    @Override
    public BlockOrder getBlockOrder(CFG cfg1) {
        return new ReverseDFSOrder(cfg1, this.rdfs, this.dfs);
    }

    @Override
    public boolean isForwards() {
        return false;
    }

    @Override
    public void registerSourceSinkLocations() throws DataflowAnalysisException {
        this.registerInstructionSinks();
    }

    private void registerInstructionSinks() throws DataflowAnalysisException {
        TypeQualifierAnnotation returnValueAnnotation = null;
        if (!this.xmethod.getSignature().endsWith(")V")) {
            returnValueAnnotation = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(this.xmethod, this.typeQualifierValue);
        }
        Iterator<Location> i = this.cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            Instruction ins = location.getHandle().getInstruction();
            if (ins instanceof ReturnInstruction && !(ins instanceof RETURN)) {
                this.modelReturn(returnValueAnnotation, location);
                continue;
            }
            short opcode = ins.getOpcode();
            if (opcode == 181 || opcode == 179) {
                this.modelFieldStore(location);
                continue;
            }
            if (!(location.getHandle().getInstruction() instanceof InvokeInstruction)) continue;
            this.modelArguments(location);
        }
    }

    private void modelReturn(TypeQualifierAnnotation returnValueAnnotation, Location location) throws DataflowAnalysisException {
        When when = returnValueAnnotation != null ? returnValueAnnotation.when : When.UNKNOWN;
        ValueNumberFrame vnaFrameAtReturn = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location);
        if (vnaFrameAtReturn.isValid()) {
            ValueNumber topValue = (ValueNumber)vnaFrameAtReturn.getTopValue();
            SourceSinkInfo sink = new SourceSinkInfo(SourceSinkType.RETURN_VALUE, location, topValue, when);
            this.registerSourceSink(sink);
        }
    }

    private void modelFieldStore(Location location) throws DataflowAnalysisException {
        XField writtenField = XFactory.createXField((FieldInstruction)location.getHandle().getInstruction(), this.cpg);
        TypeQualifierAnnotation tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(writtenField, this.typeQualifierValue);
        When when = tqa != null ? tqa.when : When.UNKNOWN;
        ValueNumberFrame vnaFrameAtStore = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location);
        if (vnaFrameAtStore.isValid()) {
            ValueNumber vn = (ValueNumber)vnaFrameAtStore.getTopValue();
            SourceSinkInfo sink = new SourceSinkInfo(SourceSinkType.FIELD_STORE, location, vn, when);
            this.registerSourceSink(sink);
        }
    }

    private void modelArguments(Location location) throws DataflowAnalysisException {
        InvokeInstruction inv = (InvokeInstruction)location.getHandle().getInstruction();
        XMethod calledMethod = XFactory.createXMethod(inv, this.cpg);
        SignatureParser sigParser = new SignatureParser(calledMethod.getSignature());
        if (sigParser.getNumParameters() == 0) {
            return;
        }
        ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location);
        if (!vnaFrame.isValid()) {
            return;
        }
        if (TypeQualifierDataflowAnalysis.isIdentifyFunctionForTypeQualifiers(calledMethod)) {
            return;
        }
        for (int param = 0; param < calledMethod.getNumParams(); ++param) {
            TypeQualifierDatabase tqdb;
            TypeQualifierAnnotation tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(calledMethod, param, this.typeQualifierValue);
            boolean interproc = false;
            if (TypeQualifierDatabase.USE_DATABASE && tqa == null && (tqa = (tqdb = Global.getAnalysisCache().getDatabase(TypeQualifierDatabase.class)).getParameter(calledMethod.getMethodDescriptor(), param, this.typeQualifierValue)) != null) {
                interproc = true;
            }
            When when = tqa != null ? tqa.when : When.UNKNOWN;
            ValueNumber vn = (ValueNumber)vnaFrame.getArgument(inv, this.cpg, param, sigParser);
            SourceSinkInfo info = new SourceSinkInfo(SourceSinkType.ARGUMENT_TO_CALLED_METHOD, location, vn, when);
            info.setParameter(param);
            info.setInterproc(interproc);
            this.registerSourceSink(info);
        }
    }

    @Override
    protected void propagateAcrossPhiNode(TypeQualifierValueSet fact, ValueNumber sourceVN, ValueNumber targetVN) {
        fact.propagateAcrossPhiNode(targetVN, sourceVN);
    }
}

