/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationEnumeration;
import edu.umd.cs.findbugs.ba.ComparableMethod;
import edu.umd.cs.findbugs.ba.InnerClassAccess;
import edu.umd.cs.findbugs.ba.InnerClassAccessMap;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.MapCache;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDatabase<AnnotationEnum extends AnnotationEnumeration<AnnotationEnum>> {
    static final boolean DEBUG = SystemProperties.getBoolean("annotations.debug");
    public static final boolean IGNORE_BUILTIN_ANNOTATIONS = SystemProperties.getBoolean("findbugs.ignoreBuiltinAnnotations");
    private static final String DEFAULT_ANNOTATION_ANNOTATION_CLASS = "DefaultAnnotation";
    private final Map<Object, AnnotationEnum> directAnnotations = new HashMap<Object, AnnotationEnum>();
    private final Map<Target, Map<String, AnnotationEnum>> defaultAnnotation = new EnumMap<Target, Map<String, AnnotationEnum>>(Target.class);
    private final Set<AnnotationEnum> seen = new HashSet<AnnotationEnum>();
    Map<Object, AnnotationEnum> cachedMinimal = new MapCache<Object, AnnotationEnum>(20000);
    Map<Object, AnnotationEnum> cachedMaximal = new MapCache<Object, AnnotationEnum>(20000);
    boolean addClassOnly = false;

    public AnnotationDatabase() {
        this.defaultAnnotation.put(Target.ANY, new HashMap());
        this.defaultAnnotation.put(Target.PARAMETER, new HashMap());
        this.defaultAnnotation.put(Target.METHOD, new HashMap());
        this.defaultAnnotation.put(Target.FIELD, new HashMap());
    }

    public void loadAuxiliaryAnnotations() {
    }

    public void addDirectAnnotation(Object o, AnnotationEnum n) {
        this.directAnnotations.put(o, n);
        this.seen.add(n);
    }

    public void addDefaultAnnotation(Target target, String c, AnnotationEnum n) {
        if (!this.defaultAnnotation.containsKey((Object)target)) {
            return;
        }
        if (DEBUG) {
            System.out.println("Default annotation " + (Object)((Object)target) + " " + c + " " + n);
        }
        this.defaultAnnotation.get((Object)target).put(c, n);
        this.seen.add(n);
    }

    public boolean anyAnnotations(AnnotationEnum n) {
        return this.seen.contains(n);
    }

    @CheckForNull
    public AnnotationEnum getResolvedAnnotation(Object o, boolean getMinimal) {
        Map<Object, AnnotationEnum> cache;
        XMethod m;
        if (o instanceof XMethod && (m = (XMethod)o).getName().startsWith("access$")) {
            InnerClassAccessMap icam = AnalysisContext.currentAnalysisContext().getInnerClassAccessMap();
            try {
                InnerClassAccess ica = icam.getInnerClassAccess(m.getClassName(), m.getName());
                if (ica != null && ica.isLoad()) {
                    o = ica.getField();
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
                return null;
            }
        }
        if ((cache = getMinimal ? this.cachedMinimal : this.cachedMaximal).containsKey(o)) {
            return (AnnotationEnum)((AnnotationEnumeration)cache.get(o));
        }
        AnnotationEnum n = this.getUncachedResolvedAnnotation(o, getMinimal);
        if (DEBUG) {
            System.out.println("TTT: " + o + " " + n);
        }
        cache.put(o, n);
        return n;
    }

    public boolean annotationIsDirect(Object o) {
        return this.directAnnotations.containsKey(o);
    }

    @CheckForNull
    public AnnotationEnum getUncachedResolvedAnnotation(Object o, boolean getMinimal) {
        Object n = this.getDirectAnnotation(o);
        if (n != null) {
            return n;
        }
        try {
            String className;
            Target kind;
            boolean isParameterToInitMethodofAnonymousInnerClass = false;
            boolean isSyntheticMethod = false;
            if (o instanceof XMethod || o instanceof XMethodParameter) {
                XMethod m;
                if (o instanceof XMethod) {
                    m = (XMethod)o;
                    isSyntheticMethod = m.isSynthetic();
                    kind = Target.METHOD;
                    className = m.getClassName();
                } else if (o instanceof XMethodParameter) {
                    int i;
                    m = ((XMethodParameter)o).getMethod();
                    isSyntheticMethod = m.isSynthetic();
                    className = m.getClassName();
                    kind = Target.PARAMETER;
                    if (m.getName().equals("<init>") && (i = className.lastIndexOf("$")) + 1 < className.length() && Character.isDigit(className.charAt(i + 1))) {
                        isParameterToInitMethodofAnonymousInnerClass = true;
                    }
                } else {
                    throw new IllegalStateException("impossible");
                }
                if (!m.isStatic() && !m.getName().equals("<init>")) {
                    JavaClass c = Repository.lookupClass(className);
                    TreeSet<AnnotationEnum> inheritedAnnotations = new TreeSet<AnnotationEnum>();
                    if (c.getSuperclassNameIndex() > 0 && (n = this.lookInOverriddenMethod(o, c.getSuperclassName(), m, getMinimal)) != null) {
                        inheritedAnnotations.add(n);
                    }
                    for (String implementedInterface : c.getInterfaceNames()) {
                        n = this.lookInOverriddenMethod(o, implementedInterface, m, getMinimal);
                        if (n == null) continue;
                        inheritedAnnotations.add(n);
                    }
                    if (DEBUG) {
                        System.out.println("# of inherited annotations : " + inheritedAnnotations.size());
                    }
                    if (!inheritedAnnotations.isEmpty()) {
                        if (inheritedAnnotations.size() == 1) {
                            return (AnnotationEnum)((AnnotationEnumeration)inheritedAnnotations.first());
                        }
                        if (!getMinimal) {
                            return (AnnotationEnum)((AnnotationEnumeration)inheritedAnnotations.last());
                        }
                        AnnotationEnumeration min = (AnnotationEnumeration)inheritedAnnotations.first();
                        if (min.getIndex() == 0) {
                            inheritedAnnotations.remove(min);
                            min = (AnnotationEnumeration)inheritedAnnotations.first();
                        }
                        return (AnnotationEnum)min;
                    }
                    if (!this.classDefinesMethod(c, m)) {
                        return null;
                    }
                    if (DEBUG) {
                        System.out.println("looking for default annotations: " + c.getClassName() + " defines " + m);
                    }
                }
            } else if (o instanceof XField) {
                className = ((XField)o).getClassName();
                kind = Target.FIELD;
            } else if (o instanceof String) {
                assert (false);
                className = (String)o;
                kind = Target.CLASS;
            } else {
                throw new IllegalArgumentException("Can't look up annotation for " + o.getClass().getName());
            }
            if (isParameterToInitMethodofAnonymousInnerClass) {
                return null;
            }
            if (isSyntheticMethod) {
                return null;
            }
            try {
                XClass c = Global.getAnalysisCache().getClassAnalysis(XClass.class, DescriptorFactory.createClassDescriptorFromDottedClassName(className));
                if (c != null && c.isSynthetic()) {
                    return null;
                }
            }
            catch (CheckedAnalysisException e) {
                // empty catch block
            }
            n = (AnnotationEnumeration)this.defaultAnnotation.get((Object)kind).get(className);
            if (DEBUG) {
                System.out.println("Default annotation for " + (Object)((Object)kind) + " is " + n);
            }
            if (n != null) {
                return n;
            }
            n = (AnnotationEnumeration)this.defaultAnnotation.get((Object)Target.ANY).get(className);
            if (DEBUG) {
                System.out.println("Default annotation for any is " + n);
            }
            if (n != null) {
                return n;
            }
            int p = className.lastIndexOf(46);
            className = className.substring(0, p + 1) + "package-info";
            n = (AnnotationEnumeration)this.defaultAnnotation.get((Object)kind).get(className);
            if (DEBUG) {
                System.out.println("Default annotation for " + (Object)((Object)kind) + " is " + n);
            }
            if (n != null) {
                return n;
            }
            n = (AnnotationEnumeration)this.defaultAnnotation.get((Object)Target.ANY).get(className);
            if (DEBUG) {
                System.out.println("Default annotation for any is " + n);
            }
            if (n != null) {
                return n;
            }
            return n;
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return null;
        }
    }

    public AnnotationEnum getDirectAnnotation(Object o) {
        return (AnnotationEnum)((AnnotationEnumeration)this.directAnnotations.get(o));
    }

    private boolean classDefinesMethod(JavaClass c, XMethod m) {
        for (Method definedMethod : c.getMethods()) {
            if (!definedMethod.getName().equals(m.getName()) || !definedMethod.getSignature().equals(m.getSignature()) || definedMethod.isStatic() != m.isStatic()) continue;
            return true;
        }
        return false;
    }

    private AnnotationEnum lookInOverriddenMethod(Object originalQuery, String classToLookIn, XMethod originalMethod, boolean getMinimal) {
        try {
            Comparable<ComparableMethod> probe;
            XMethod superMethod = XFactory.createXMethod(classToLookIn, originalMethod.getName(), originalMethod.getSignature(), originalMethod.isStatic());
            if (!superMethod.isResolved()) {
                return null;
            }
            if (DEBUG) {
                System.out.println("Looking for overridden method " + superMethod);
            }
            if (originalQuery instanceof XMethod) {
                probe = superMethod;
            } else if (originalQuery instanceof XMethodParameter) {
                probe = new XMethodParameter(superMethod, ((XMethodParameter)originalQuery).getParameterNumber());
            } else {
                throw new IllegalStateException("impossible");
            }
            AnnotationEnum n = this.getResolvedAnnotation(probe, getMinimal);
            return n;
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Exception while looking for annotation of " + originalMethod + "in " + classToLookIn, e);
            return null;
        }
    }

    public boolean setAddClassOnly(boolean newValue) {
        boolean oldValue = this.addClassOnly;
        this.addClassOnly = newValue;
        return oldValue;
    }

    protected void addDefaultMethodAnnotation(String cName, AnnotationEnum annotation) {
        if (this.addClassOnly) {
            return;
        }
        this.addDefaultAnnotation(Target.METHOD, cName, annotation);
    }

    protected void addFieldAnnotation(String cName, String mName, String mSig, boolean isStatic, AnnotationEnum annotation) {
        if (this.addClassOnly) {
            return;
        }
        XField m = XFactory.createXField(cName, mName, mSig, isStatic);
        this.addDirectAnnotation(m, annotation);
    }

    protected void addMethodAnnotation(Class<?> clazz, String mName, String mSig, boolean isStatic, AnnotationEnum annotation) {
        this.addMethodAnnotation(clazz.getName(), mName, mSig, isStatic, annotation);
    }

    protected void addMethodAnnotation(@DottedClassName String cName, String mName, String mSig, boolean isStatic, AnnotationEnum annotation) {
        if (this.addClassOnly) {
            return;
        }
        XMethod m = XFactory.createXMethod(cName, mName, mSig, isStatic);
        if (!m.getClassName().equals(cName)) {
            return;
        }
        this.addDirectAnnotation(m, annotation);
    }

    private boolean onlyAppliesToReferenceParameters(AnnotationEnum annotation) {
        return true;
    }

    protected void addMethodParameterAnnotation(String cName, String mName, String mSig, boolean isStatic, int param, AnnotationEnum annotation) {
        boolean isReference;
        if (this.addClassOnly) {
            return;
        }
        SignatureParser parser = new SignatureParser(mSig);
        if (param < 0 || param >= parser.getNumParameters()) {
            throw new IllegalArgumentException("can't annotation parameter #" + param + " of " + cName + "." + mName + mSig);
        }
        String signature = parser.getParameter(param);
        char firstChar = signature.charAt(0);
        boolean bl = isReference = firstChar == 'L' || firstChar == '[';
        if (this.onlyAppliesToReferenceParameters(annotation) && !isReference) {
            AnalysisContext.logError("Can't apply " + annotation + " to parameter " + param + " with signature " + signature + " of " + cName + "." + mName + " : " + mSig);
            return;
        }
        XMethod m = XFactory.createXMethod(cName, mName, mSig, isStatic);
        this.addDirectAnnotation(new XMethodParameter(m, param), annotation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {
        FIELD,
        METHOD,
        PARAMETER,
        CLASS,
        ANY;

    }
}

