/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;

public abstract class AbstractClassMember
implements ClassMember {
    @DottedClassName
    private final String className;
    private final String name;
    private final String signature;
    private final int accessFlags;
    private boolean resolved;
    private int cachedHashCode = 0;
    static int slashCountClass = 0;
    static int dottedCountClass = 0;
    static int slashCountSignature = 0;
    static int dottedCountSignature = 0;

    protected AbstractClassMember(@DottedClassName String className, String name, String signature, int accessFlags) {
        if (className.indexOf(46) >= 0) {
            ++dottedCountClass;
        } else if (className.indexOf(47) >= 0) {
            assert (false);
            ++slashCountClass;
            className = className.replace('/', '.');
        }
        if (signature.indexOf(46) >= 0) {
            assert (false);
            signature = signature.replace('.', '/');
            ++dottedCountSignature;
        } else if (signature.indexOf(47) >= 0) {
            ++slashCountSignature;
        }
        this.className = DescriptorFactory.canonicalizeString(className);
        this.name = DescriptorFactory.canonicalizeString(name);
        this.signature = DescriptorFactory.canonicalizeString(signature);
        this.accessFlags = accessFlags;
    }

    @DottedClassName
    public String getClassName() {
        return this.className;
    }

    public ClassDescriptor getClassDescriptor() {
        return DescriptorFactory.instance().getClassDescriptorForDottedClassName(this.className);
    }

    public String getName() {
        return this.name;
    }

    @DottedClassName
    public String getPackageName() {
        int lastDot = this.className.lastIndexOf(46);
        if (lastDot == -1) {
            return this.className;
        }
        return this.className.substring(0, lastDot);
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isReferenceType() {
        return this.signature.startsWith("L") || this.signature.startsWith("[");
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    void markAsResolved() {
        this.resolved = true;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.className.hashCode() ^ this.name.hashCode() ^ this.signature.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractClassMember other = (AbstractClassMember)o;
        return this.className.equals(other.className) && this.name.equals(other.name) && this.signature.equals(other.signature);
    }

    public String toString() {
        return this.className + "." + this.name;
    }
}

