/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBlockOrder
implements BlockOrder {
    private final ArrayList<BasicBlock> blockList;
    private final Comparator<BasicBlock> comparator;

    public AbstractBlockOrder(CFG cfg, Comparator<BasicBlock> comparator) {
        this.comparator = comparator;
        int numBlocks = cfg.getNumBasicBlocks();
        int count = 0;
        BasicBlock[] blocks = new BasicBlock[numBlocks];
        Iterator<BasicBlock> i = cfg.blockIterator();
        while (i.hasNext()) {
            blocks[count++] = i.next();
        }
        assert (count == numBlocks);
        Arrays.sort(blocks, comparator);
        this.blockList = new ArrayList(numBlocks);
        for (int i2 = 0; i2 < numBlocks; ++i2) {
            this.blockList.add(blocks[i2]);
        }
    }

    @Override
    public Iterator<BasicBlock> blockIterator() {
        return this.blockList.iterator();
    }

    @Override
    public int compare(BasicBlock b1, BasicBlock b2) {
        return this.comparator.compare(b1, b2);
    }
}

