/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.File;
import org.math.R.RegistryHog;
import org.math.R.StreamHog;
import org.rosuda.REngine.Rserve.RConnection;

public class StartRserve {
    public static boolean isRserveInstalled(String Rcmd) {
        StringBuffer result = new StringBuffer();
        boolean done = StartRserve.doInR("i=installed.packages();is.element(set=i,el='Rserve')", Rcmd, "--vanilla -q", result, result);
        if (!done) {
            return false;
        }
        return result.toString().contains("TRUE");
    }

    public static boolean installRserve(String Rcmd, String http_proxy) {
        System.err.print("Install Rserve from rforge... (http_proxy=" + http_proxy + ") ");
        boolean ok = StartRserve.doInR((http_proxy != null ? "Sys.setenv(http_proxy='" + http_proxy + "');" : "") + "install.packages('Rserve',,'http://www.rforge.net/')", Rcmd, "--vanilla", null, null);
        if (!ok) {
            System.err.println("failed");
            return false;
        }
        for (int n = 5; n > 0; --n) {
            try {
                Thread.sleep(10000 / n);
                System.err.print(".");
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!StartRserve.isRserveInstalled(Rcmd)) continue;
            System.err.println("ok");
            return true;
        }
        System.err.println("failed");
        return false;
    }

    public static boolean doInR(String todo, String Rcmd, String rargs, StringBuffer out, StringBuffer err) {
        try {
            Process p;
            boolean isWindows = false;
            String osname = System.getProperty("os.name");
            String command = null;
            if (osname != null && osname.length() >= 7 && osname.substring(0, 7).equals("Windows")) {
                isWindows = true;
                command = "\"" + Rcmd + "\" -e \"" + todo + "\" " + rargs;
                p = Runtime.getRuntime().exec(command);
            } else {
                command = "echo \"" + todo + "\"|" + Rcmd + " " + rargs;
                p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
            }
            System.err.println("  executing " + command);
            StreamHog error = new StreamHog(p.getErrorStream(), err != null);
            StreamHog output = new StreamHog(p.getInputStream(), out != null);
            if (err != null) {
                error.join();
            }
            if (out != null) {
                output.join();
            }
            if (!isWindows) {
                p.waitFor();
            }
            if (out != null) {
                out.append(output.getOutput());
            }
            if (err != null) {
                err.append(error.getOutput());
            }
        }
        catch (Exception x) {
            return false;
        }
        return true;
    }

    public static boolean launchRserve(String cmd) {
        return StartRserve.launchRserve(cmd, "--no-save --slave", "--no-save --slave", false);
    }

    public static boolean launchRserve(String cmd, String rargs, String rsrvargs, boolean debug) {
        System.err.println("Waiting for Rserve to start ...");
        boolean startRserve = StartRserve.doInR("library(Rserve);Rserve(" + (debug ? "TRUE" : "FALSE") + ",args='" + rsrvargs + "')", cmd, rargs, null, null);
        if (!startRserve) {
            System.err.println("Failed to start Rserve process.");
            return false;
        }
        System.err.println("Rserve startup done, let us try to connect ...");
        for (int attempts = 5; attempts > 0; --attempts) {
            try {
                RConnection c = null;
                int port = -1;
                if (rsrvargs.contains("--RS-port")) {
                    String rsport = rsrvargs.split("--RS-port")[1].trim().split(" ")[0];
                    port = Integer.parseInt(rsport);
                    c = new RConnection("localhost", port);
                } else {
                    c = new RConnection("localhost");
                }
                System.err.println("Rserve is running.");
                c.close();
                return true;
            }
            catch (Exception e2) {
                System.err.println("Try failed with: " + e2.getMessage());
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ix) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    public static boolean checkLocalRserve() {
        if (StartRserve.isRserveRunning()) {
            return true;
        }
        String osname = System.getProperty("os.name");
        if (osname != null && osname.length() >= 7 && osname.substring(0, 7).equals("Windows")) {
            System.err.println("Windows: query registry to find where R is installed ...");
            String installPath = null;
            try {
                Process rp = Runtime.getRuntime().exec("reg query HKLM\\Software\\R-core\\R");
                RegistryHog regHog = new RegistryHog(rp.getInputStream(), true);
                rp.waitFor();
                regHog.join();
                installPath = regHog.getInstallPath();
            }
            catch (Exception rge) {
                System.err.println("ERROR: unable to run REG to find the location of R: " + rge);
                return false;
            }
            if (installPath == null) {
                System.err.println("ERROR: canot find path to R. Make sure reg is available and R was installed with registry settings.");
                return false;
            }
            return StartRserve.launchRserve(installPath + "\\bin\\R.exe");
        }
        return StartRserve.launchRserve("R") || new File("/Library/Frameworks/R.framework/Resources/bin/R").exists() && StartRserve.launchRserve("/Library/Frameworks/R.framework/Resources/bin/R") || new File("/usr/local/lib/R/bin/R").exists() && StartRserve.launchRserve("/usr/local/lib/R/bin/R") || new File("/usr/lib/R/bin/R").exists() && StartRserve.launchRserve("/usr/lib/R/bin/R") || new File("/usr/local/bin/R").exists() && StartRserve.launchRserve("/usr/local/bin/R") || new File("/sw/bin/R").exists() && StartRserve.launchRserve("/sw/bin/R") || new File("/usr/common/bin/R").exists() && StartRserve.launchRserve("/usr/common/bin/R") || new File("/opt/bin/R").exists() && StartRserve.launchRserve("/opt/bin/R");
    }

    public static boolean isRserveRunning() {
        try {
            RConnection c = new RConnection();
            System.err.println("Rserve is running.");
            c.close();
            return true;
        }
        catch (Exception e) {
            System.err.println("First connect try failed with: " + e.getMessage());
            return false;
        }
    }

    public static void main(String[] args) {
        System.err.println("result=" + StartRserve.checkLocalRserve());
        try {
            RConnection c = new RConnection();
            c.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

