/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.math.R.BusyListener;
import org.math.R.EvalListener;
import org.math.R.Logger;
import org.math.R.Rdaemon;
import org.math.R.RserverConf;
import org.math.R.UpdateObjectsListener;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RFileInputStream;
import org.rosuda.REngine.Rserve.RFileOutputStream;
import org.rosuda.REngine.Rserve.RserveException;

public class Rsession
implements Logger {
    public static final String CAST_ERROR = "Cannot cast ";
    public RConnection connection;
    PrintStream console;
    boolean tryLocalRServe;
    public static final String PACKAGEINSTALLED = "Package installed.";
    public static final String PACKAGELOADED = "Package loaded.";
    public boolean connected = false;
    static String separator = ",";
    public static final int MinRserveVersion = 103;
    Rdaemon localRserve;
    public RserverConf RserveConf;
    public static final String STATUS_NOT_SET = "Unknown status";
    public static final String STATUS_READY = "Ready";
    public static final String STATUS_ERROR = "Error";
    public static final String STATUS_ENDED = "End";
    public static final String STATUS_NOT_CONNECTED = "Not connected";
    public static final String STATUS_CONNECTING = "Connecting...";
    public String status = "Unknown status";
    LinkedList<Logger> loggers;
    LinkedList<BusyListener> busy = new LinkedList();
    LinkedList<UpdateObjectsListener> updateObjects = new LinkedList();
    LinkedList<EvalListener> eval = new LinkedList();
    public static final boolean UNIX_OPTIMIZE = true;
    static String lastmessage = "";
    static int repeated = 0;
    public String repos = "http://cran.r-project.org";
    private static String loadedpacks = "loadedpacks";
    private static String packs = "packs";
    static final String HEAD_EVAL = "[eval] ";
    static final String HEAD_EXCEPTION = "[exception] ";
    static final String HEAD_ERROR = "[error] ";
    static final String HEAD_CACHE = "[cache] ";
    static final String[] types = new String[]{"data.frame", "null", "function", "array", "integer", "character", "double"};
    public static final String HEAD_SET = "[set] ";
    public static final String GRAPHIC_PNG = "png";
    public static final String GRAPHIC_JPEG = "jpeg";
    public static final String GRAPHIC_BMP = "bmp";
    public static final String GRAPHIC_TIFF = "tiff";
    static final String IO_HEAD = "[IO] ";
    public int SEND_BUFFER_SIZE = 512;
    static final String testExpression = "1+pi";
    static final double testResult = 4.141592653589793;
    HashMap<String, Object> noVarsEvals = new HashMap();
    static final String AW = "((\\A)|(\\W))(";
    static final String Az = ")((\\W)|(\\z))";

    public void addLogger(Logger l) {
        if (!this.loggers.contains(l)) {
            this.loggers.add(l);
        }
    }

    public void removeLogger(Logger l) {
        if (this.loggers.contains(l)) {
            this.loggers.remove(l);
        }
    }

    @Override
    public void println(String message) {
        for (Logger l : this.loggers) {
            l.println(message);
        }
    }

    public void addBusyListener(BusyListener b) {
        if (!this.busy.contains(b)) {
            this.busy.add(b);
        }
    }

    public void removeBusyListener(BusyListener b) {
        if (this.busy.contains(b)) {
            this.busy.remove(b);
        }
    }

    public void setBusy(boolean bb) {
        for (BusyListener b : this.busy) {
            b.setBusy(bb);
        }
    }

    public void addUpdateObjectsListener(UpdateObjectsListener b) {
        if (!this.updateObjects.contains(b)) {
            this.updateObjects.add(b);
        }
    }

    public void removeUpdateObjectsListener(UpdateObjectsListener b) {
        if (this.updateObjects.contains(b)) {
            this.updateObjects.remove(b);
        }
    }

    public void addEvalListener(EvalListener b) {
        if (!this.eval.contains(b)) {
            this.eval.add(b);
        }
    }

    public void removeEvalListener(EvalListener b) {
        if (this.eval.contains(b)) {
            this.eval.remove(b);
        }
    }

    public static String toString(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof double[]) {
            return Rsession.cat((double[])o);
        }
        if (o instanceof double[][]) {
            return Rsession.cat((double[][])o);
        }
        if (o instanceof int[]) {
            return Rsession.cat((int[])o);
        }
        if (o instanceof int[][]) {
            return Rsession.cat((int[][])o);
        }
        if (o instanceof Object[]) {
            return Rsession.cat((Object[])o);
        }
        if (o instanceof Object[][]) {
            return Rsession.cat((Object[][])o);
        }
        if (o instanceof RList) {
            return Rsession.cat((RList)o);
        }
        return o.toString();
    }

    public static String cat(RList list) {
        try {
            int i;
            StringBuffer sb = new StringBuffer("\t");
            double[][] data = new double[list.names.size()][];
            for (i = 0; i < list.size(); ++i) {
                String n = list.keyAt(i);
                sb.append(n + "\t");
                data[i] = list.at(n).asDoubles();
            }
            sb.append("\n");
            for (i = 0; i < data[0].length; ++i) {
                sb.append(i + 1 + "\t");
                for (int j = 0; j < data.length; ++j) {
                    sb.append(data[j][i] + "\t");
                }
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (REXPMismatchException r) {
            return "(Not a numeric dataframe)\n" + new REXPList(list).toDebugString();
        }
    }

    public static String cat(double[] array) {
        if (array == null || array.length == 0) {
            return "NA";
        }
        String o = array[0] + "";
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + separator + array[i] + "";
            }
        }
        return o;
    }

    public static String cat(int[] array) {
        if (array == null || array.length == 0) {
            return "NA";
        }
        String o = array[0] + "";
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + separator + array[i] + "";
            }
        }
        return o;
    }

    public static String cat(double[][] array) {
        if (array == null || array.length == 0 || array[0].length == 0) {
            return "NA";
        }
        String o = Rsession.cat(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + "\n" + Rsession.cat(array[i]);
            }
        }
        return o;
    }

    public static String cat(int[][] array) {
        if (array == null || array.length == 0 || array[0].length == 0) {
            return "NA";
        }
        String o = Rsession.cat(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + "\n" + Rsession.cat(array[i]);
            }
        }
        return o;
    }

    public static String cat(Object[] array) {
        if (array == null || array.length == 0 || array[0] == null) {
            return "";
        }
        String o = array[0].toString();
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + separator + (array[i] == null ? "" : array[i].toString());
            }
        }
        return o;
    }

    public static String cat(String sep, String[] array) {
        if (array == null || array.length == 0 || array[0] == null) {
            return "";
        }
        String o = array[0].toString();
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + sep + (array[i] == null ? "" : array[i].toString());
            }
        }
        return o;
    }

    public static String cat(Object[][] array) {
        if (array == null || array.length == 0 || array[0].length == 0) {
            return "NA";
        }
        String o = Rsession.cat(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + "\n" + Rsession.cat(array[i]);
            }
        }
        return o;
    }

    public static String toRpath(File path) {
        return Rsession.toRpath(path.getAbsolutePath());
    }

    public static String toRpath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static Rsession newLocalInstance(PrintStream console, Properties localRProperties) {
        return new Rsession(console, RserverConf.newLocalInstance(localRProperties), false);
    }

    public static Rsession newRemoteInstance(PrintStream console, RserverConf serverconf) {
        return new Rsession(console, serverconf, false);
    }

    public static Rsession newInstanceTry(PrintStream console, RserverConf serverconf) {
        return new Rsession(console, serverconf, true);
    }

    public Rsession(final PrintStream console, RserverConf serverconf, boolean tryLocalRServe) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Rsession.this.end();
            }
        });
        this.console = console;
        this.RserveConf = serverconf;
        this.tryLocalRServe = tryLocalRServe;
        this.loggers = new LinkedList();
        this.loggers.add(new Logger(){

            @Override
            public void println(String message) {
                console.println(message);
            }
        });
        this.startup();
    }

    void startup() {
        if (this.RserveConf == null) {
            if (this.tryLocalRServe) {
                this.RserveConf = RserverConf.newLocalInstance(null);
                this.println("No Rserve conf given. Trying to use " + this.RserveConf.toString());
                this.begin(true);
            } else {
                this.println("No Rserve conf given. Failed to start session.");
                this.status = STATUS_ERROR;
            }
        } else {
            this.begin(this.tryLocalRServe);
        }
    }

    public String getStatus() {
        return this.status;
    }

    void begin(boolean tryLocal) {
        String message;
        this.status = STATUS_NOT_CONNECTED;
        this.status = STATUS_CONNECTING;
        this.connection = this.RserveConf.connect();
        boolean bl = this.connected = this.connection != null;
        if (!this.connected) {
            this.status = STATUS_ERROR;
            message = "Rserve " + this.RserveConf + " is not accessible.";
            this.println(message);
        } else if (this.connection.getServerVersion() < 103) {
            this.status = STATUS_ERROR;
            message = "Rserve " + this.RserveConf + " version is too low.";
            this.println(message);
        } else {
            this.status = STATUS_READY;
            return;
        }
        if (tryLocal) {
            this.status = STATUS_CONNECTING;
            this.RserveConf = RserverConf.newLocalInstance(this.RserveConf.properties);
            this.println("Trying to spawn " + this.RserveConf.toString());
            this.localRserve = new Rdaemon(this.RserveConf, this);
            String http_proxy = null;
            if (this.RserveConf != null && this.RserveConf.properties != null && this.RserveConf.properties.containsKey("http_proxy")) {
                http_proxy = this.RserveConf.properties.getProperty("http_proxy");
            }
            this.localRserve.start(http_proxy);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            this.connection = this.RserveConf.connect();
            boolean bl2 = this.connected = this.connection != null;
            if (!this.connected) {
                String message2 = "Failed to launch local Rserve. Unable to initialize Rsession.";
                this.println(message2);
                System.err.println(message2);
                throw new IllegalArgumentException(message2);
            }
            this.println("Local Rserve started. (Version " + this.connection.getServerVersion() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        RConnection rConnection = this.connection;
        synchronized (rConnection) {
            if (this.connection == null) {
                this.log("Void session temrinated.");
                return;
            }
            this.log("Ending session...");
            if (System.getProperty("os.name").contains("Win") && this.localRserve != null) {
                this.localRserve.stop();
            } else {
                this.connection.close();
            }
        }
        this.log("Session teminated.");
    }

    public void log(String message) {
        if (message.equals(lastmessage) && repeated < 100) {
            ++repeated;
            return;
        }
        if (repeated > 0) {
            this.println("    Repeated " + repeated + " times.");
            repeated = 0;
            lastmessage = message;
            this.println(message);
        } else {
            lastmessage = message;
            this.println(message);
        }
    }

    public String[] listCommands() {
        this.silentlyEval(".keyWords <- function() {n <- length(search());result <- c();for (i in 2:n) {result <- c(result,ls(pos=i,all.names=TRUE))}; result}");
        REXP rexp = this.silentlyEval(".keyWords()");
        String[] as = null;
        try {
            if (rexp != null && (as = rexp.asStrings()) != null) {
                return as;
            }
            return null;
        }
        catch (REXPMismatchException ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  listCommands()");
            return null;
        }
    }

    public void setCRANRepository(String url) {
        this.repos = url;
    }

    public String getCRANRepository() {
        return this.repos;
    }

    public boolean isPackageLoaded(String pack) {
        this.silentlyVoidEval(loadedpacks + "<-.packages()", false);
        boolean isloaded = false;
        try {
            REXP i = this.silentlyEval("is.element(set=" + loadedpacks + ",el='" + pack + "')");
            if (i != null) {
                isloaded = i.asInteger() == 1;
            }
        }
        catch (REXPMismatchException ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageLoaded(String pack=" + pack + ")");
        }
        if (isloaded) {
            this.log("   package " + pack + " is loaded.");
        } else {
            this.log("   package " + pack + " is not loaded.");
        }
        this.silentlyEval("rm(" + loadedpacks + ")");
        return isloaded;
    }

    public boolean isPackageInstalled(String pack, String version) {
        this.silentlyVoidEval(packs + "<-installed.packages(noCache=TRUE)", false);
        boolean isinstalled = false;
        REXP r = this.silentlyEval("is.element(set=" + packs + ",el='" + pack + "')");
        try {
            if (r != null) {
                isinstalled = r.asInteger() == 1;
            } else {
                this.log("[error] Could not list installed packages\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")");
            }
        }
        catch (REXPMismatchException ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")");
        }
        if (isinstalled) {
            this.log("   package " + pack + " is installed.");
        } else {
            this.log("   package " + pack + " is not installed.");
        }
        if (isinstalled && version != null && version.length() > 0) {
            try {
                isinstalled = this.silentlyEval(packs + "['" + pack + "','Version'] == \"" + version + "\"").asInteger() == 1;
            }
            catch (REXPMismatchException ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")");
            }
            try {
                this.log("    version of package " + pack + " is " + this.silentlyEval(packs + "['" + pack + "','Version']").asString());
            }
            catch (REXPMismatchException ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")");
            }
            if (isinstalled) {
                this.log("   package " + pack + " (" + version + ") " + " is installed.");
            } else {
                this.log("   package " + pack + " (" + version + ") " + " is not installed.");
            }
        }
        this.silentlyEval("rm(" + packs + ")");
        return isinstalled;
    }

    public String installPackages(String[] pack, boolean load) {
        String resall = "";
        for (String pv : pack) {
            String res = this.installPackage(pv, load);
            if (load) {
                if (res.equals(PACKAGELOADED)) continue;
                resall = resall + "\n" + res;
                continue;
            }
            if (res.equals(PACKAGEINSTALLED)) continue;
            resall = resall + "\n" + res;
        }
        if (resall.length() > 0) {
            return resall;
        }
        return load ? PACKAGELOADED : PACKAGEINSTALLED;
    }

    public String installPackage(File pack, boolean load) {
        this.sendFile(pack);
        this.eval("install.packages('" + pack.getName() + "',repos=NULL," + "dependencies=TRUE)");
        this.log("  request package " + pack + " install...");
        String name = pack.getName();
        if (name.contains("_")) {
            name = name.substring(0, name.indexOf("_"));
        }
        if (name.contains(".")) {
            name = name.substring(0, name.indexOf("."));
        }
        if (this.isPackageInstalled(name, null)) {
            this.log("  package " + pack + " installation sucessfull.");
            if (load) {
                return this.loadPackage(name);
            }
            return PACKAGEINSTALLED;
        }
        this.log("  package " + pack + " installation failed.");
        return "Impossible to install package " + pack + " !";
    }

    public String installPackage(final String pack, File dir, boolean load) {
        this.log("  trying to load package " + pack);
        if (this.isPackageInstalled(pack, null)) {
            this.log("  package " + pack + " already installed.");
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log("  package " + pack + " not yet installed.");
        File[] pack_files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.getName().contains(pack)) {
                    return false;
                }
                if (Rsession.this.RServeOSisWindows()) {
                    return pathname.getName().endsWith(".zip");
                }
                if (Rsession.this.RServeOSisLinux()) {
                    return pathname.getName().endsWith(".tar.gz");
                }
                if (Rsession.this.RServeOSisMacOSX()) {
                    return pathname.getName().endsWith(".tgz");
                }
                return false;
            }
        });
        if (pack_files == null || pack_files.length == 0) {
            this.log("  impossible to find package " + pack + " in directory " + dir.getAbsolutePath() + " !");
            return "Impossible to find package " + pack + " in directory " + dir.getAbsolutePath() + " !";
        }
        this.log("  found package " + pack + " : " + pack_files[0].getAbsolutePath());
        this.sendFile(pack_files[0]);
        this.eval("install.packages('" + pack_files[0].getName() + "',repos=NULL," + "dependencies=TRUE)");
        this.log("  request package " + pack + " install...");
        if (this.isPackageInstalled(pack, null)) {
            this.log("  package " + pack + " installation sucessfull.");
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log("  package " + pack + " installation failed.");
        return "Impossible to install package " + pack + " !";
    }

    public String installPackage(String pack, boolean load) {
        this.log("  trying to load package " + pack);
        if (this.isPackageInstalled(pack, null)) {
            this.log("  package " + pack + " already installed.");
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log("  package " + pack + " not yet installed.");
        this.eval("install.packages('" + pack + "',repos='" + this.repos + "'," + "dependencies=TRUE)");
        this.log("  request package " + pack + " install...");
        if (this.isPackageInstalled(pack, null)) {
            this.log("  package " + pack + " installation sucessfull.");
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log("  package " + pack + " installation failed.");
        return "Impossible to install package " + pack + " !";
    }

    public String loadPackage(String pack) {
        this.eval("library(" + pack + ")");
        this.log("  request package " + pack + " loading...");
        if (this.isPackageLoaded(pack)) {
            this.log("  package " + pack + " loading sucessfull.");
            return PACKAGELOADED;
        }
        this.log("  package " + pack + " loading failed.");
        return "Impossible to loading package " + pack + " !";
    }

    public void silentlyVoidEval(String expression) {
        this.silentlyVoidEval(expression, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void silentlyVoidEval(String expression, boolean tryEval) {
        assert (this.connected) : "R environment not initialized.";
        if (expression == null) {
            return;
        }
        if (expression.trim().length() == 0) {
            return;
        }
        for (EvalListener b : this.eval) {
            b.eval(expression);
        }
        try {
            RConnection i$ = this.connection;
            synchronized (i$) {
                this.connection.voidEval((tryEval ? "try(" : "") + expression + (tryEval ? ")" : ""));
            }
        }
        catch (RserveException ex) {
            this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  " + expression);
        }
    }

    public void voidEval(String expression, boolean tryEval) {
        this.log(HEAD_EVAL + expression);
        this.silentlyVoidEval(expression, tryEval);
        for (UpdateObjectsListener b : this.updateObjects) {
            b.update();
        }
    }

    public void voidEval(String expression) {
        this.voidEval(expression, true);
    }

    public REXP silentlyEval(String expression) {
        return this.silentlyEval(expression, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP silentlyEval(String expression, boolean tryEval) {
        assert (this.connected) : "R environment not initialized.";
        if (expression == null) {
            return null;
        }
        if (expression.trim().length() == 0) {
            return null;
        }
        for (EvalListener b : this.eval) {
            b.eval(expression);
        }
        REXP e = null;
        try {
            EvalListener b;
            b = this.connection;
            synchronized (b) {
                e = this.connection.parseAndEval((tryEval ? "try(" : "") + expression + (tryEval ? ",silent=TRUE)" : ""));
            }
        }
        catch (Exception ex) {
            this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  " + expression);
            RConnection rConnection = this.connection;
            synchronized (rConnection) {
                try {
                    this.log("    " + this.connection.parseAndEval("geterrmessage()").toString());
                }
                catch (Exception ex1) {
                    this.log(HEAD_ERROR + ex1.getMessage() + "\n  " + expression);
                }
            }
        }
        if (tryEval && e != null) {
            try {
                if (e.inherits("try-error")) {
                    this.log(HEAD_ERROR + e.asString() + "\n  " + expression);
                    e = null;
                }
            }
            catch (REXPMismatchException ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  " + expression);
                return null;
            }
        }
        return e;
    }

    public REXP eval(String expression, boolean tryEval) {
        this.log(HEAD_EVAL + expression);
        REXP e = this.silentlyEval(expression, tryEval);
        for (UpdateObjectsListener b : this.updateObjects) {
            b.update();
        }
        return e;
    }

    public REXP eval(String expression) {
        return this.eval(expression, true);
    }

    public String getRServeOS() {
        try {
            return this.eval("Sys.info()['sysname']").asString();
        }
        catch (REXPMismatchException re) {
            return "unknown";
        }
    }

    public boolean RServeOSisWindows() {
        return this.getRServeOS().startsWith("Windows");
    }

    public boolean RServeOSisLinux() {
        return this.getRServeOS().startsWith("Linux");
    }

    public boolean RServeOSisMacOSX() {
        return this.getRServeOS().startsWith("Darwin");
    }

    public boolean RServeOSisUnknown() {
        return !this.RServeOSisWindows() && !this.RServeOSisLinux() && !this.RServeOSisMacOSX();
    }

    public void rmAll() {
        this.voidEval("rm(list=ls(all=TRUE))");
    }

    public static String buildList(String ... vars) {
        if (vars.length > 1) {
            StringBuffer b = new StringBuffer("c(");
            for (String v : vars) {
                b.append(v + ",");
            }
            return b.substring(0, b.length() - 1) + ")";
        }
        return vars[0];
    }

    public static String buildListString(String ... vars) {
        if (vars.length > 1) {
            StringBuffer b = new StringBuffer("c(");
            for (String v : vars) {
                b.append("'" + v + "',");
            }
            return b.substring(0, b.length() - 1) + ")";
        }
        return "'" + vars[0] + "'";
    }

    public static String buildListPattern(String ... vars) {
        if (vars.length > 1) {
            StringBuffer b = new StringBuffer("c(");
            for (String v : vars) {
                b.append("ls(pattern='" + v + "'),");
            }
            return b.substring(0, b.length() - 1) + ")";
        }
        return "ls(pattern='" + vars[0] + "')";
    }

    public void source(File f) {
        this.sendFile(f);
        this.voidEval("source('" + f.getName() + "')");
    }

    public void load(File f) {
        this.sendFile(f);
        try {
            assert (this.eval("file.exists('" + f.getName() + "')").asInteger() == 1);
        }
        catch (REXPMismatchException r) {
            r.printStackTrace();
        }
        this.voidEval("load('" + f.getName() + "')");
    }

    public String[] ls() {
        try {
            return this.eval("ls()").asStrings();
        }
        catch (REXPMismatchException re) {
            return new String[0];
        }
    }

    public String[] ls(String ... vars) {
        if (vars == null || vars.length == 0) {
            try {
                return this.eval("ls()").asStrings();
            }
            catch (REXPMismatchException re) {
                return new String[0];
            }
        }
        if (vars.length == 1) {
            try {
                return this.eval(Rsession.buildListPattern(vars[0])).asStrings();
            }
            catch (REXPMismatchException re) {
                return new String[0];
            }
        }
        try {
            return this.eval(Rsession.buildListPattern(vars)).asStrings();
        }
        catch (REXPMismatchException re) {
            return new String[0];
        }
    }

    public void rm(String ... vars) {
        if (vars.length == 1) {
            this.voidEval("rm(" + vars[0] + ")");
        } else {
            this.voidEval("rm(list=" + Rsession.buildListString(vars) + ")");
        }
    }

    public void rmls(String ... vars) {
        if (vars.length == 1) {
            this.voidEval("rm(list=" + Rsession.buildListPattern(vars[0]) + ")");
        } else {
            this.voidEval("rm(list=" + Rsession.buildListPattern(vars) + ")");
        }
    }

    public void save(File f, String ... vars) {
        if (vars.length == 1) {
            this.voidEval("save(file='" + f.getName() + "'," + vars[0] + ",ascii=TRUE)");
        } else {
            this.voidEval("save(file='" + f.getName() + "',list=" + Rsession.buildListString(vars) + ",ascii=TRUE)");
        }
        this.receiveFile(f);
        this.removeFile(f.getName());
    }

    public void savels(File f, String ... vars) {
        if (vars.length == 1) {
            this.voidEval("save(file='" + f.getName() + "',list=" + Rsession.buildListPattern(vars[0]) + ",ascii=TRUE)");
        } else {
            this.voidEval("save(file='" + f.getName() + "',list=" + Rsession.buildListPattern(vars) + ",ascii=TRUE)");
        }
        this.receiveFile(f);
        this.removeFile(f.getName());
    }

    public String typeOf(String robject) {
        if (robject == null) {
            return "NULL";
        }
        for (String t : types) {
            REXP is = this.silentlyEval("is." + t + "(" + robject + ")");
            try {
                if (is == null || is.asInteger() != 1) continue;
                return t;
            }
            catch (REXPMismatchException ex) {
                this.log("[error] [typeOf] " + robject + " type unknown.");
                return null;
            }
        }
        return "unknown";
    }

    public static RList buildRList(double[][] data, String ... names) {
        assert (data[0].length == names.length);
        REXP[] vals = new REXP[names.length];
        for (int i = 0; i < names.length; ++i) {
            double[] coli = new double[data.length];
            for (int j = 0; j < coli.length; ++j) {
                coli[j] = data[j][i];
            }
            vals[i] = new REXPDouble(coli);
        }
        return new RList(vals, names);
    }

    public static RList buildRList(List<double[]> coldata, String ... names) {
        assert (coldata.size() == names.length);
        RList list = new RList(coldata.size(), true);
        for (int i = 0; i < names.length; ++i) {
            list.put((Object)names[i], (Object)new REXPDouble(coldata.get(i)));
        }
        return list;
    }

    public void unset(String ... varname) {
        this.rm(varname);
    }

    public void unset(Collection varname) {
        for (Object v : varname) {
            this.rm(v.toString());
        }
    }

    public void set(HashMap<String, Object> _vars) {
        for (String varname : _vars.keySet()) {
            this.set(varname, _vars.get(varname));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String varname, double[][] data, String ... names) {
        RList list = Rsession.buildRList(data, names);
        this.log(HEAD_SET + varname + " <- " + Rsession.toString(list));
        try {
            RConnection rConnection = this.connection;
            synchronized (rConnection) {
                this.connection.assign(varname, REXP.createDataFrame((RList)list));
            }
        }
        catch (REXPMismatchException re) {
            this.log("[error]  RList " + list.toString() + " not convertible as dataframe.");
        }
        catch (RserveException ex) {
            this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  set(String varname=" + varname + ",double[][] data, String... names)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String varname, Object var) {
        assert (this.connected) : "R environment not initialized. Please make sure that R.init() method was called first.";
        this.log(HEAD_SET + varname + " <- " + var.toString());
        if (var instanceof RList) {
            RList l = (RList)var;
            try {
                RConnection rConnection = this.connection;
                synchronized (rConnection) {
                    this.connection.assign(varname, (REXP)new REXPList(l));
                }
            }
            catch (RserveException ex) {
                this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (RList) var)");
            }
        } else if (var instanceof File) {
            this.silentlyVoidEval(varname + "<-'" + ((File)var).getName() + "'");
        } else if (var instanceof Integer) {
            this.silentlyVoidEval(varname + "<-" + (Integer)var);
        } else if (var instanceof Double) {
            this.silentlyVoidEval(varname + "<-" + (Double)var);
        } else if (var instanceof double[]) {
            try {
                RConnection l = this.connection;
                synchronized (l) {
                    this.connection.assign(varname, (double[])var);
                }
            }
            catch (REngineException ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (double[]) var)");
            }
            this.silentlyVoidEval(varname);
        } else if (var instanceof double[][]) {
            double[][] array = (double[][])var;
            int rows = array.length;
            int col = array[0].length;
            try {
                RConnection rConnection = this.connection;
                synchronized (rConnection) {
                    this.connection.assign("row_" + varname, Rsession.reshapeAsRow(array));
                }
            }
            catch (REngineException ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (double[][]) var)");
            }
            this.silentlyVoidEval(varname + "<-array(row_" + varname + ",c(" + rows + "," + col + "))");
            this.silentlyVoidEval("rm(row_" + varname + ")");
        } else if (var instanceof String) {
            try {
                RConnection array = this.connection;
                synchronized (array) {
                    this.connection.assign(varname, (String)var);
                }
            }
            catch (RserveException ex) {
                this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (String) var)");
            }
            this.silentlyVoidEval(varname);
        } else if (var instanceof String[]) {
            try {
                RConnection ex = this.connection;
                synchronized (ex) {
                    this.connection.assign(varname, (String[])var);
                }
            }
            catch (REngineException ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (String[]) var)");
            }
            this.silentlyVoidEval(varname);
        } else {
            throw new IllegalArgumentException("Variable " + varname + " is not double, double[],  double[][], String or String[]. R engine can not handle.");
        }
    }

    private static double[] reshapeAsRow(double[][] a) {
        double[] reshaped = new double[a.length * a[0].length];
        int ir = 0;
        for (int j = 0; j < a[0].length; ++j) {
            for (int i = 0; i < a.length; ++i) {
                reshaped[ir] = a[i][j];
                ++ir;
            }
        }
        return reshaped;
    }

    public static Object cast(REXP eval) throws REXPMismatchException {
        if (eval == null) {
            return null;
        }
        if (eval.isNumeric()) {
            if (eval.dim() == null || eval.dim().length == 1) {
                double[] array = eval.asDoubles();
                if (array.length == 0) {
                    return null;
                }
                if (array.length == 1) {
                    return array[0];
                }
                return array;
            }
            double[][] mat = eval.asDoubleMatrix();
            if (mat.length == 0) {
                return null;
            }
            if (mat.length == 1) {
                if (mat[0].length == 0) {
                    return null;
                }
                if (mat[0].length == 1) {
                    return mat[0][0];
                }
                return mat[0];
            }
            if (mat[0].length == 0) {
                return null;
            }
            if (mat[0].length == 1) {
                double[] dmat = new double[mat.length];
                for (int i = 0; i < dmat.length; ++i) {
                    dmat[i] = mat[i][0];
                }
                return dmat;
            }
            return mat;
        }
        if (eval.isString()) {
            String[] s = eval.asStrings();
            if (s.length == 1) {
                return s[0];
            }
            return s;
        }
        if (eval.isLogical()) {
            return eval.asInteger() == 1;
        }
        if (eval.isList()) {
            return eval.asList();
        }
        if (eval.isNull()) {
            return null;
        }
        System.err.println("Unsupported type: " + eval.toDebugString());
        return eval.toString();
    }

    public static String castToString(REXP eval) {
        if (eval == null) {
            return "";
        }
        return eval.toString();
    }

    public void toGraphic(File f, int width, int height, String fileformat, String ... commands) {
        int h = Math.abs(f.hashCode());
        this.set("plotfile_" + h, f.getName());
        this.silentlyEval(fileformat + "(plotfile_" + h + ", width=" + width + ", height=" + height + ")");
        for (String command : commands) {
            this.silentlyVoidEval(command);
        }
        this.silentlyEval("dev.off()");
        this.receiveFile(f);
        this.rm("plotfile_" + h);
        this.removeFile(f.getName());
    }

    public void toGraphic(File f, int width, int height, String ... commands) {
        if (f.getName().endsWith(GRAPHIC_BMP)) {
            this.toBMP(f, width, height, commands);
        } else if (f.getName().endsWith(GRAPHIC_JPEG)) {
            this.toJPEG(f, width, height, commands);
        } else if (f.getName().endsWith(GRAPHIC_PNG)) {
            this.toPNG(f, width, height, commands);
        } else if (f.getName().endsWith(GRAPHIC_TIFF)) {
            this.toTIFF(f, width, height, commands);
        } else {
            this.toPNG(f, width, height, commands);
        }
    }

    public void toJPEG(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_JPEG, commands);
    }

    public void toPNG(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_PNG, commands);
    }

    public void toBMP(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_BMP, commands);
    }

    public void toTIFF(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_TIFF, commands);
    }

    public String asR2HTML(String command) {
        this.installPackage("R2HTML", true);
        int h = Math.abs(command.hashCode());
        this.silentlyEval("HTML(file=\"htmlfile_" + h + "\", " + command + ")");
        String[] lines = null;
        try {
            lines = this.silentlyEval("readLines(\"htmlfile_" + h + "\")").asStrings();
        }
        catch (REXPMismatchException e) {
            return e.getMessage();
        }
        this.removeFile("htmlfile_" + h);
        if (lines == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String l : lines) {
            sb.append(l);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String asHTML(String command) {
        return Rsession.toHTML(this.asString(command));
    }

    public static String toHTML(String src) {
        if (src == null) {
            return src;
        }
        src = src.replace("&", "&amp;");
        src = src.replace("\"", "&quot;");
        src = src.replace("'", "&apos;");
        src = src.replace("<", "&lt;");
        src = src.replace(">", "&gt;");
        return "<html>" + src.replace("\n", "<br/>") + "</html>";
    }

    public String asString(String command) {
        try {
            String s = this.silentlyEval("paste(capture.output(print(" + command + ")),collapse='\\n')").asString();
            return s;
        }
        catch (REXPMismatchException ex) {
            return ex.getMessage();
        }
    }

    public void receiveFile(File localfile) {
        this.receiveFile(localfile, localfile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFile(File localfile, String remoteFile) {
        try {
            for (int i = 10; i > 0 && this.silentlyEval("file.exists('" + remoteFile + "')").asInteger() != 1; --i) {
                Thread.sleep(1000L);
            }
            if (this.silentlyEval("file.exists('" + remoteFile + "')").asInteger() != 1) {
                this.log("[error] [IO] file " + remoteFile + " not found.");
            }
        }
        catch (Exception ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  getFile(File localfile=" + localfile.getAbsolutePath() + ", String remoteFile=" + remoteFile + ")");
            return;
        }
        if (localfile.exists()) {
            localfile.delete();
            if (!localfile.exists()) {
                this.log("[IO] Local file " + localfile.getAbsolutePath() + " deleted.");
            } else {
                this.log("[error] [IO] file " + localfile + " still exists !");
                return;
            }
        }
        RFileInputStream is = null;
        FileOutputStream os = null;
        RConnection rConnection = this.connection;
        synchronized (rConnection) {
            try {
                is = this.connection.openFile(remoteFile);
                os = new FileOutputStream(localfile);
                byte[] buf = new byte[this.SEND_BUFFER_SIZE];
                try {
                    this.connection.setSendBufferSize((long)buf.length);
                }
                catch (RserveException ex) {
                    this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  getFile(File localfile=" + localfile.getAbsolutePath() + ", String remoteFile=" + remoteFile + ")");
                }
                int n = 0;
                while ((n = is.read(buf)) > 0) {
                    os.write(buf, 0, n);
                }
            }
            catch (IOException e) {
                this.log("[error] [IO] " + this.connection.getLastError() + ": file " + remoteFile + " not found.\n" + e.getMessage());
                return;
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ee) {
                    ee.printStackTrace();
                }
            }
        }
        this.log("[IO] File " + remoteFile + " received.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(String remoteFile) {
        try {
            RConnection rConnection = this.connection;
            synchronized (rConnection) {
                this.connection.removeFile(remoteFile);
            }
        }
        catch (RserveException ex) {
            this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  removeFile(String remoteFile=" + remoteFile + ")");
        }
    }

    public void sendFile(File localfile) {
        this.sendFile(localfile, localfile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(File localfile, String remoteFile) {
        if (!localfile.exists()) {
            RConnection rConnection = this.connection;
            synchronized (rConnection) {
                this.log("[error] [IO] " + this.connection.getLastError() + "\n  file " + localfile.getAbsolutePath() + " does not exists.");
            }
        }
        try {
            if (this.silentlyEval("file.exists('" + remoteFile + "')").asInteger() == 1) {
                this.silentlyVoidEval("file.remove('" + remoteFile + "')");
                this.log("[IO] Remote file " + remoteFile + " deleted.");
            }
        }
        catch (REXPMismatchException ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  putFile(File localfile=" + localfile.getAbsolutePath() + ", String remoteFile=" + remoteFile + ")");
            return;
        }
        FileInputStream is = null;
        RFileOutputStream os = null;
        RConnection rConnection = this.connection;
        synchronized (rConnection) {
            try {
                os = this.connection.createFile(remoteFile);
                is = new FileInputStream(localfile);
                byte[] buf = new byte[this.SEND_BUFFER_SIZE];
                try {
                    this.connection.setSendBufferSize((long)buf.length);
                }
                catch (RserveException ex) {
                    this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  putFile(File localfile=" + localfile.getAbsolutePath() + ", String remoteFile=" + remoteFile + ")");
                }
                int n = 0;
                while ((n = is.read(buf)) > 0) {
                    os.write(buf, 0, n);
                }
            }
            catch (IOException e) {
                this.log("[error] [IO] " + this.connection.getLastError() + ": file " + remoteFile + " not writable.\n" + e.getMessage());
                return;
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ee) {
                    ee.printStackTrace();
                }
            }
        }
        this.log("[IO] File " + remoteFile + " sent.");
    }

    public synchronized Object proxyEval(String expression, HashMap<String, Object> vars) throws Exception {
        if (expression.length() == 0) {
            return null;
        }
        try {
            this.log("[cache] No evaluation needed for " + expression);
            return Double.parseDouble(expression);
        }
        catch (NumberFormatException ne) {
            if (!Rsession.uses(expression, vars) && this.noVarsEvals.containsKey(expression)) {
                this.log("[cache] Cached evaluation of " + expression + " in " + this.noVarsEvals);
                return this.noVarsEvals.get(expression);
            }
            if (vars != null && vars.containsKey(expression)) {
                this.log("[cache] Get evaluation of " + expression + " in " + vars);
                return vars.get(expression);
            }
            HashMap<String, Object> clean_vars = new HashMap<String, Object>();
            String clean_expression = expression;
            if (vars != null) {
                for (String v : vars.keySet()) {
                    if (vars.get(v) instanceof Number) {
                        while (Rsession.containsVar(clean_expression, v)) {
                            clean_expression = Rsession.replaceVar(clean_expression, v, "(" + vars.get(v) + ")");
                        }
                        this.log("[cache] Replacing " + v + " in " + clean_expression);
                        continue;
                    }
                    if (!Rsession.containsVar(clean_expression, v)) continue;
                    String newvarname = v;
                    while (this.ls(newvarname).length > 0) {
                        newvarname = "_" + newvarname;
                    }
                    this.log("[cache] Renaming " + v + " by " + newvarname + " in " + clean_expression);
                    while (Rsession.containsVar(clean_expression, v)) {
                        clean_expression = Rsession.replaceVar(clean_expression, v, newvarname);
                    }
                    clean_vars.put(newvarname, vars.get(v));
                }
            }
            if (!Rsession.uses(clean_expression, clean_vars) && this.noVarsEvals.containsKey(clean_expression)) {
                this.log("[cache] Cached evaluation of " + expression + " in " + this.noVarsEvals);
                return this.noVarsEvals.get(clean_expression);
            }
            Object out = null;
            try {
                if (Rsession.uses(clean_expression, clean_vars)) {
                    this.set(clean_vars);
                }
                this.log("[cache] True evaluation of " + clean_expression + " with " + clean_vars);
                REXP exp = this.eval(clean_expression);
                out = Rsession.cast(exp);
                if (clean_vars.isEmpty() && out != null) {
                    this.log("[cache] Saving result of " + clean_expression);
                    this.noVarsEvals.put(clean_expression, out);
                }
                if (!Rsession.uses(expression, vars) && out != null) {
                    this.log("[cache] Saving result of " + expression);
                    this.noVarsEvals.put(expression, out);
                }
            }
            catch (Exception e) {
                this.log("[cache] Failed cast of " + expression);
                throw new Exception(CAST_ERROR + expression + ": " + e.getMessage());
            }
            finally {
                if (Rsession.uses(clean_expression, clean_vars)) {
                    this.unset(clean_vars.keySet());
                }
            }
            if (out == null) {
                boolean restartR = false;
                try {
                    REXP testEval = this.eval(testExpression);
                    double testOut = (Double)Rsession.cast(testEval);
                    if (testOut == Double.NaN || Math.abs(testOut - 4.141592653589793) > 0.1) {
                        restartR = true;
                    }
                }
                catch (Exception e) {
                    restartR = true;
                }
                if (restartR) {
                    System.err.println("Problem occured, R engine restarted.");
                    this.log("[cache] Problem occured, R engine restarted.");
                    this.end();
                    this.startup();
                    return this.proxyEval(expression, vars);
                }
            }
            return out;
        }
    }

    static String replaceVar(String expr, String var, String val) {
        String regexp = AW + var + Az;
        Matcher m = Pattern.compile(regexp).matcher(expr);
        if (m.find()) {
            return expr.replace(m.group(), m.group().replace(var, val));
        }
        return expr;
    }

    static boolean containsVar(String expr, String var) {
        String regexp = AW + var + Az;
        Matcher m = Pattern.compile(regexp).matcher(expr);
        return m.find();
    }

    static boolean areUsed(String expression, Set<String> vars) {
        for (String v : vars) {
            if (!Rsession.containsVar(expression, v)) continue;
            return true;
        }
        return false;
    }

    static boolean uses(String expression, HashMap<String, Object> vars) {
        return vars != null && !vars.isEmpty() && Rsession.areUsed(expression, vars.keySet());
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            args = new String[]{testExpression};
        }
        Rsession R = null;
        int i = 0;
        if (args[0].startsWith("R://")) {
            ++i;
            R = Rsession.newInstanceTry(System.out, RserverConf.parse(args[0]));
        } else {
            R = Rsession.newInstanceTry(System.out, null);
        }
        for (int j = i; j < args.length; ++j) {
            System.out.println(Rsession.castToString(R.eval(args[j])));
        }
    }
}

