/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.Properties;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class RserverConf {
    public static String DEFAULT_RSERVE_HOST = "localhost";
    RConnection connection;
    public String host;
    public int port;
    public String login;
    public String password;
    public Properties properties;
    public static long CONNECT_TIMEOUT = 1000L;
    public static final int RserverDefaultPort = 6311;
    private static int RserverPort = 6311;
    public static final String RURL_START = "R://";

    public RserverConf(String RserverHostName, int RserverPort, String login, String password, Properties props) {
        this.host = RserverHostName;
        this.port = RserverPort;
        this.login = login;
        this.password = password;
        this.properties = props;
    }

    public synchronized RConnection connect() {
        System.err.print("Connecting " + this.toString() + " ... ");
        TimeOut t = new TimeOut(){

            @Override
            protected Object defaultResult() {
                return -2;
            }

            @Override
            protected Object command() {
                try {
                    if (RserverConf.this.host == null) {
                        RserverConf.this.connection = RserverConf.this.port > 0 ? new RConnection(DEFAULT_RSERVE_HOST, RserverConf.this.port) : new RConnection();
                        if (RserverConf.this.connection.needLogin()) {
                            RserverConf.this.connection.login(RserverConf.this.login, RserverConf.this.password);
                        }
                    } else {
                        RserverConf.this.connection = RserverConf.this.port > 0 ? new RConnection(RserverConf.this.host, RserverConf.this.port) : new RConnection(RserverConf.this.host);
                        if (RserverConf.this.connection.needLogin()) {
                            RserverConf.this.connection.login(RserverConf.this.login, RserverConf.this.password);
                        }
                    }
                    System.err.println("ok");
                    return 0;
                }
                catch (RserveException ex) {
                    System.err.println("no: " + ex.getMessage());
                    return -1;
                }
            }
        };
        try {
            t.execute(CONNECT_TIMEOUT);
        }
        catch (Exception e) {
            System.err.println("  failed: " + e.getMessage());
        }
        if (this.connection != null && this.connection.isConnected()) {
            if (this.properties != null) {
                for (String p : this.properties.stringPropertyNames()) {
                    try {
                        this.connection.eval("Sys.setenv(" + p + "=" + this.properties.getProperty(p) + ")");
                    }
                    catch (RserveException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            System.err.println("Connection " + this.toString() + " succeded.");
            return this.connection;
        }
        System.err.println("Connection " + this.toString() + " failed.");
        return null;
    }

    public static boolean isPortAvailable(int p) {
        try {
            ServerSocket test = new ServerSocket(p);
            test.close();
        }
        catch (BindException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static RserverConf newLocalInstance(Properties p) {
        RserverConf server = null;
        if (System.getProperty("os.name").contains("Win")) {
            while (!RserverConf.isPortAvailable(RserverPort)) {
                ++RserverPort;
            }
            server = new RserverConf(null, RserverPort, null, null, p);
        } else {
            server = new RserverConf(null, -1, null, null, p);
        }
        return server;
    }

    public boolean isLocal() {
        return this.host == null || this.host.equals(DEFAULT_RSERVE_HOST) || this.host.equals("127.0.0.1");
    }

    public String toString() {
        return RURL_START + (this.login != null ? this.login + ":" + this.password + "@" : "") + (this.host == null ? DEFAULT_RSERVE_HOST : this.host) + (this.port > 0 ? ":" + this.port : "");
    }

    public static RserverConf parse(String RURL) {
        String login = null;
        String passwd = null;
        String host = null;
        int port = -1;
        try {
            String hostport = null;
            if (RURL.contains("@")) {
                String loginpasswd = RURL.split("@")[0].substring(RURL_START.length());
                login = loginpasswd.split(":")[0];
                if (login.equals("user.name")) {
                    login = System.getProperty("user.name");
                }
                passwd = loginpasswd.split(":")[1];
                hostport = RURL.split("@")[1];
            } else {
                hostport = RURL.substring(RURL_START.length());
            }
            if (hostport.contains(":")) {
                host = hostport.split(":")[0];
                port = Integer.parseInt(hostport.split(":")[1]);
            } else {
                host = hostport;
            }
            return new RserverConf(host, port, login, passwd, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Impossible to parse " + RURL + ":\n  host=" + host + "\n  port=" + port + "\n  login=" + login + "\n  password=" + passwd);
        }
    }

    public abstract class TimeOut {
        private boolean timedOut = false;
        private Object result = null;

        public Object getResult() {
            return this.result;
        }

        protected TimeOut() {
        }

        public synchronized void execute(long timeout) throws TimeOutException {
            new Thread(new TimeoutThread()).start();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                if (this.getResult() == null) {
                    this.timedOut = true;
                    this.result = this.defaultResult();
                    throw new TimeOutException("timed out");
                }
                return;
            }
            if (this.getResult() != null) {
                return;
            }
            this.timedOut = true;
            this.result = this.defaultResult();
            throw new TimeOutException("timed out");
        }

        protected abstract Object defaultResult();

        protected abstract Object command();

        private class TimeoutThread
        implements Runnable {
            private TimeoutThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object res = TimeOut.this.command();
                TimeOut timeOut = TimeOut.this;
                synchronized (timeOut) {
                    if (!TimeOut.this.timedOut || res == null) {
                        TimeOut.this.result = res;
                        TimeOut.this.notify();
                    }
                }
            }
        }

        public class TimeOutException
        extends Exception {
            public TimeOutException(String why) {
                super(why);
            }
        }
    }
}

