/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathUtils {
    private static XPathFactory xpathFactory = XPathFactory.newInstance();
    private XPath xpath = xpathFactory.newXPath();

    public XPathUtils() {
    }

    public XPathUtils(Map<String, String> ns) {
        this();
        if (ns != null) {
            this.xpath.setNamespaceContext(new MapNamespaceContext(ns));
        }
    }

    public XPathUtils(NamespaceContext ctx) {
        this();
        this.xpath.setNamespaceContext(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(String xpathExpression, Node node, QName type) {
        ClassLoaderUtils.ClassLoaderHolder loader = ClassLoaderUtils.setThreadContextClassloader(this.xpath.getClass().getClassLoader());
        try {
            Object object = this.xpath.evaluate(xpathExpression, node, type);
            Object var8_7 = null;
            if (loader != null) {
                loader.reset();
            }
            return object;
        }
        catch (Exception e) {
            try {
                Object var6_10 = null;
                Object var8_8 = null;
                if (loader != null) {
                    loader.reset();
                }
                return var6_10;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_9 = null;
                    if (loader == null) break block6;
                    loader.reset();
                }
                throw throwable;
            }
        }
    }

    public NodeList getValueList(String xpathExpression, Node node) {
        return (NodeList)this.getValue(xpathExpression, node, XPathConstants.NODESET);
    }

    public String getValueString(String xpathExpression, Node node) {
        return (String)this.getValue(xpathExpression, node, XPathConstants.STRING);
    }

    public Node getValueNode(String xpathExpression, Node node) {
        return (Node)this.getValue(xpathExpression, node, XPathConstants.NODE);
    }

    public boolean isExist(String xpathExpression, Node node, QName type) {
        return this.getValue(xpathExpression, node, type) != null;
    }
}

