/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.jmeter.util.SlowInputStream;
import org.apache.jmeter.util.SlowOutputStream;

public class SlowSocket
extends Socket {
    private final int CPS;

    public SlowSocket(int cps, String host, int port, InetAddress localAddress, int localPort, int timeout) throws IOException {
        if (cps <= 0) {
            throw new IllegalArgumentException("Speed (cps) <= 0");
        }
        this.CPS = cps;
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        this.bind(localaddr);
        this.connect(remoteaddr, timeout);
    }

    public SlowSocket(int cps, String host, int port, InetAddress localAddr, int localPort) throws IOException {
        super(host, port, localAddr, localPort);
        if (cps <= 0) {
            throw new IllegalArgumentException("Speed (cps) <= 0");
        }
        this.CPS = cps;
    }

    public SlowSocket(int cps, String host, int port) throws UnknownHostException, IOException {
        super(host, port);
        if (cps <= 0) {
            throw new IllegalArgumentException("Speed (cps) <= 0");
        }
        this.CPS = cps;
    }

    public SlowSocket(int cps) {
        this.CPS = cps;
    }

    public OutputStream getOutputStream() throws IOException {
        return new SlowOutputStream(super.getOutputStream(), this.CPS);
    }

    public InputStream getInputStream() throws IOException {
        return new SlowInputStream(super.getInputStream(), this.CPS);
    }
}

