/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditorSupport;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import org.apache.jmeter.util.JMeterUtils;

class ComboStringEditor
extends PropertyEditorSupport
implements ItemListener {
    private String[] tags = new String[0];
    private boolean noUndefined = false;
    private boolean noEdit = false;
    private String initialEditValue;
    private final JComboBox combo;
    private final DefaultComboBoxModel model = new DefaultComboBoxModel();
    private boolean startingEdit = false;
    static final Object UNDEFINED = new UniqueObject(JMeterUtils.getResString("property_undefined"));
    private static final Object EDIT = new UniqueObject(JMeterUtils.getResString("property_edit"));

    ComboStringEditor() {
        this.model.addElement(UNDEFINED);
        this.model.addElement(EDIT);
        this.combo = new JComboBox(this.model);
        this.combo.addItemListener(this);
        this.combo.setEditable(false);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this.combo;
    }

    public Object getValue() {
        return this.getAsText();
    }

    public String getAsText() {
        Object value = this.combo.getSelectedItem();
        if (value == UNDEFINED) {
            return null;
        }
        return (String)value;
    }

    public void setValue(Object value) {
        this.setAsText((String)value);
    }

    public void setAsText(String value) {
        this.combo.setEditable(true);
        if (value == null) {
            this.combo.setSelectedItem(UNDEFINED);
        } else {
            this.combo.setSelectedItem(value);
        }
        if (!this.startingEdit && this.combo.getSelectedIndex() >= 0) {
            this.combo.setEditable(false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getItem() == EDIT) {
                this.startingEdit = true;
                this.startEditing();
                this.startingEdit = false;
            } else {
                if (!this.startingEdit && this.combo.getSelectedIndex() >= 0) {
                    this.combo.setEditable(false);
                }
                this.firePropertyChange();
            }
        }
    }

    private void startEditing() {
        JTextComponent textField = (JTextComponent)this.combo.getEditor().getEditorComponent();
        this.combo.setEditable(true);
        textField.requestFocus();
        String text = this.initialEditValue;
        if (this.initialEditValue == null) {
            text = "";
        }
        this.combo.setSelectedItem(text);
        int i = text.indexOf("${}");
        if (i != -1) {
            textField.setCaretPosition(i + 2);
        } else {
            textField.selectAll();
        }
    }

    public String getInitialEditValue() {
        return this.initialEditValue;
    }

    public boolean getNoEdit() {
        return this.noEdit;
    }

    public boolean getNoUndefined() {
        return this.noUndefined;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setInitialEditValue(String object) {
        this.initialEditValue = object;
    }

    public void setNoEdit(boolean b) {
        if (this.noEdit == b) {
            return;
        }
        this.noEdit = b;
        if (this.noEdit) {
            this.model.removeElement(EDIT);
        } else {
            this.model.addElement(EDIT);
        }
    }

    public void setNoUndefined(boolean b) {
        if (this.noUndefined == b) {
            return;
        }
        this.noUndefined = b;
        if (this.noUndefined) {
            this.model.removeElement(UNDEFINED);
        } else {
            this.model.insertElementAt(UNDEFINED, 0);
        }
    }

    public void setTags(String[] strings) {
        if (Arrays.equals(this.tags, strings)) {
            return;
        }
        for (int i = 0; i < this.tags.length; ++i) {
            this.model.removeElement(this.tags[i]);
        }
        this.tags = strings == null ? new String[]{} : strings;
        int b = this.noUndefined ? 0 : 1;
        for (int i = 0; i < this.tags.length; ++i) {
            this.model.insertElementAt(this.tags[i], b + i);
        }
    }

    private static class UniqueObject {
        private final String s;

        UniqueObject(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

