/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class SampleResult
implements Serializable {
    private static final long serialVersionUID = 241L;
    static final Logger log = LoggingManager.getLoggerForClass();
    public static final String DEFAULT_HTTP_ENCODING = "ISO-8859-1";
    static final String DEFAULT_ENCODING = JMeterUtils.getPropDefault("sampleresult.default.encoding", "ISO-8859-1");
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    public static final String TEXT = "text";
    public static final String BINARY = "bin";
    private static final byte[] EMPTY_BA = new byte[0];
    private static final SampleResult[] EMPTY_SR = new SampleResult[0];
    private static final AssertionResult[] EMPTY_AR = new AssertionResult[0];
    private static final boolean GETBYTES_BODY_REALSIZE = JMeterUtils.getPropDefault("sampleresult.getbytes.body_real_size", true);
    private static final boolean GETBYTES_HEADERS_SIZE = JMeterUtils.getPropDefault("sampleresult.getbytes.headers_size", true);
    private static final boolean GETBYTES_NETWORK_SIZE = GETBYTES_HEADERS_SIZE && GETBYTES_BODY_REALSIZE;
    private SampleSaveConfiguration saveConfig;
    private SampleResult parent = null;
    private byte[] responseData = EMPTY_BA;
    private String responseCode = "";
    private String label = "";
    private String resultFileName = "";
    private String samplerData;
    private String threadName = "";
    private String responseMessage = "";
    private String responseHeaders = "";
    private String contentType = "";
    private String requestHeaders = "";
    private long timeStamp = 0L;
    private long startTime = 0L;
    private long endTime = 0L;
    private long idleTime = 0L;
    private long pauseTime = 0L;
    private List<AssertionResult> assertionResults;
    private List<SampleResult> subResults;
    private String dataType = "";
    private boolean success;
    private final Set<String> files = new HashSet<String>();
    private String dataEncoding;
    private long time = 0L;
    private long latency = 0L;
    private boolean stopThread = false;
    private boolean stopTest = false;
    private boolean stopTestNow = false;
    private boolean isMonitor = false;
    private int sampleCount = 1;
    private int bytes = 0;
    private int headersSize = 0;
    private int bodySize = 0;
    private volatile int groupThreads = 0;
    private volatile int allThreads = 0;
    private static final boolean startTimeStamp = JMeterUtils.getPropDefault("sampleresult.timestamp.start", false);
    static final boolean USENANOTIME = JMeterUtils.getPropDefault("sampleresult.useNanoTime", true);
    private static final long NANOTHREAD_SLEEP = JMeterUtils.getPropDefault("sampleresult.nanoThreadSleep", 5000);
    private final long nanoTimeOffset;
    final boolean useNanoTime;
    final long nanoThreadSleep;
    private static final String OK_CODE;
    private static final String OK_MSG = "OK";
    private static final String[] BINARY_TYPES;
    private URL location;

    public void setSaveConfig(SampleSaveConfiguration propertiesToSave) {
        this.saveConfig = propertiesToSave;
    }

    public SampleSaveConfiguration getSaveConfig() {
        return this.saveConfig;
    }

    private long initOffset() {
        if (this.useNanoTime) {
            return this.nanoThreadSleep > 0L ? NanoOffset.getNanoOffset() : System.currentTimeMillis() - SampleResult.sampleNsClockInMs();
        }
        return Long.MIN_VALUE;
    }

    public SampleResult() {
        this(USENANOTIME, NANOTHREAD_SLEEP);
    }

    SampleResult(boolean nanoTime) {
        this(nanoTime, NANOTHREAD_SLEEP);
    }

    SampleResult(boolean nanoTime, long nanoThreadSleep) {
        this.useNanoTime = nanoTime;
        this.nanoThreadSleep = nanoThreadSleep;
        this.nanoTimeOffset = this.initOffset();
    }

    public SampleResult(SampleResult res) {
        this();
        this.allThreads = res.allThreads;
        this.assertionResults = res.assertionResults;
        this.bytes = res.bytes;
        this.headersSize = res.headersSize;
        this.bodySize = res.bodySize;
        this.contentType = res.contentType;
        this.dataEncoding = res.dataEncoding;
        this.dataType = res.dataType;
        this.endTime = res.endTime;
        this.groupThreads = res.groupThreads;
        this.idleTime = res.idleTime;
        this.isMonitor = res.isMonitor;
        this.label = res.label;
        this.latency = res.latency;
        this.location = res.location;
        this.parent = res.parent;
        this.pauseTime = res.pauseTime;
        this.requestHeaders = res.requestHeaders;
        this.responseCode = res.responseCode;
        this.responseData = res.responseData;
        this.responseHeaders = res.responseHeaders;
        this.responseMessage = res.responseMessage;
        this.sampleCount = res.sampleCount;
        this.samplerData = res.samplerData;
        this.saveConfig = res.saveConfig;
        this.startTime = res.startTime;
        this.stopTest = res.stopTest;
        this.stopTestNow = res.stopTestNow;
        this.stopThread = res.stopThread;
        this.subResults = res.subResults;
        this.success = res.success;
        this.threadName = res.threadName;
        this.time = res.time;
        this.timeStamp = res.timeStamp;
    }

    public boolean isStampedAtStart() {
        return startTimeStamp;
    }

    protected SampleResult(long elapsed, boolean atend) {
        this();
        long now = this.currentTimeInMillis();
        if (atend) {
            this.setTimes(now - elapsed, now);
        } else {
            this.setTimes(now, now + elapsed);
        }
    }

    public static SampleResult createTestSample(long start, long end) {
        SampleResult res = new SampleResult();
        res.setStartTime(start);
        res.setEndTime(end);
        return res;
    }

    public static SampleResult createTestSample(long elapsed) {
        long now = System.currentTimeMillis();
        return SampleResult.createTestSample(now, now + elapsed);
    }

    public SampleResult(long stamp, long elapsed) {
        this();
        this.stampAndTime(stamp, elapsed);
    }

    private static long sampleNsClockInMs() {
        return System.nanoTime() / 1000000L;
    }

    public long currentTimeInMillis() {
        if (this.useNanoTime) {
            if (this.nanoTimeOffset == Long.MIN_VALUE) {
                throw new RuntimeException("Invalid call; nanoTimeOffset as not been set");
            }
            return SampleResult.sampleNsClockInMs() + this.nanoTimeOffset;
        }
        return System.currentTimeMillis();
    }

    private void stampAndTime(long stamp, long elapsed) {
        if (startTimeStamp) {
            this.startTime = stamp;
            this.endTime = stamp + elapsed;
        } else {
            this.startTime = stamp - elapsed;
            this.endTime = stamp;
        }
        this.timeStamp = stamp;
        this.time = elapsed;
    }

    public void setStampAndTime(long stamp, long elapsed) {
        if (this.startTime != 0L || this.endTime != 0L) {
            throw new RuntimeException("Calling setStampAndTime() after start/end times have been set");
        }
        this.stampAndTime(stamp, elapsed);
    }

    public synchronized boolean markFile(String filename) {
        return !this.files.add(filename);
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCodeOK() {
        this.responseCode = OK_CODE;
    }

    public void setResponseCode(String code) {
        this.responseCode = code;
    }

    public boolean isResponseCodeOK() {
        return this.responseCode.equals(OK_CODE);
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String msg) {
        this.responseMessage = msg;
    }

    public void setResponseMessageOK() {
        this.responseMessage = OK_MSG;
    }

    public void setResponseOK() {
        this.setResponseCodeOK();
        this.setResponseMessageOK();
        this.setSuccessful(true);
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getSampleLabel() {
        return this.label;
    }

    public String getSampleLabel(boolean includeGroup) {
        if (includeGroup) {
            StringBuilder sb = new StringBuilder(this.threadName.substring(0, this.threadName.lastIndexOf(32)));
            return sb.append(":").append(this.label).toString();
        }
        return this.label;
    }

    public void setSampleLabel(String label) {
        this.label = label;
    }

    public void addAssertionResult(AssertionResult assertResult) {
        if (this.assertionResults == null) {
            this.assertionResults = new ArrayList<AssertionResult>();
        }
        this.assertionResults.add(assertResult);
    }

    public AssertionResult[] getAssertionResults() {
        if (this.assertionResults == null) {
            return EMPTY_AR;
        }
        return this.assertionResults.toArray(new AssertionResult[this.assertionResults.size()]);
    }

    public void addSubResult(SampleResult subResult) {
        String tn = this.getThreadName();
        if (tn.length() == 0) {
            tn = Thread.currentThread().getName();
            this.setThreadName(tn);
        }
        subResult.setThreadName(tn);
        this.setEndTime(Math.max(this.getEndTime(), subResult.getEndTime() + this.nanoTimeOffset - subResult.nanoTimeOffset));
        this.setBytes(this.getBytes() + subResult.getBytes());
        this.setHeadersSize(this.getHeadersSize() + subResult.getHeadersSize());
        this.setBodySize(this.getBodySize() + subResult.getBodySize());
        this.addRawSubResult(subResult);
    }

    public void addRawSubResult(SampleResult subResult) {
        if (this.subResults == null) {
            this.subResults = new ArrayList<SampleResult>();
        }
        this.subResults.add(subResult);
        subResult.setParent(this);
    }

    public void storeSubResult(SampleResult subResult) {
        if (this.subResults == null) {
            this.subResults = new ArrayList<SampleResult>();
        }
        this.subResults.add(subResult);
        subResult.setParent(this);
    }

    public SampleResult[] getSubResults() {
        if (this.subResults == null) {
            return EMPTY_SR;
        }
        return this.subResults.toArray(new SampleResult[this.subResults.size()]);
    }

    public void setResponseData(byte[] response) {
        this.responseData = response == null ? EMPTY_BA : response;
    }

    @Deprecated
    public void setResponseData(String response) {
        try {
            this.responseData = response.getBytes(this.getDataEncodingWithDefault());
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Could not convert string, using default encoding. " + e.getLocalizedMessage());
            this.responseData = response.getBytes();
        }
    }

    public void setResponseData(String response, String encoding) {
        String encodeUsing = encoding != null ? encoding : DEFAULT_CHARSET;
        try {
            this.responseData = response.getBytes(encodeUsing);
            this.setDataEncoding(encodeUsing);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Could not convert string using '" + encodeUsing + "', using default encoding: " + DEFAULT_CHARSET, (Throwable)e);
            this.responseData = response.getBytes();
            this.setDataEncoding(DEFAULT_CHARSET);
        }
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    public String getResponseDataAsString() {
        try {
            return new String(this.responseData, this.getDataEncodingWithDefault());
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Using platform default as " + this.getDataEncodingWithDefault() + " caused " + e);
            return new String(this.responseData);
        }
    }

    public void setSamplerData(String s) {
        this.samplerData = s;
    }

    public String getSamplerData() {
        return this.samplerData;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setEncodingAndType(String ct) {
        if (ct != null) {
            String CS_PFX = "charset=";
            int cset = ct.toLowerCase(Locale.ENGLISH).indexOf("charset=");
            if (cset >= 0) {
                String charSet = ct.substring(cset + "charset=".length());
                int semiColon = charSet.indexOf(59);
                if (semiColon >= 0) {
                    charSet = charSet.substring(0, semiColon);
                }
                if (charSet.startsWith("\"")) {
                    this.setDataEncoding(charSet.substring(1, charSet.length() - 1));
                } else {
                    this.setDataEncoding(charSet);
                }
            }
            if (SampleResult.isBinaryType(ct)) {
                this.setDataType(BINARY);
            } else {
                this.setDataType(TEXT);
            }
        }
    }

    private static boolean isBinaryType(String ct) {
        for (int i = 0; i < BINARY_TYPES.length; ++i) {
            if (!ct.startsWith(BINARY_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    public void setSuccessful(boolean success) {
        this.success = success;
    }

    public String toString() {
        return this.getSampleLabel();
    }

    public String getDataEncodingWithDefault() {
        return this.getDataEncodingWithDefault(DEFAULT_ENCODING);
    }

    protected String getDataEncodingWithDefault(String defaultEncoding) {
        if (this.dataEncoding != null && this.dataEncoding.length() > 0) {
            return this.dataEncoding;
        }
        return defaultEncoding;
    }

    public String getDataEncodingNoDefault() {
        return this.dataEncoding;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public boolean isStopTest() {
        return this.stopTest;
    }

    public boolean isStopTestNow() {
        return this.stopTestNow;
    }

    public boolean isStopThread() {
        return this.stopThread;
    }

    public void setStopTest(boolean b) {
        this.stopTest = b;
    }

    public void setStopTestNow(boolean b) {
        this.stopTestNow = b;
    }

    public void setStopThread(boolean b) {
        this.stopThread = b;
    }

    public String getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setRequestHeaders(String string) {
        this.requestHeaders = string;
    }

    public void setResponseHeaders(String string) {
        this.responseHeaders = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getMediaType() {
        return JOrphanUtils.trim((String)this.contentType, (String)" ;").toLowerCase(Locale.ENGLISH);
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected final void setStartTime(long start) {
        this.startTime = start;
        if (startTimeStamp) {
            this.timeStamp = this.startTime;
        }
    }

    public void setEndTime(long end) {
        this.endTime = end;
        if (!startTimeStamp) {
            this.timeStamp = this.endTime;
        }
        if (this.startTime == 0L) {
            log.error("setEndTime must be called after setStartTime", new Throwable("Invalid call sequence"));
        } else {
            this.time = this.endTime - this.startTime - this.idleTime;
        }
    }

    public void setIdleTime(long idle) {
        this.idleTime = idle;
    }

    private void setTimes(long start, long end) {
        this.setStartTime(start);
        this.setEndTime(end);
    }

    public void sampleStart() {
        if (this.startTime == 0L) {
            this.setStartTime(this.currentTimeInMillis());
        } else {
            log.error("sampleStart called twice", new Throwable("Invalid call sequence"));
        }
    }

    public void sampleEnd() {
        if (this.endTime == 0L) {
            this.setEndTime(this.currentTimeInMillis());
        } else {
            log.error("sampleEnd called twice", new Throwable("Invalid call sequence"));
        }
    }

    public void samplePause() {
        if (this.pauseTime != 0L) {
            log.error("samplePause called twice", new Throwable("Invalid call sequence"));
        }
        this.pauseTime = this.currentTimeInMillis();
    }

    public void sampleResume() {
        if (this.pauseTime == 0L) {
            log.error("sampleResume without samplePause", new Throwable("Invalid call sequence"));
        }
        this.idleTime += this.currentTimeInMillis() - this.pauseTime;
        this.pauseTime = 0L;
    }

    public void setMonitor(boolean monitor) {
        this.isMonitor = monitor;
    }

    public boolean isMonitor() {
        return this.isMonitor;
    }

    public void setSampleCount(int count) {
        this.sampleCount = count;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public int getErrorCount() {
        return this.success ? 0 : 1;
    }

    public void setErrorCount(int i) {
    }

    public void setBytes(int length) {
        this.bytes = length;
    }

    public int getBytes() {
        if (GETBYTES_NETWORK_SIZE) {
            int tmpSum = this.getHeadersSize() + this.getBodySize();
            return tmpSum == 0 ? this.bytes : tmpSum;
        }
        if (GETBYTES_HEADERS_SIZE) {
            return this.getHeadersSize();
        }
        if (GETBYTES_BODY_REALSIZE) {
            return this.getBodySize();
        }
        return this.bytes == 0 ? this.responseData.length : this.bytes;
    }

    public long getLatency() {
        return this.latency;
    }

    public void latencyEnd() {
        this.latency = this.currentTimeInMillis() - this.startTime - this.idleTime;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setURL(URL location) {
        this.location = location;
    }

    public URL getURL() {
        return this.location;
    }

    public String getUrlAsString() {
        return this.location == null ? "" : this.location.toExternalForm();
    }

    public SampleResult getParent() {
        return this.parent;
    }

    public void setParent(SampleResult parent) {
        this.parent = parent;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }

    public void setResultFileName(String resultFileName) {
        this.resultFileName = resultFileName;
    }

    public int getGroupThreads() {
        return this.groupThreads;
    }

    public void setGroupThreads(int n) {
        this.groupThreads = n;
    }

    public int getAllThreads() {
        return this.allThreads;
    }

    public void setAllThreads(int n) {
        this.allThreads = n;
    }

    public void removeAssertionResults() {
        this.assertionResults = null;
    }

    public void removeSubResults() {
        this.subResults = null;
    }

    public void setHeadersSize(int size) {
        this.headersSize = size;
    }

    public int getHeadersSize() {
        return this.headersSize;
    }

    public int getBodySize() {
        return this.bodySize == 0 ? this.responseData.length : this.bodySize;
    }

    public void setBodySize(int bodySize) {
        this.bodySize = bodySize;
    }

    static {
        if (startTimeStamp) {
            log.info("Note: Sample TimeStamps are START times");
        } else {
            log.info("Note: Sample TimeStamps are END times");
        }
        log.info("sampleresult.default.encoding is set to " + DEFAULT_ENCODING);
        log.info("sampleresult.useNanoTime=" + USENANOTIME);
        log.info("sampleresult.nanoThreadSleep=" + NANOTHREAD_SLEEP);
        if (USENANOTIME && NANOTHREAD_SLEEP > 0L) {
            NanoOffset.nanoOffset = System.currentTimeMillis() - SampleResult.sampleNsClockInMs();
            NanoOffset nanoOffset = new NanoOffset();
            nanoOffset.setDaemon(true);
            nanoOffset.setName("NanoOffset");
            nanoOffset.start();
        }
        OK_CODE = Integer.toString(200);
        BINARY_TYPES = new String[]{"image/", "audio/", "video/"};
    }

    private static class NanoOffset
    extends Thread {
        private static volatile long nanoOffset;

        private NanoOffset() {
        }

        static long getNanoOffset() {
            return nanoOffset;
        }

        public void run() {
            this.getOffset(30L);
            while (true) {
                this.getOffset(NANOTHREAD_SLEEP);
            }
        }

        private void getOffset(long wait) {
            try {
                Thread.sleep(wait);
                long clock = System.currentTimeMillis();
                long nano = SampleResult.sampleNsClockInMs();
                nanoOffset = clock - nano;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

