/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HoldSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private final List<SampleEvent> sampleStore = new ArrayList<SampleEvent>();
    private final RemoteSampleListener listener;

    @Deprecated
    public HoldSampleSender() {
        log.warn("Constructor only intended for use in testing");
        this.listener = null;
    }

    HoldSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        log.info("Using HoldSampleSender for this test run");
    }

    public void testEnded(String host) {
        block4: {
            log.info("Test Ended on " + host);
            try {
                for (SampleEvent se : this.sampleStore) {
                    this.listener.sampleOccurred(se);
                }
                this.listener.testEnded(host);
                this.sampleStore.clear();
            }
            catch (Throwable ex) {
                log.error("testEnded(host)", ex);
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                if (!(ex instanceof RuntimeException)) break block4;
                throw (RuntimeException)ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sampleOccurred(SampleEvent e) {
        List<SampleEvent> list = this.sampleStore;
        synchronized (list) {
            this.sampleStore.add(e);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        log.info("Using HoldSampleSender for this test run");
        return this;
    }
}

