/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

public class AsynchSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final long serialVersionUID = 251L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final transient SampleEvent FINAL_EVENT = new SampleEvent();
    private static final int serverConfiguredCapacity = JMeterUtils.getPropDefault("asynch.batch.queue.size", 100);
    private final int clientConfiguredCapacity = JMeterUtils.getPropDefault("asynch.batch.queue.size", 100);
    private final RemoteSampleListener listener;
    private transient BlockingQueue<SampleEvent> queue;
    private transient long queueWaits;
    private transient long queueWaitTime;

    private Object readResolve() throws ObjectStreamException {
        int capacity = this.getCapacity();
        log.info("Using batch queue size (asynch.batch.queue.size): " + capacity);
        this.queue = new ArrayBlockingQueue<SampleEvent>(capacity);
        Worker worker = new Worker(this.queue, this.listener);
        worker.setDaemon(true);
        worker.start();
        return this;
    }

    @Deprecated
    public AsynchSampleSender() {
        this(null);
        log.warn("Constructor only intended for use in testing");
    }

    protected AsynchSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        log.info("Using Asynch Remote Sampler for this test run, queue size " + this.getCapacity());
    }

    private int getCapacity() {
        return this.isClientConfigured() ? this.clientConfiguredCapacity : serverConfiguredCapacity;
    }

    public void testEnded(String host) {
        log.debug("Test Ended on " + host);
        try {
            this.listener.testEnded(host);
            this.queue.put(FINAL_EVENT);
        }
        catch (Exception ex) {
            log.warn("testEnded(host)" + ex);
        }
        if (this.queueWaits > 0L) {
            log.info("QueueWaits: " + this.queueWaits + "; QueueWaitTime: " + this.queueWaitTime + " (nanoseconds)");
        }
    }

    public void sampleOccurred(SampleEvent e) {
        try {
            if (!this.queue.offer(e)) {
                ++this.queueWaits;
                long t1 = System.nanoTime();
                this.queue.put(e);
                long t2 = System.nanoTime();
                this.queueWaitTime += t2 - t1;
            }
        }
        catch (Exception err) {
            log.error("sampleOccurred; failed to queue the sample", (Throwable)err);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Worker
    extends Thread {
        private final BlockingQueue<SampleEvent> queue;
        private final RemoteSampleListener listener;

        private Worker(BlockingQueue<SampleEvent> q, RemoteSampleListener l) {
            this.queue = q;
            this.listener = l;
        }

        @Override
        public void run() {
            try {
                boolean eof = false;
                while (!eof) {
                    ArrayList<SampleEvent> l = new ArrayList<SampleEvent>();
                    SampleEvent e = this.queue.take();
                    while (!(eof = e == FINAL_EVENT) && e != null) {
                        l.add(e);
                        e = (SampleEvent)this.queue.poll();
                    }
                    int size = l.size();
                    if (size <= 0) continue;
                    try {
                        this.listener.processBatch(l);
                    }
                    catch (RemoteException err) {
                        if (err.getCause() instanceof ConnectException) {
                            throw new JMeterError("Could not return sample", (Throwable)err);
                        }
                        log.error("Failed to return sample", (Throwable)err);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.debug("Worker ended");
        }
    }
}

