/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddToTree
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> commandSet;

    @Override
    public Set<String> getActionNames() {
        return commandSet;
    }

    @Override
    public void doAction(ActionEvent e) {
        GuiPackage guiPackage = GuiPackage.getInstance();
        try {
            guiPackage.updateCurrentNode();
            TestElement testElement = guiPackage.createTestElement(((JComponent)e.getSource()).getName());
            JMeterTreeNode parentNode = guiPackage.getCurrentNode();
            JMeterTreeNode node = guiPackage.getTreeModel().addComponent(testElement, parentNode);
            guiPackage.getMainFrame().getTree().setSelectionPath(new TreePath(node.getPath()));
        }
        catch (IllegalUserActionException err) {
            log.error("", (Throwable)err);
            String msg = err.getMessage();
            if (msg == null) {
                msg = err.toString();
            }
            JMeterUtils.reportErrorToUser(msg);
        }
        catch (Exception err) {
            log.error("", (Throwable)err);
            String msg = err.getMessage();
            if (msg == null) {
                msg = err.toString();
            }
            JMeterUtils.reportErrorToUser(msg);
        }
    }

    static {
        HashSet<String> commands = new HashSet<String>();
        commands.add("Add");
        commandSet = Collections.unmodifiableSet(commands);
    }
}

