/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.weaver.pe;

import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.FrameHelper;
import ch.usi.dag.disl.util.cfg.BasicBlock;
import ch.usi.dag.disl.util.cfg.CtrlFlowGraph;
import ch.usi.dag.disl.weaver.pe.ConstInterpreter;
import ch.usi.dag.disl.weaver.pe.ConstValue;
import ch.usi.dag.disl.weaver.pe.InvocationInterpreter;
import ch.usi.dag.disl.weaver.pe.MaxCalculator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialEvaluator {
    private MethodNode method;
    private InsnList ilist;

    public PartialEvaluator(InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks, String desc, int access) {
        this.ilist = instructions;
        this.method = new MethodNode();
        this.method.instructions = this.ilist;
        this.method.tryCatchBlocks = tryCatchBlocks;
        this.method.access = access;
        this.method.desc = desc.substring(0, desc.lastIndexOf(41)) + ")V";
        this.method.maxLocals = MaxCalculator.getMaxLocal(this.ilist, desc, access);
        this.method.maxStack = MaxCalculator.getMaxStack(this.ilist, tryCatchBlocks);
    }

    private boolean removeUnusedBB(CtrlFlowGraph cfg) {
        boolean isOptimized = false;
        boolean changed = true;
        LinkedList<BasicBlock> connected = new LinkedList<BasicBlock>(cfg.getNodes());
        connected.remove(cfg.getBB(this.ilist.getFirst()));
        for (TryCatchBlockNode tcb : this.method.tryCatchBlocks) {
            connected.remove(cfg.getBB(tcb.handler));
        }
        while (changed) {
            changed = false;
            LinkedList<BasicBlock> removed = new LinkedList<BasicBlock>();
            for (BasicBlock bb : connected) {
                if (bb.getPredecessors().size() > 0) continue;
                changed = true;
                AbstractInsnNode prev = null;
                AbstractInsnNode iter = bb.getEntrance();
                while (prev != bb.getExit()) {
                    prev = iter;
                    iter = iter.getNext();
                    int opcode = prev.getOpcode();
                    if (opcode == -1 && opcode == 177) continue;
                    isOptimized = true;
                    this.ilist.remove(prev);
                }
                for (BasicBlock successor : bb.getSuccessors()) {
                    successor.getPredecessors().remove(bb);
                }
                removed.add(bb);
            }
            connected.removeAll(removed);
        }
        return isOptimized;
    }

    private boolean conditionalReduction(Map<AbstractInsnNode, Frame<ConstValue>> frames) {
        boolean isOptimized = false;
        CtrlFlowGraph cfg = CtrlFlowGraph.build(this.method);
        for (BasicBlock bb : cfg.getNodes()) {
            AbstractInsnNode instr = AsmHelper.skipVirtualInsns(bb.getExit(), false);
            int opcode = instr.getOpcode();
            Frame<ConstValue> frame = frames.get(instr);
            block0 : switch (instr.getType()) {
                case 7: {
                    BasicBlock successor;
                    ConstValue result = null;
                    boolean popTwice = false;
                    switch (opcode) {
                        case 167: 
                        case 168: {
                            break block0;
                        }
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: {
                            ConstValue value1 = FrameHelper.getStackByIndex(frame, 1);
                            ConstValue value2 = FrameHelper.getStackByIndex(frame, 0);
                            result = ConstInterpreter.getInstance().binaryOperation(instr, value1, value2);
                            popTwice = true;
                            break;
                        }
                        default: {
                            ConstValue value = FrameHelper.getStackByIndex(frame, 0);
                            result = ConstInterpreter.getInstance().unaryOperation(instr, value);
                            break;
                        }
                    }
                    if (result.cst == null) break;
                    if (((Boolean)result.cst).booleanValue()) {
                        successor = cfg.getBB(instr.getNext());
                        bb.getSuccessors().remove(successor);
                        successor.getPredecessors().remove(bb);
                        if (popTwice) {
                            this.ilist.insertBefore(instr, new InsnNode(87));
                        }
                        this.ilist.insertBefore(instr, new InsnNode(87));
                        this.ilist.insertBefore(instr, new JumpInsnNode(167, ((JumpInsnNode)instr).label));
                        bb.setExit(instr.getPrevious());
                        this.ilist.remove(instr);
                    } else {
                        successor = cfg.getBB(((JumpInsnNode)instr).label);
                        bb.getSuccessors().remove(successor);
                        successor.getPredecessors().remove(bb);
                        if (popTwice) {
                            this.ilist.insertBefore(instr, new InsnNode(87));
                        }
                        this.ilist.insertBefore(instr, new InsnNode(87));
                        bb.setExit(instr.getPrevious());
                        this.ilist.remove(instr);
                    }
                    isOptimized = true;
                    break;
                }
                case 12: {
                    BasicBlock successor;
                    int i;
                    LookupSwitchInsnNode lsin = (LookupSwitchInsnNode)instr;
                    ConstValue value = FrameHelper.getStackByIndex(frame, 0);
                    if (value.cst == null) break;
                    int index = lsin.keys.indexOf(value.cst);
                    LabelNode label = null;
                    if (index >= 0) {
                        BasicBlock successor2 = cfg.getBB(lsin.dflt);
                        bb.getSuccessors().remove(successor2);
                        successor2.getPredecessors().remove(bb);
                    } else {
                        label = lsin.dflt;
                    }
                    for (i = 0; i < lsin.labels.size(); ++i) {
                        if (i == index) {
                            label = lsin.labels.get(i);
                            continue;
                        }
                        successor = cfg.getBB(lsin.labels.get(i));
                        bb.getSuccessors().remove(successor);
                        successor.getPredecessors().remove(bb);
                    }
                    this.ilist.insertBefore(instr, new InsnNode(87));
                    this.ilist.insertBefore(instr, new JumpInsnNode(167, label));
                    bb.setExit(instr.getPrevious());
                    this.ilist.remove(instr);
                    isOptimized = true;
                    break;
                }
                case 11: {
                    BasicBlock successor;
                    int i;
                    TableSwitchInsnNode tsin = (TableSwitchInsnNode)instr;
                    ConstValue value = FrameHelper.getStackByIndex(frame, 0);
                    if (value.cst == null) break;
                    int index = (Integer)value.cst;
                    LabelNode label = null;
                    if (index < tsin.min && index > tsin.max) {
                        BasicBlock successor3 = cfg.getBB(tsin.dflt);
                        bb.getSuccessors().remove(successor3);
                        successor3.getPredecessors().remove(bb);
                    } else {
                        label = tsin.dflt;
                    }
                    for (i = tsin.min; i <= tsin.max; ++i) {
                        if (i == index) {
                            label = tsin.labels.get(i - tsin.min);
                            continue;
                        }
                        successor = cfg.getBB(tsin.labels.get(i - tsin.min));
                        bb.getSuccessors().remove(successor);
                        successor.getPredecessors().remove(bb);
                    }
                    this.ilist.insertBefore(instr, new InsnNode(87));
                    this.ilist.insertBefore(instr, new JumpInsnNode(167, label));
                    bb.setExit(instr.getPrevious());
                    this.ilist.remove(instr);
                    isOptimized = true;
                    break;
                }
            }
        }
        return this.removeUnusedBB(cfg) | isOptimized;
    }

    private boolean insertLoadConstant(InsnList ilist, AbstractInsnNode location, Object cst) {
        if (cst == null) {
            return false;
        }
        if (cst == ConstValue.NULL) {
            ilist.insertBefore(location, new InsnNode(1));
            return true;
        }
        ilist.insertBefore(location, AsmHelper.loadConst(cst));
        return true;
    }

    private boolean replaceLoadWithLDC(Map<AbstractInsnNode, Frame<ConstValue>> frames) {
        boolean isOptimized = false;
        block3: for (AbstractInsnNode instr : this.ilist.toArray()) {
            Frame<ConstValue> frame = frames.get(instr);
            if (frame == null) continue;
            if (ConstInterpreter.mightBeUnaryConstOperation(instr)) {
                ConstValue value = FrameHelper.getStackByIndex(frame, 0);
                Object cst = ConstInterpreter.getInstance().unaryOperation((AbstractInsnNode)instr, (ConstValue)value).cst;
                if (!this.insertLoadConstant(this.ilist, instr, cst)) continue;
                this.ilist.insertBefore(instr.getPrevious(), new InsnNode(value.size == 1 ? 87 : 88));
                this.ilist.remove(instr);
                isOptimized = true;
                continue;
            }
            if (ConstInterpreter.mightBeBinaryConstOperation(instr)) {
                ConstValue value1 = FrameHelper.getStackByIndex(frame, 1);
                ConstValue value2 = FrameHelper.getStackByIndex(frame, 0);
                Object cst = ConstInterpreter.getInstance().binaryOperation((AbstractInsnNode)instr, (ConstValue)value1, (ConstValue)value2).cst;
                if (!this.insertLoadConstant(this.ilist, instr, cst)) continue;
                this.ilist.insertBefore(instr.getPrevious(), new InsnNode(value2.size == 1 ? 87 : 88));
                this.ilist.insertBefore(instr.getPrevious(), new InsnNode(value1.size == 1 ? 87 : 88));
                this.ilist.remove(instr);
                isOptimized = true;
                continue;
            }
            switch (instr.getOpcode()) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    if (!this.insertLoadConstant(this.ilist, instr, frame.getLocal((int)((VarInsnNode)instr).var).cst)) continue block3;
                    this.ilist.remove(instr);
                    isOptimized = true;
                    continue block3;
                }
            }
        }
        return isOptimized;
    }

    private boolean loadAfterStore(BasicBlock bb, AbstractInsnNode instr, int var) {
        AbstractInsnNode prev = instr.getPrevious();
        while (prev != bb.getExit()) {
            switch (instr.getOpcode()) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    if (((VarInsnNode)instr).var != var) break;
                    return true;
                }
            }
            prev = instr;
            instr = instr.getNext();
        }
        return false;
    }

    private boolean deadStore(CtrlFlowGraph cfg, VarInsnNode store) {
        BasicBlock bb = cfg.getBB(store);
        if (bb == null) {
            return false;
        }
        if (this.loadAfterStore(bb, store, store.var)) {
            return false;
        }
        HashSet<BasicBlock> visited = new HashSet<BasicBlock>();
        LinkedList<BasicBlock> unprocessed = new LinkedList<BasicBlock>(bb.getSuccessors());
        while (!unprocessed.isEmpty()) {
            BasicBlock next = (BasicBlock)unprocessed.poll();
            if (visited.contains(next)) continue;
            if (this.loadAfterStore(next, next.getEntrance(), store.var)) {
                return false;
            }
            visited.add(next);
        }
        return true;
    }

    private boolean removeDeadStore() {
        CtrlFlowGraph cfg = CtrlFlowGraph.build(this.method);
        boolean isOptimized = false;
        block4: for (AbstractInsnNode instr : this.ilist.toArray()) {
            switch (instr.getOpcode()) {
                case 54: 
                case 56: 
                case 58: {
                    if (!this.deadStore(cfg, (VarInsnNode)instr)) continue block4;
                    this.ilist.insertBefore(instr, new InsnNode(87));
                    this.ilist.remove(instr);
                    isOptimized = true;
                    continue block4;
                }
                case 55: 
                case 57: {
                    if (!this.deadStore(cfg, (VarInsnNode)instr)) continue block4;
                    this.ilist.insertBefore(instr, new InsnNode(88));
                    this.ilist.remove(instr);
                    isOptimized = true;
                    continue block4;
                }
            }
        }
        return isOptimized;
    }

    private boolean unremovablePop(Set<AbstractInsnNode> sources) {
        block4: for (AbstractInsnNode source : sources) {
            switch (source.getOpcode()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 187: {
                    continue block4;
                }
                case 182: 
                case 183: 
                case 184: {
                    if (InvocationInterpreter.getInstance().isRegistered((MethodInsnNode)source)) continue block4;
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    private void tryRemoveInvocation(InsnList ilist, MethodInsnNode instr) {
        if (InvocationInterpreter.getInstance().isRegistered(instr)) {
            MethodInsnNode min = instr;
            String desc = min.desc;
            if (min.getOpcode() == 182) {
                ilist.insert((AbstractInsnNode)min, new InsnNode(87));
            }
            for (Type arg : Type.getArgumentTypes(desc)) {
                ilist.insert((AbstractInsnNode)min, new InsnNode(arg.getSize() == 2 ? 88 : 87));
            }
        }
    }

    private void tryRemoveAllocation(InsnList ilist, AbstractInsnNode next, Map<AbstractInsnNode, Frame<SourceValue>> frames) {
        if (next.getOpcode() != 89) {
            return;
        }
        for (AbstractInsnNode instr : ilist.toArray()) {
            if (instr.getOpcode() != 183) continue;
            Type[] args = Type.getArgumentTypes(((MethodInsnNode)instr).desc);
            Frame<SourceValue> frame = frames.get(instr);
            Set<AbstractInsnNode> sources = FrameHelper.getStackByIndex(frame, (int)args.length).insns;
            if (!sources.contains(next)) continue;
            for (Type arg : args) {
                ilist.insert(instr, new InsnNode(arg.getSize() == 2 ? 88 : 87));
            }
            ilist.remove(instr);
        }
        ilist.remove(next);
    }

    private boolean removePop() {
        Map<AbstractInsnNode, Frame<SourceValue>> frames = FrameHelper.createSourceMapping(PartialEvaluator.class.getName(), this.method);
        boolean isOptimized = false;
        for (AbstractInsnNode instr : this.ilist.toArray()) {
            Set<AbstractInsnNode> sources;
            Frame<SourceValue> frame;
            int opcode = instr.getOpcode();
            if (opcode != 87 && opcode != 88 || (frame = frames.get(instr)) == null || this.unremovablePop(sources = FrameHelper.getStackByIndex(frame, (int)0).insns)) continue;
            for (AbstractInsnNode source : sources) {
                switch (source.getOpcode()) {
                    case 182: 
                    case 183: 
                    case 184: {
                        this.tryRemoveInvocation(this.ilist, (MethodInsnNode)source);
                        break;
                    }
                    case 187: {
                        this.tryRemoveAllocation(this.ilist, source.getNext(), frames);
                        break;
                    }
                }
                this.ilist.remove(source);
            }
            this.ilist.remove(instr);
            isOptimized = true;
        }
        return isOptimized;
    }

    private boolean removeUnusedJump() {
        boolean isOptimized = false;
        block5: for (AbstractInsnNode instr : this.ilist.toArray()) {
            int opcode = instr.getOpcode();
            switch (instr.getType()) {
                case 7: {
                    if (opcode == 168 || AsmHelper.skipVirtualInsns(((JumpInsnNode)instr).label, false) != instr) continue block5;
                    if (opcode != 167) {
                        this.ilist.insertBefore(instr, new InsnNode(87));
                    }
                    this.ilist.remove(instr);
                    isOptimized = true;
                    continue block5;
                }
                case 12: {
                    LookupSwitchInsnNode lsin = (LookupSwitchInsnNode)instr;
                    boolean flag = false;
                    for (LabelNode label : lsin.labels) {
                        if (AsmHelper.skipVirtualInsns(label, false) == instr) continue;
                        flag = true;
                    }
                    if (flag || AsmHelper.skipVirtualInsns(lsin.dflt, false) != instr) continue block5;
                    this.ilist.insertBefore(instr, new InsnNode(87));
                    this.ilist.remove(instr);
                    isOptimized = true;
                    continue block5;
                }
                case 11: {
                    TableSwitchInsnNode tsin = (TableSwitchInsnNode)instr;
                    boolean flag = false;
                    for (LabelNode label : tsin.labels) {
                        if (AsmHelper.skipVirtualInsns(label, false) == instr) continue;
                        flag = true;
                    }
                    if (flag || AsmHelper.skipVirtualInsns(tsin.dflt, false) != instr) continue block5;
                    this.ilist.insertBefore(instr, new InsnNode(87));
                    this.ilist.remove(instr);
                    isOptimized = true;
                    continue block5;
                }
            }
        }
        return isOptimized;
    }

    private boolean removeUnusedHandler() {
        CtrlFlowGraph cfg = CtrlFlowGraph.build(this.method);
        boolean isOptimized = false;
        for (TryCatchBlockNode tcb : this.method.tryCatchBlocks) {
            if (AsmHelper.skipVirtualInsns(tcb.start, true) != AsmHelper.skipVirtualInsns(tcb.end, true)) continue;
            this.method.tryCatchBlocks.remove(tcb);
            isOptimized |= this.removeUnusedBB(cfg);
        }
        return isOptimized;
    }

    public boolean evaluate() {
        boolean removed;
        this.ilist.add(new InsnNode(177));
        Analyzer<ConstValue> constAnalyzer = new Analyzer<ConstValue>(ConstInterpreter.getInstance());
        Map<AbstractInsnNode, Frame<ConstValue>> frames = FrameHelper.createMapping(constAnalyzer, PartialEvaluator.class.getName(), this.method);
        boolean isOptimized = this.conditionalReduction(frames);
        isOptimized |= this.replaceLoadWithLDC(frames);
        do {
            removed = false;
            removed |= this.removeDeadStore();
        } while (removed |= this.removePop());
        isOptimized |= removed;
        isOptimized |= this.removeUnusedJump();
        this.ilist.remove(this.ilist.getLast());
        return isOptimized |= this.removeUnusedHandler();
    }
}

