/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.weaver.pe;

import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.cfg.BasicBlock;
import ch.usi.dag.disl.util.cfg.CtrlFlowGraph;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxCalculator {
    static final int[] SIZE;

    public static int getMaxLocal(InsnList ilist, String desc, int access) {
        int maxLocals = Type.getArgumentsAndReturnSizes(desc) >> 2;
        if ((access & 8) != 0) {
            --maxLocals;
        }
        for (AbstractInsnNode instr : AsmHelper.allInsnsFrom(ilist)) {
            if (instr instanceof VarInsnNode) {
                VarInsnNode varInstr = (VarInsnNode)instr;
                switch (varInstr.getOpcode()) {
                    case 22: 
                    case 24: 
                    case 55: 
                    case 57: {
                        maxLocals = Math.max(varInstr.var + 2, maxLocals);
                        break;
                    }
                    default: {
                        maxLocals = Math.max(varInstr.var + 1, maxLocals);
                        break;
                    }
                }
                continue;
            }
            if (!(instr instanceof IincInsnNode)) continue;
            IincInsnNode iinc = (IincInsnNode)instr;
            maxLocals = Math.max(iinc.var + 1, maxLocals);
        }
        return maxLocals;
    }

    private static int fieldSize(String desc) {
        char c = desc.charAt(0);
        if (c == 'D' || c == 'J') {
            return 2;
        }
        return 1;
    }

    private static int execute(int currentStackSize, AbstractInsnNode instr) {
        int opcode = instr.getOpcode();
        switch (opcode) {
            case -1: {
                return currentStackSize;
            }
            case 178: {
                return currentStackSize + MaxCalculator.fieldSize(((FieldInsnNode)instr).desc);
            }
            case 179: {
                return currentStackSize - MaxCalculator.fieldSize(((FieldInsnNode)instr).desc);
            }
            case 180: {
                return currentStackSize + MaxCalculator.fieldSize(((FieldInsnNode)instr).desc) - 1;
            }
            case 181: {
                return currentStackSize - MaxCalculator.fieldSize(((FieldInsnNode)instr).desc) - 1;
            }
            case 197: {
                return currentStackSize + 1 - ((MultiANewArrayInsnNode)instr).dims;
            }
            case 182: 
            case 183: 
            case 185: {
                int argSize = Type.getArgumentsAndReturnSizes(((MethodInsnNode)instr).desc);
                return currentStackSize - (argSize >> 2) + (argSize & 3);
            }
            case 184: {
                int argSize = Type.getArgumentsAndReturnSizes(((MethodInsnNode)instr).desc);
                return currentStackSize - (argSize >> 2) + (argSize & 3) + 1;
            }
            case 186: {
                int argSize = Type.getArgumentsAndReturnSizes(((InvokeDynamicInsnNode)instr).desc);
                return currentStackSize - (argSize >> 2) + (argSize & 3) + 1;
            }
        }
        return currentStackSize + SIZE[opcode];
    }

    private static int getMaxStack(int currentStackSize, BasicBlock bb, List<BasicBlock> unvisited) {
        if (!unvisited.remove(bb)) {
            return 0;
        }
        int maxStack = currentStackSize;
        for (AbstractInsnNode iter : bb) {
            currentStackSize = MaxCalculator.execute(currentStackSize, iter);
            maxStack = Math.max(currentStackSize, maxStack);
        }
        for (BasicBlock next : bb.getSuccessors()) {
            maxStack = Math.max(MaxCalculator.getMaxStack(currentStackSize, next, unvisited), maxStack);
        }
        return maxStack;
    }

    public static int getMaxStack(InsnList ilist, List<TryCatchBlockNode> tryCatchBlocks) {
        CtrlFlowGraph cfg = CtrlFlowGraph.build(ilist, tryCatchBlocks);
        List<BasicBlock> unvisited = cfg.getNodes();
        int maxStack = MaxCalculator.getMaxStack(0, cfg.getBB(ilist.getFirst()), unvisited);
        for (TryCatchBlockNode tcb : tryCatchBlocks) {
            maxStack = Math.max(MaxCalculator.getMaxStack(1, cfg.getBB(tcb.handler), unvisited), maxStack);
        }
        return maxStack;
    }

    public static int getMaxLocal(MethodNode method) {
        return MaxCalculator.getMaxLocal(method.instructions, method.desc, method.access);
    }

    public static int getMaxStack(MethodNode method) {
        return MaxCalculator.getMaxStack(method.instructions, method.tryCatchBlocks);
    }

    static {
        int[] b = new int[202];
        String s = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        for (int i = 0; i < b.length; ++i) {
            b[i] = s.charAt(i) - 69;
        }
        SIZE = b;
    }
}

