/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.weaver.pe;

import ch.usi.dag.disl.weaver.pe.ConstValue;
import ch.usi.dag.disl.weaver.pe.InvocationInterpreter;
import ch.usi.dag.disl.weaver.pe.Reference;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.Interpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstInterpreter
extends Interpreter<ConstValue> {
    private static ConstInterpreter instance;

    protected ConstInterpreter() {
        super(262144);
    }

    @Override
    public ConstValue newValue(Type type) {
        if (type == Type.VOID_TYPE) {
            return null;
        }
        return new ConstValue(type == null ? 1 : type.getSize());
    }

    @Override
    public ConstValue newOperation(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 1: {
                return new ConstValue(1, ConstValue.NULL);
            }
            case 2: {
                return new ConstValue(1, -1);
            }
            case 3: {
                return new ConstValue(1, 0);
            }
            case 4: {
                return new ConstValue(1, 1);
            }
            case 5: {
                return new ConstValue(1, 2);
            }
            case 6: {
                return new ConstValue(1, 3);
            }
            case 7: {
                return new ConstValue(1, 4);
            }
            case 8: {
                return new ConstValue(1, 5);
            }
            case 9: {
                return new ConstValue(2, new Long(0L));
            }
            case 10: {
                return new ConstValue(2, new Long(1L));
            }
            case 11: {
                return new ConstValue(1, new Float(0.0f));
            }
            case 12: {
                return new ConstValue(1, new Float(1.0f));
            }
            case 13: {
                return new ConstValue(1, new Float(2.0f));
            }
            case 14: {
                return new ConstValue(2, new Double(0.0));
            }
            case 15: {
                return new ConstValue(2, new Double(1.0));
            }
            case 16: {
                return new ConstValue(1, ((IntInsnNode)insn).operand);
            }
            case 17: {
                return new ConstValue(1, ((IntInsnNode)insn).operand);
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                return new ConstValue(cst instanceof Long || cst instanceof Double ? 2 : 1, cst);
            }
            case 178: {
                return new ConstValue(Type.getType(((FieldInsnNode)insn).desc).getSize());
            }
            case 187: {
                return new ConstValue(1, new Reference());
            }
        }
        return new ConstValue(1);
    }

    @Override
    public ConstValue copyOperation(AbstractInsnNode insn, ConstValue value) {
        return new ConstValue(value.getSize(), value.cst);
    }

    public static boolean mightBeUnaryConstOperation(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 192: 
            case 193: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ConstValue unaryOperation(AbstractInsnNode insn, ConstValue value) {
        if (value.cst == null) {
            switch (insn.getOpcode()) {
                case 117: 
                case 119: 
                case 133: 
                case 135: 
                case 138: 
                case 140: 
                case 141: 
                case 143: {
                    return new ConstValue(2);
                }
                case 180: {
                    return new ConstValue(Type.getType(((FieldInsnNode)insn).desc).getSize());
                }
            }
            return new ConstValue(1);
        }
        switch (insn.getOpcode()) {
            case 116: {
                return new ConstValue(1, -((Integer)value.cst).intValue());
            }
            case 117: {
                return new ConstValue(2, -((Long)value.cst).longValue());
            }
            case 118: {
                return new ConstValue(1, Float.valueOf(-((Float)value.cst).floatValue()));
            }
            case 119: {
                return new ConstValue(2, -((Double)value.cst).doubleValue());
            }
            case 132: {
                return new ConstValue(1, (Integer)value.cst + ((IincInsnNode)insn).incr);
            }
            case 133: {
                return new ConstValue(2, (Integer)value.cst);
            }
            case 134: {
                return new ConstValue(1, Float.valueOf(((Integer)value.cst).intValue()));
            }
            case 135: {
                return new ConstValue(2, (Integer)value.cst);
            }
            case 136: {
                return new ConstValue(1, (int)((Long)value.cst).longValue());
            }
            case 137: {
                return new ConstValue(1, Float.valueOf(((Long)value.cst).longValue()));
            }
            case 138: {
                return new ConstValue(2, (Long)value.cst);
            }
            case 139: {
                return new ConstValue(1, (int)((Float)value.cst).floatValue());
            }
            case 140: {
                return new ConstValue(2, (long)((Float)value.cst).floatValue());
            }
            case 141: {
                return new ConstValue(2, -((Double)value.cst).doubleValue());
            }
            case 142: {
                return new ConstValue(1, (int)((Double)value.cst).doubleValue());
            }
            case 143: {
                return new ConstValue(2, (long)((Double)value.cst).doubleValue());
            }
            case 144: {
                return new ConstValue(1, Float.valueOf((float)((Double)value.cst).doubleValue()));
            }
            case 145: {
                return new ConstValue(1, (byte)((Integer)value.cst).intValue());
            }
            case 146: {
                return new ConstValue(1, Character.valueOf((char)((Integer)value.cst).intValue()));
            }
            case 147: {
                return new ConstValue(1, (short)((Integer)value.cst).intValue());
            }
            case 153: {
                return new ConstValue(1, (Integer)value.cst == 0);
            }
            case 154: {
                return new ConstValue(1, (Integer)value.cst != 0);
            }
            case 155: {
                return new ConstValue(1, (Integer)value.cst < 0);
            }
            case 156: {
                return new ConstValue(1, (Integer)value.cst >= 0);
            }
            case 157: {
                return new ConstValue(1, (Integer)value.cst > 0);
            }
            case 158: {
                return new ConstValue(1, (Integer)value.cst <= 0);
            }
            case 198: {
                return new ConstValue(1, value.cst == ConstValue.NULL);
            }
            case 199: {
                return new ConstValue(1, value.cst != ConstValue.NULL);
            }
            case 192: {
                return new ConstValue(1, value.cst);
            }
            case 193: {
                for (Class<?> clazz = value.cst.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    if (!Type.getInternalName(clazz).equals(((TypeInsnNode)insn).desc)) continue;
                    return new ConstValue(1, 1);
                }
                return new ConstValue(1, 0);
            }
        }
        return new ConstValue(1);
    }

    public static boolean mightBeBinaryConstOperation(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ConstValue binaryOperation(AbstractInsnNode insn, ConstValue value1, ConstValue value2) {
        if (value1.cst == null || value2.cst == null) {
            switch (insn.getOpcode()) {
                case 47: 
                case 49: 
                case 97: 
                case 99: 
                case 101: 
                case 103: 
                case 105: 
                case 107: 
                case 109: 
                case 111: 
                case 113: 
                case 115: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: {
                    return new ConstValue(2);
                }
            }
            return new ConstValue(1);
        }
        switch (insn.getOpcode()) {
            case 47: 
            case 49: {
                return new ConstValue(2);
            }
            case 97: {
                return new ConstValue(2, (Long)value1.cst + (Long)value2.cst);
            }
            case 101: {
                return new ConstValue(2, (Long)value1.cst - (Long)value2.cst);
            }
            case 105: {
                return new ConstValue(2, (Long)value1.cst * (Long)value2.cst);
            }
            case 109: {
                return new ConstValue(2, (Long)value1.cst / (Long)value2.cst);
            }
            case 113: {
                return new ConstValue(2, (Long)value1.cst % (Long)value2.cst);
            }
            case 121: {
                return new ConstValue(2, (Long)value1.cst << (Integer)value2.cst);
            }
            case 123: {
                return new ConstValue(2, (Long)value1.cst >> (Integer)value2.cst);
            }
            case 125: {
                return new ConstValue(2, (Long)value1.cst >>> (Integer)value2.cst);
            }
            case 127: {
                return new ConstValue(2, (Long)value1.cst & (Long)value2.cst);
            }
            case 129: {
                return new ConstValue(2, (Long)value1.cst | (Long)value2.cst);
            }
            case 131: {
                return new ConstValue(2, (Long)value1.cst ^ (Long)value2.cst);
            }
            case 99: {
                return new ConstValue(2, (Double)value1.cst + (Double)value2.cst);
            }
            case 103: {
                return new ConstValue(2, (Double)value1.cst - (Double)value2.cst);
            }
            case 107: {
                return new ConstValue(2, (Double)value1.cst * (Double)value2.cst);
            }
            case 111: {
                return new ConstValue(2, (Double)value1.cst / (Double)value2.cst);
            }
            case 115: {
                return new ConstValue(2, (Double)value1.cst % (Double)value2.cst);
            }
            case 96: {
                return new ConstValue(1, (Integer)value1.cst + (Integer)value2.cst);
            }
            case 100: {
                return new ConstValue(1, (Integer)value1.cst - (Integer)value2.cst);
            }
            case 104: {
                return new ConstValue(1, (Integer)value1.cst * (Integer)value2.cst);
            }
            case 108: {
                return new ConstValue(1, (Integer)value1.cst / (Integer)value2.cst);
            }
            case 112: {
                return new ConstValue(1, (Integer)value1.cst % (Integer)value2.cst);
            }
            case 120: {
                return new ConstValue(1, (Integer)value1.cst << (Integer)value2.cst);
            }
            case 122: {
                return new ConstValue(1, (Integer)value1.cst >> (Integer)value2.cst);
            }
            case 124: {
                return new ConstValue(1, (Integer)value1.cst >>> (Integer)value2.cst);
            }
            case 126: {
                return new ConstValue(1, (Integer)value1.cst & (Integer)value2.cst);
            }
            case 128: {
                return new ConstValue(1, (Integer)value1.cst | (Integer)value2.cst);
            }
            case 130: {
                return new ConstValue(1, (Integer)value1.cst ^ (Integer)value2.cst);
            }
            case 98: {
                return new ConstValue(1, Float.valueOf(((Float)value1.cst).floatValue() + ((Float)value2.cst).floatValue()));
            }
            case 102: {
                return new ConstValue(1, Float.valueOf(((Float)value1.cst).floatValue() - ((Float)value2.cst).floatValue()));
            }
            case 106: {
                return new ConstValue(1, Float.valueOf(((Float)value1.cst).floatValue() * ((Float)value2.cst).floatValue()));
            }
            case 110: {
                return new ConstValue(1, Float.valueOf(((Float)value1.cst).floatValue() / ((Float)value2.cst).floatValue()));
            }
            case 114: {
                return new ConstValue(1, Float.valueOf(((Float)value1.cst).floatValue() % ((Float)value2.cst).floatValue()));
            }
            case 148: {
                if ((Long)value1.cst > (Long)value2.cst) {
                    return new ConstValue(1, 1);
                }
                if ((Long)value1.cst < (Long)value2.cst) {
                    return new ConstValue(1, -1);
                }
                return new ConstValue(1, 0);
            }
            case 149: 
            case 150: {
                if (((Float)value1.cst).floatValue() > ((Float)value2.cst).floatValue()) {
                    return new ConstValue(1, 1);
                }
                if (((Float)value1.cst).floatValue() < ((Float)value2.cst).floatValue()) {
                    return new ConstValue(1, -1);
                }
                return new ConstValue(1, 0);
            }
            case 151: 
            case 152: {
                if ((Double)value1.cst > (Double)value2.cst) {
                    return new ConstValue(1, 1);
                }
                if ((Double)value1.cst < (Double)value2.cst) {
                    return new ConstValue(1, -1);
                }
                return new ConstValue(1, 0);
            }
            case 159: {
                return new ConstValue(1, value1.cst.equals(value2.cst));
            }
            case 160: {
                return new ConstValue(1, !value1.cst.equals(value2.cst));
            }
            case 161: {
                return new ConstValue(1, (Integer)value1.cst < (Integer)value2.cst);
            }
            case 162: {
                return new ConstValue(1, (Integer)value1.cst >= (Integer)value2.cst);
            }
            case 163: {
                return new ConstValue(1, (Integer)value1.cst > (Integer)value2.cst);
            }
            case 164: {
                return new ConstValue(1, (Integer)value1.cst <= (Integer)value2.cst);
            }
            case 165: {
                return new ConstValue(1, value1.cst == value2.cst);
            }
            case 166: {
                return new ConstValue(1, value1.cst != value2.cst);
            }
        }
        return new ConstValue(1);
    }

    @Override
    public ConstValue ternaryOperation(AbstractInsnNode insn, ConstValue value1, ConstValue value2, ConstValue value3) {
        return new ConstValue(1);
    }

    @Override
    public ConstValue naryOperation(AbstractInsnNode insn, List<? extends ConstValue> values) {
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            return new ConstValue(1);
        }
        if (opcode == 186) {
            return new ConstValue(Type.getReturnType(((InvokeDynamicInsnNode)insn).desc).getSize());
        }
        int size = Type.getReturnType(((MethodInsnNode)insn).desc).getSize();
        Object cst = InvocationInterpreter.getInstance().execute((MethodInsnNode)insn, values);
        return new ConstValue(size, cst);
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, ConstValue value, ConstValue expected) {
    }

    @Override
    public ConstValue merge(ConstValue d, ConstValue w) {
        if (d.size == w.size && d.cst != null && d.cst.equals(w.cst)) {
            return d;
        }
        return new ConstValue(Math.min(d.size, w.size));
    }

    public static ConstInterpreter getInstance() {
        if (instance == null) {
            instance = new ConstInterpreter();
        }
        return instance;
    }
}

