/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.weaver.pe;

import ch.usi.dag.disl.weaver.pe.ConstValue;
import ch.usi.dag.disl.weaver.pe.Reference;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHelper {
    public static final HashSet<String> VALUE_TYPES = new HashSet();

    public static Class<?> getClassFromType(Type type) {
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 10: {
                try {
                    return Class.forName(type.getClassName());
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static boolean isValueType(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 10: {
                return VALUE_TYPES.contains(type.getInternalName());
            }
        }
        return false;
    }

    public static Class<?>[] getClasses(String desc) throws ClassNotFoundException {
        Type[] types = Type.getArgumentTypes(desc);
        Class[] classes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            classes[i] = ClassHelper.getClassFromType(types[i]);
            if (classes[i] != null) continue;
            return null;
        }
        return classes;
    }

    public static Object i2wrapper(Integer obj, Class<?> clazz) {
        int i = obj;
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return i == 1;
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return (byte)i;
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return Character.valueOf((char)i);
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return (short)i;
        }
        return obj;
    }

    public static Object wrapper2i(Object obj, Class<?> clazz) {
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return (Boolean)obj != false ? 1 : 0;
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return (int)((Byte)obj).byteValue();
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return (int)((Character)obj).charValue();
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return (int)((Short)obj).shortValue();
        }
        return obj;
    }

    public static Object dereference(Object obj) {
        if (obj instanceof Reference) {
            return ((Reference)obj).getObj();
        }
        return obj;
    }

    public static Object dereference(Object obj, Class<?> type) {
        if (obj instanceof Integer) {
            return ClassHelper.i2wrapper((Integer)obj, type);
        }
        return ClassHelper.dereference(obj);
    }

    public static Object address(Object obj, Class<?> clazz) {
        if (ClassHelper.isValueType(Type.getType(clazz))) {
            return ClassHelper.wrapper2i(obj, clazz);
        }
        return new Reference(obj);
    }

    public static Object getCaller(MethodInsnNode instr, List<? extends ConstValue> values) {
        if (instr.getOpcode() == 184) {
            return null;
        }
        return ClassHelper.dereference(values.get((int)0).cst);
    }

    public static Object[] getArgs(MethodInsnNode instr, List<? extends ConstValue> values, Class<?>[] parameters) {
        if (instr.getOpcode() == 184) {
            Object[] args = new Object[values.size()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = ClassHelper.dereference(values.get((int)i).cst, parameters[i]);
            }
            return args;
        }
        Object[] args = new Object[values.size() - 1];
        for (int i = 0; i < args.length; ++i) {
            args[i] = ClassHelper.dereference(values.get((int)(i + 1)).cst, parameters[i]);
        }
        return args;
    }

    static {
        VALUE_TYPES.add("java/lang/Boolean");
        VALUE_TYPES.add("java/lang/Byte");
        VALUE_TYPES.add("java/lang/Character");
        VALUE_TYPES.add("java/lang/Double");
        VALUE_TYPES.add("java/lang/Float");
        VALUE_TYPES.add("java/lang/Integer");
        VALUE_TYPES.add("java/lang/Long");
        VALUE_TYPES.add("java/lang/Short");
        VALUE_TYPES.add("java/lang/String");
    }
}

