/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.weaver;

import ch.usi.dag.disl.snippet.Shadow;
import ch.usi.dag.disl.snippet.Snippet;
import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.FrameHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeavingInfo {
    private ArrayList<Snippet> sortedSnippets;
    private Map<AbstractInsnNode, Frame<BasicValue>> basicFrameMap;
    private Map<AbstractInsnNode, Frame<SourceValue>> sourceFrameMap;
    private Frame<BasicValue> retFrame;

    public WeavingInfo(ClassNode classNode, MethodNode methodNode, Map<Snippet, List<Shadow>> snippetMarkings) {
        LinkedList<AbstractInsnNode> ends;
        Shadow.WeavingRegion region;
        this.sortedSnippets = new ArrayList<Snippet>(snippetMarkings.keySet());
        Collections.sort(this.sortedSnippets);
        InsnList instructions = methodNode.instructions;
        LinkedList<LabelNode> tcb_ends = new LinkedList<LabelNode>();
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            tcb_ends.add(tcb.end);
        }
        for (Snippet snippet : this.sortedSnippets) {
            for (Shadow shadow : snippetMarkings.get(snippet)) {
                region = shadow.getWeavingRegion();
                AbstractInsnNode start = region.getStart();
                LabelNode lstart = new LabelNode();
                instructions.insertBefore(start, lstart);
                region.setStart(lstart);
            }
        }
        for (Snippet snippet : this.sortedSnippets) {
            for (Shadow shadow : snippetMarkings.get(snippet)) {
                region = shadow.getWeavingRegion();
                if (region.getEnds() != null) continue;
                ends = new LinkedList<AbstractInsnNode>();
                for (AbstractInsnNode end : shadow.getRegionEnds()) {
                    if (AsmHelper.isBranch(end)) {
                        end = end.getPrevious();
                    }
                    ends.add(end);
                }
                region.setEnds(ends);
            }
        }
        for (Snippet snippet : this.sortedSnippets) {
            for (Shadow shadow : snippetMarkings.get(snippet)) {
                region = shadow.getWeavingRegion();
                ends = new LinkedList();
                for (AbstractInsnNode end : region.getEnds()) {
                    LabelNode lend = new LabelNode();
                    instructions.insert(end, lend);
                    ends.add(lend);
                }
                region.setEnds(ends);
                LabelNode lthrowstart = new LabelNode();
                instructions.insertBefore(region.getAfterThrowStart(), lthrowstart);
                region.setAfterThrowStart(lthrowstart);
                LabelNode lthrowend = new LabelNode();
                instructions.insert(region.getAfterThrowEnd(), lthrowend);
                region.setAfterThrowEnd(lthrowend);
            }
        }
        this.basicFrameMap = FrameHelper.createBasicMapping(classNode.name, methodNode);
        this.sourceFrameMap = FrameHelper.createSourceMapping(classNode.name, methodNode);
        AbstractInsnNode last = AsmHelper.skipVirtualInsns(instructions.getLast(), false);
        this.retFrame = this.basicFrameMap.get(last);
    }

    public ArrayList<Snippet> getSortedSnippets() {
        return this.sortedSnippets;
    }

    public Frame<BasicValue> getBasicFrame(AbstractInsnNode instr) {
        return this.basicFrameMap.get(instr);
    }

    public Frame<BasicValue> getRetFrame() {
        return this.retFrame;
    }

    public Frame<SourceValue> getSourceFrame(AbstractInsnNode instr) {
        return this.sourceFrameMap.get(instr);
    }

    public boolean stackNotEmpty(AbstractInsnNode loc) {
        return this.basicFrameMap.get(loc).getStackSize() > 0;
    }

    public InsnList backupStack(AbstractInsnNode loc, int startFrom) {
        return FrameHelper.enter(this.basicFrameMap.get(loc), startFrom);
    }

    public InsnList restoreStack(AbstractInsnNode loc, int startFrom) {
        return FrameHelper.exit(this.basicFrameMap.get(loc), startFrom);
    }

    public int getStackHeight(AbstractInsnNode loc) {
        return FrameHelper.getOffset(this.basicFrameMap.get(loc));
    }
}

