/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.weaver;

import ch.usi.dag.disl.classcontext.ClassContext;
import ch.usi.dag.disl.dynamiccontext.DynamicContext;
import ch.usi.dag.disl.exception.DiSLFatalException;
import ch.usi.dag.disl.exception.DynamicContextException;
import ch.usi.dag.disl.processor.ProcCode;
import ch.usi.dag.disl.processor.generator.PIResolver;
import ch.usi.dag.disl.processor.generator.ProcInstance;
import ch.usi.dag.disl.processor.generator.ProcMethodInstance;
import ch.usi.dag.disl.processorcontext.ArgumentContext;
import ch.usi.dag.disl.processorcontext.ArgumentProcessorContext;
import ch.usi.dag.disl.processorcontext.ArgumentProcessorMode;
import ch.usi.dag.disl.snippet.Shadow;
import ch.usi.dag.disl.snippet.Snippet;
import ch.usi.dag.disl.snippet.SnippetCode;
import ch.usi.dag.disl.staticcontext.generator.SCGenerator;
import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.FrameHelper;
import ch.usi.dag.disl.weaver.WeavingInfo;
import ch.usi.dag.disl.weaver.pe.MaxCalculator;
import ch.usi.dag.disl.weaver.pe.PartialEvaluator;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeavingCode {
    static final String PROP_PE = "disl.parteval";
    private WeavingInfo info;
    private MethodNode method;
    private SnippetCode code;
    private InsnList iList;
    private AbstractInsnNode[] iArray;
    private Snippet snippet;
    private Shadow shadow;
    private AbstractInsnNode weavingLoc;
    private int maxLocals;
    private static final int INVALID_SLOT = -1;
    private static List<String> primitiveTypes = new LinkedList<String>();

    public WeavingCode(WeavingInfo weavingInfo, MethodNode method, SnippetCode src, Snippet snippet, Shadow shadow, AbstractInsnNode loc) {
        this.info = weavingInfo;
        this.method = method;
        this.code = src.clone();
        this.snippet = snippet;
        this.shadow = shadow;
        this.weavingLoc = loc;
        this.iList = this.code.getInstructions();
        this.iArray = this.iList.toArray();
        this.maxLocals = MaxCalculator.getMaxLocal(this.iList, method.desc, method.access);
    }

    public void fixStaticInfo(SCGenerator staticInfoHolder) {
        for (AbstractInsnNode instr : this.iList.toArray()) {
            AbstractInsnNode previous = instr.getPrevious();
            if (instr.getOpcode() != 182 || previous == null || previous.getOpcode() != 25) continue;
            MethodInsnNode invocation = (MethodInsnNode)instr;
            if (!staticInfoHolder.contains(this.shadow, invocation.owner, invocation.name)) continue;
            Object const_var = staticInfoHolder.get(this.shadow, invocation.owner, invocation.name);
            if (const_var != null) {
                this.code.getInstructions().insert(instr, AsmHelper.loadConst(const_var));
            } else {
                this.code.getInstructions().insert(instr, new InsnNode(1));
            }
            this.iList.remove(previous);
            this.iList.remove(instr);
        }
    }

    public void fixClassInfo() {
        for (AbstractInsnNode instr : this.iList.toArray()) {
            AbstractInsnNode previous = instr.getPrevious();
            if (instr.getOpcode() != 185 || previous == null || previous.getOpcode() != 18) continue;
            LdcInsnNode ldc = (LdcInsnNode)previous;
            MethodInsnNode invoke = (MethodInsnNode)instr;
            if (!(ldc.cst instanceof String) || !invoke.owner.equals(Type.getInternalName(ClassContext.class)) || !invoke.name.equals("asClass")) continue;
            Type clazz = Type.getObjectType(ldc.cst.toString());
            this.iList.insert(instr, new LdcInsnNode(clazz));
            this.iList.remove(ldc.getPrevious());
            this.iList.remove(ldc);
            this.iList.remove(invoke);
        }
    }

    private void preFixDynamicInfoCheck() throws DynamicContextException {
        for (AbstractInsnNode instr : AsmHelper.allInsnsFrom(this.iList)) {
            if (instr.getOpcode() != 185) continue;
            MethodInsnNode invoke = (MethodInsnNode)instr;
            if (!invoke.owner.equals(Type.getInternalName(DynamicContext.class)) || invoke.name.equals("getThis") || invoke.name.equals("getException")) continue;
            AbstractInsnNode secondOperand = instr.getPrevious();
            AbstractInsnNode firstOperand = secondOperand.getPrevious();
            switch (firstOperand.getOpcode()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    break;
                }
                default: {
                    throw new DynamicContextException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - pass the first (pos)" + " argument of a dynamic context method direcltly." + " ex: getStackValue(1, int.class)");
                }
            }
            if (AsmHelper.isTypeConstLoadInsn(secondOperand)) continue;
            throw new DynamicContextException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - pass the second (type)" + " argument of a dynamic context method direcltly." + " ex: getStackValue(1, int.class)");
        }
    }

    public void fixDynamicInfo(boolean throwing) throws DynamicContextException {
        this.preFixDynamicInfoCheck();
        Frame<BasicValue> basicframe = this.info.getBasicFrame(this.weavingLoc);
        Frame<SourceValue> sourceframe = this.info.getSourceFrame(this.weavingLoc);
        int exceptionslot = -1;
        if (throwing) {
            exceptionslot = this.method.maxLocals++;
        }
        for (AbstractInsnNode instr : this.iList.toArray()) {
            if (instr.getOpcode() != 185) continue;
            MethodInsnNode invoke = (MethodInsnNode)instr;
            if (!invoke.owner.equals(Type.getInternalName(DynamicContext.class))) continue;
            AbstractInsnNode prev = instr.getPrevious();
            if (invoke.name.equals("getThis")) {
                if ((this.method.access & 8) != 0) {
                    this.iList.insert(instr, new InsnNode(1));
                } else {
                    this.iList.insert(instr, new VarInsnNode(25, 0));
                }
                this.iList.remove(invoke);
                this.iList.remove(prev);
                continue;
            }
            if (invoke.name.equals("getException")) {
                if (throwing) {
                    this.iList.insert(instr, new VarInsnNode(25, exceptionslot));
                } else {
                    this.iList.insert(instr, new InsnNode(1));
                }
                this.iList.remove(invoke);
                this.iList.remove(prev);
                continue;
            }
            AbstractInsnNode next = instr.getNext();
            int operand = AsmHelper.getIntConstOperand(prev.getPrevious());
            Type t = AsmHelper.getTypeConstOperand(prev);
            if (invoke.name.equals("getStackValue")) {
                if (basicframe == null) {
                    this.iList.insert(instr, AsmHelper.loadDefault(t));
                    if (!AsmHelper.isReferenceType(t)) {
                        this.iList.insert(instr, AsmHelper.boxValueOnStack(t));
                    }
                } else {
                    int lopcode = t.getOpcode(21);
                    if (operand >= basicframe.getStackSize() || operand < 0) {
                        throw new DynamicContextException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - trying to access the stack item NO." + operand + ", but the size of the stack is " + basicframe.getStackSize());
                    }
                    Type targetType = FrameHelper.getStackByIndex(basicframe, operand).getType();
                    if (t.getSort() != targetType.getSort()) {
                        throw new DynamicContextException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - trying to access the stack item NO." + operand + " with a provided type \"" + t + "\", but we found \"" + targetType + "\".");
                    }
                    int size = FrameHelper.dupStack(sourceframe, this.method, operand, t, this.method.maxLocals);
                    if (!AsmHelper.isReferenceType(t)) {
                        this.iList.insert(instr, AsmHelper.boxValueOnStack(t));
                    }
                    this.iList.insert(instr, new VarInsnNode(lopcode, this.method.maxLocals));
                    this.method.maxLocals += size;
                }
            } else if (invoke.name.equals("getMethodArgumentValue")) {
                if (basicframe == null) {
                    basicframe = this.info.getRetFrame();
                }
                int slot = AsmHelper.getInternalParamIndex(this.method, operand);
                int args = Type.getArgumentTypes(this.method.desc).length;
                if (operand >= args || operand < 0) {
                    throw new DynamicContextException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - trying to access the method argument NO." + operand + ", but the size of the method argument is " + args);
                }
                Type targetType = basicframe.getLocal(slot).getType();
                if (t.getSort() != targetType.getSort()) {
                    throw new DynamicContextException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - trying to access the method argument NO." + operand + " with a provided type \"" + t + "\", but we found \"" + targetType + "\".");
                }
                if (!AsmHelper.isReferenceType(t)) {
                    this.iList.insert(instr, AsmHelper.boxValueOnStack(t));
                }
                this.iList.insert(instr, new VarInsnNode(t.getOpcode(21), slot));
            } else if (invoke.name.equals("getLocalVariableValue")) {
                if (basicframe == null) {
                    basicframe = this.info.getRetFrame();
                }
                if (operand >= basicframe.getLocals() || operand < 0) {
                    throw new DynamicContextException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - trying to access the local variable NO." + operand + ", but the size of the local varaibles is " + basicframe.getLocals());
                }
                Type targetType = basicframe.getLocal(operand).getType();
                if (t.getSort() != targetType.getSort()) {
                    throw new DynamicContextException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - trying to access the local variable NO." + operand + " with a provided type \"" + t + "\", but we found \"" + targetType + "\".");
                }
                if (!AsmHelper.isReferenceType(t)) {
                    this.iList.insert(instr, AsmHelper.boxValueOnStack(t));
                }
                this.iList.insert(instr, new VarInsnNode(t.getOpcode(21), operand));
            }
            this.iList.remove(instr.getPrevious());
            this.iList.remove(instr.getPrevious());
            this.iList.remove(instr.getPrevious());
            this.iList.remove(instr);
            if (next.getOpcode() != 192) continue;
            this.iList.remove(next);
        }
        for (AbstractInsnNode instr : this.iList.toArray()) {
            AbstractInsnNode prev = instr.getPrevious();
            if (prev == null || prev.getOpcode() != 184 || instr.getOpcode() != 182) continue;
            MethodInsnNode valueOf = (MethodInsnNode)prev;
            MethodInsnNode toValue = (MethodInsnNode)instr;
            if (!primitiveTypes.contains(valueOf.owner) || !valueOf.owner.equals(toValue.owner) || !valueOf.name.equals("valueOf") || !toValue.name.endsWith("Value") || !Type.getArgumentTypes(valueOf.desc)[0].equals(Type.getReturnType(toValue.desc))) continue;
            this.iList.remove(prev);
            this.iList.remove(instr);
        }
        if (throwing) {
            this.iList.insertBefore(this.iList.getFirst(), new VarInsnNode(58, exceptionslot));
            this.iList.add(new VarInsnNode(25, exceptionslot));
            this.iList.add(new InsnNode(191));
        }
    }

    public void fixLocalIndex() {
        this.method.maxLocals = this.fixLocalIndex(this.iList, this.method.maxLocals);
    }

    private int fixLocalIndex(InsnList src, int offset) {
        int max = offset;
        for (AbstractInsnNode instr : AsmHelper.allInsnsFrom(src)) {
            if (instr instanceof VarInsnNode) {
                VarInsnNode varInstr = (VarInsnNode)instr;
                varInstr.var += offset;
                switch (varInstr.getOpcode()) {
                    case 22: 
                    case 24: 
                    case 55: 
                    case 57: {
                        max = Math.max(varInstr.var + 2, max);
                        break;
                    }
                    default: {
                        max = Math.max(varInstr.var + 1, max);
                        break;
                    }
                }
                continue;
            }
            if (!(instr instanceof IincInsnNode)) continue;
            IincInsnNode iinc = (IincInsnNode)instr;
            iinc.var += offset;
            max = Math.max(iinc.var + 1, max);
        }
        return max;
    }

    private void fixArgumentContext(InsnList instructions, int position, int totalCount, Type type) {
        for (AbstractInsnNode instr : instructions.toArray()) {
            AbstractInsnNode previous = instr.getPrevious();
            if (instr.getOpcode() != 185 || previous == null || previous.getOpcode() != 25) continue;
            MethodInsnNode invoke = (MethodInsnNode)instr;
            if (!invoke.owner.equals(Type.getInternalName(ArgumentContext.class))) continue;
            if (invoke.name.equals("getPosition")) {
                instructions.insert(instr, AsmHelper.loadConst(position));
            } else if (invoke.name.equals("getTotalCount")) {
                instructions.insert(instr, AsmHelper.loadConst(totalCount));
            } else if (invoke.name.equals("getTypeDescriptor")) {
                instructions.insert(instr, AsmHelper.loadConst(type.toString()));
            }
            instructions.remove(previous);
            instructions.remove(instr);
        }
    }

    private InsnList procInMethod(ProcInstance processor) {
        InsnList ilist = new InsnList();
        for (ProcMethodInstance processorMethod : processor.getMethods()) {
            ProcCode code = processorMethod.getCode().clone();
            InsnList instructions = code.getInstructions();
            int position = processorMethod.getArgPos();
            int totalCount = processorMethod.getArgsCount();
            Type type = processorMethod.getArgType().getASMType();
            this.fixArgumentContext(instructions, position, totalCount, type);
            AbstractInsnNode start = instructions.getFirst();
            VarInsnNode target = new VarInsnNode(type.getOpcode(54), 0);
            instructions.insertBefore(start, target);
            this.maxLocals = Math.max(this.fixLocalIndex(instructions, this.maxLocals), this.maxLocals + type.getSize());
            instructions.insertBefore((AbstractInsnNode)target, new VarInsnNode(type.getOpcode(21), AsmHelper.getInternalParamIndex(this.method, processorMethod.getArgPos()) - this.method.maxLocals));
            ilist.add(instructions);
            this.method.tryCatchBlocks.addAll(code.getTryCatchBlocks());
        }
        return ilist;
    }

    private InsnList procBeforeInvoke(ProcInstance processor) {
        Frame<SourceValue> frame = this.info.getSourceFrame(this.weavingLoc);
        InsnList ilist = new InsnList();
        for (ProcMethodInstance processorMethod : processor.getMethods()) {
            ProcCode code = processorMethod.getCode().clone();
            InsnList instructions = code.getInstructions();
            int position = processorMethod.getArgPos();
            int totalCount = processorMethod.getArgsCount();
            Type type = processorMethod.getArgType().getASMType();
            this.fixArgumentContext(instructions, position, totalCount, type);
            SourceValue source = FrameHelper.getStackByIndex(frame, totalCount - 1 - position);
            int sopcode = type.getOpcode(54);
            for (AbstractInsnNode itr : source.insns) {
                this.method.instructions.insert(itr, new VarInsnNode(sopcode, this.method.maxLocals + this.maxLocals));
                this.method.instructions.insert(itr, new InsnNode(type.getSize() == 2 ? 92 : 89));
            }
            this.maxLocals = Math.max(this.fixLocalIndex(instructions, this.maxLocals), this.maxLocals + type.getSize());
            ilist.add(instructions);
            this.method.tryCatchBlocks.addAll(code.getTryCatchBlocks());
        }
        return ilist;
    }

    public void fixProcessor(PIResolver piResolver) {
        for (int i : this.code.getInvokedProcessors().keySet()) {
            AbstractInsnNode instr = this.iArray[i];
            ProcInstance processor = piResolver.get(this.shadow, i);
            if (processor != null) {
                if (processor.getProcApplyType() == ArgumentProcessorMode.METHOD_ARGS) {
                    this.iList.insert(instr, this.procInMethod(processor));
                } else {
                    this.iList.insert(instr, this.procBeforeInvoke(processor));
                }
            }
            this.iList.remove(instr.getPrevious());
            this.iList.remove(instr.getPrevious());
            this.iList.remove(instr.getPrevious());
            this.iList.remove(instr);
        }
    }

    private InsnList createGetArgsCode(String methodDescriptor) {
        InsnList insnList = new InsnList();
        Type[] argTypes = Type.getArgumentTypes(methodDescriptor);
        insnList.add(AsmHelper.loadConst(argTypes.length));
        insnList.add(new TypeInsnNode(189, "java/lang/Object"));
        int argIndex = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            insnList.add(new InsnNode(89));
            insnList.add(AsmHelper.loadConst(i));
            Type argType = argTypes[i];
            int loadOpcode = argType.getOpcode(21);
            insnList.add(new VarInsnNode(loadOpcode, argIndex));
            if (!AsmHelper.isReferenceType(argType)) {
                insnList.add(AsmHelper.boxValueOnStack(argType));
            }
            insnList.add(new InsnNode(83));
            argIndex += argType.getSize();
        }
        return insnList;
    }

    public void fixProcessorInfo() {
        for (AbstractInsnNode instr : this.iList.toArray()) {
            String desc;
            if (instr.getOpcode() != 185) continue;
            MethodInsnNode invoke = (MethodInsnNode)instr;
            if (!invoke.owner.equals(Type.getInternalName(ArgumentProcessorContext.class))) continue;
            AbstractInsnNode prev = instr.getPrevious();
            if (prev.getOpcode() != 178) {
                throw new DiSLFatalException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - unknown processor mode");
            }
            ArgumentProcessorMode procApplyType = ArgumentProcessorMode.valueOf(((FieldInsnNode)prev).name);
            if (invoke.name.equals("getArgs")) {
                InsnList args = null;
                if (procApplyType == ArgumentProcessorMode.METHOD_ARGS) {
                    args = this.createGetArgsCode(this.method.desc);
                    this.fixLocalIndex(args, ((this.method.access & 8) != 0 ? 0 : 1) - this.method.maxLocals);
                } else {
                    AbstractInsnNode callee = AsmHelper.skipVirtualInsns(this.shadow.getRegionStart(), true);
                    if (!(callee instanceof MethodInsnNode)) {
                        throw new DiSLFatalException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - unexpected bytecode when applying" + " \"ArgumentProcessorContext.getArgs\"");
                    }
                    desc = ((MethodInsnNode)callee).desc;
                    Type[] argTypes = Type.getArgumentTypes(desc);
                    Frame<SourceValue> frame = this.info.getSourceFrame(callee);
                    if (frame == null) {
                        throw new DiSLFatalException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - unexpected bytecode when applying" + " \"ArgumentProcessorContext.getArgs\"");
                    }
                    int argIndex = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        SourceValue source = FrameHelper.getStackByIndex(frame, argTypes.length - 1 - i);
                        Type type = argTypes[i];
                        int sopcode = type.getOpcode(54);
                        for (AbstractInsnNode itr : source.insns) {
                            this.method.instructions.insert(itr, new VarInsnNode(sopcode, this.method.maxLocals + this.maxLocals + argIndex));
                            this.method.instructions.insert(itr, new InsnNode(type.getSize() == 2 ? 92 : 89));
                        }
                        argIndex += type.getSize();
                    }
                    args = this.createGetArgsCode(desc);
                    this.maxLocals = Math.max(this.fixLocalIndex(args, this.maxLocals), this.maxLocals + argIndex);
                }
                this.iList.insert(instr, args);
            } else if (invoke.name.equals("getReceiver")) {
                if (procApplyType == ArgumentProcessorMode.METHOD_ARGS) {
                    if ((this.method.access & 8) != 0) {
                        this.iList.insert(instr, new InsnNode(1));
                    } else {
                        this.iList.insert(instr, new VarInsnNode(25, -this.method.maxLocals));
                    }
                } else {
                    AbstractInsnNode callee = AsmHelper.skipVirtualInsns(this.shadow.getRegionStart(), true);
                    if (!(callee instanceof MethodInsnNode)) {
                        throw new DiSLFatalException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - unexpected bytecode when applying" + " \"ArgumentProcessorContext.getReceiver\"");
                    }
                    Frame<SourceValue> frame = this.info.getSourceFrame(callee);
                    if (frame == null) {
                        throw new DiSLFatalException("In snippet " + this.snippet.getOriginClassName() + "." + this.snippet.getOriginMethodName() + " - unexpected bytecode when applying" + " \"ArgumentProcessorContext.getReceiver\"");
                    }
                    if (callee.getOpcode() == 184) {
                        this.iList.insert(instr, new InsnNode(1));
                    } else {
                        desc = ((MethodInsnNode)callee).desc;
                        SourceValue source = FrameHelper.getStackByIndex(frame, Type.getArgumentTypes(desc).length);
                        for (AbstractInsnNode itr : source.insns) {
                            this.method.instructions.insert(itr, new VarInsnNode(58, this.method.maxLocals + this.maxLocals));
                            this.method.instructions.insert(itr, new InsnNode(89));
                        }
                        this.iList.insert(instr, new VarInsnNode(25, this.maxLocals));
                        ++this.maxLocals;
                    }
                }
            }
            this.iList.remove(instr.getPrevious());
            this.iList.remove(instr.getPrevious());
            this.iList.remove(instr);
        }
    }

    public InsnList getiList() {
        return this.iList;
    }

    public List<TryCatchBlockNode> getTCBs() {
        return this.code.getTryCatchBlocks();
    }

    public void transform(SCGenerator staticInfoHolder, PIResolver piResolver, boolean throwing) throws DynamicContextException {
        this.fixProcessor(piResolver);
        this.fixProcessorInfo();
        this.fixStaticInfo(staticInfoHolder);
        this.fixClassInfo();
        this.fixLocalIndex();
        this.optimize();
        this.fixDynamicInfo(throwing);
    }

    public void optimize() {
        block4: {
            PartialEvaluator pe;
            char option;
            block3: {
                String prop_pe = System.getProperty(PROP_PE);
                if (prop_pe == null || prop_pe.length() < 2 || prop_pe.charAt(0) != 'o' && prop_pe.charAt(0) != 'O') {
                    return;
                }
                option = prop_pe.charAt(1);
                pe = new PartialEvaluator(this.iList, this.code.getTryCatchBlocks(), this.method.desc, this.method.access);
                if (option < '1' || option > '3') break block3;
                for (int i = 0; i < option - 48; ++i) {
                    pe.evaluate();
                }
                break block4;
            }
            if (option != 'x') break block4;
            while (pe.evaluate()) {
            }
        }
    }

    static {
        primitiveTypes.add("java/lang/Boolean");
        primitiveTypes.add("java/lang/Byte");
        primitiveTypes.add("java/lang/Character");
        primitiveTypes.add("java/lang/Double");
        primitiveTypes.add("java/lang/Float");
        primitiveTypes.add("java/lang/Integer");
        primitiveTypes.add("java/lang/Long");
    }
}

