/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.weaver;

import ch.usi.dag.disl.annotation.After;
import ch.usi.dag.disl.annotation.AfterReturning;
import ch.usi.dag.disl.annotation.AfterThrowing;
import ch.usi.dag.disl.annotation.Before;
import ch.usi.dag.disl.annotation.SyntheticLocal;
import ch.usi.dag.disl.exception.DynamicContextException;
import ch.usi.dag.disl.localvar.SyntheticLocalVar;
import ch.usi.dag.disl.processor.generator.PIResolver;
import ch.usi.dag.disl.snippet.Shadow;
import ch.usi.dag.disl.snippet.Snippet;
import ch.usi.dag.disl.snippet.SnippetCode;
import ch.usi.dag.disl.staticcontext.generator.SCGenerator;
import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.weaver.AdvancedSorter;
import ch.usi.dag.disl.weaver.WeavingCode;
import ch.usi.dag.disl.weaver.WeavingInfo;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Weaver {
    private static void static2Local(MethodNode methodNode, List<SyntheticLocalVar> syntheticLocalVars) {
        InsnList instructions = methodNode.instructions;
        AbstractInsnNode first = instructions.getFirst();
        for (SyntheticLocalVar var : syntheticLocalVars) {
            if (var.getInitialize() == SyntheticLocal.Initialize.NEVER) continue;
            if (var.hasInitCode()) {
                instructions.insertBefore(first, AsmHelper.cloneInsnList(var.getInitCode()));
                continue;
            }
            Type type = var.getType();
            if (type.getSort() != 9) {
                instructions.insertBefore(first, AsmHelper.loadDefault(type));
            } else {
                instructions.insertBefore(first, AsmHelper.loadDefault());
                instructions.insertBefore(first, AsmHelper.checkCast(type));
            }
            instructions.insertBefore(first, AsmHelper.putStatic(var.getOwner(), var.getName(), type.getDescriptor()));
        }
        for (AbstractInsnNode insn : instructions.toArray()) {
            int opcode = insn.getOpcode();
            if (!AsmHelper.isStaticFieldAccess(opcode)) continue;
            FieldInsnNode fieldInsn = (FieldInsnNode)insn;
            String varId = SyntheticLocalVar.fqFieldNameFor(fieldInsn.owner, fieldInsn.name);
            int index = 0;
            int count = 0;
            for (SyntheticLocalVar var : syntheticLocalVars) {
                if (varId.equals(var.getID())) break;
                index += var.getType().getSize();
                ++count;
            }
            if (count == syntheticLocalVars.size()) continue;
            Type type = Type.getType(fieldInsn.desc);
            int slot = methodNode.maxLocals + index;
            instructions.insertBefore((AbstractInsnNode)fieldInsn, opcode == 178 ? AsmHelper.loadVar(type, slot) : AsmHelper.storeVar(type, slot));
            instructions.remove(fieldInsn);
        }
        methodNode.maxLocals += syntheticLocalVars.size();
    }

    private static LabelNode getEndLabel(MethodNode methodNode, AbstractInsnNode instr) {
        if (instr.getNext() != null && AsmHelper.skipVirtualInsns(instr.getNext(), true) != null) {
            LabelNode branch = new LabelNode();
            methodNode.instructions.insert(instr, branch);
            JumpInsnNode jump = new JumpInsnNode(167, branch);
            methodNode.instructions.insert(instr, jump);
            instr = jump;
        }
        LabelNode label = new LabelNode();
        methodNode.instructions.insert(instr, label);
        return label;
    }

    public static TryCatchBlockNode getTryCatchBlock(MethodNode methodNode, AbstractInsnNode start, AbstractInsnNode end) {
        InsnList ilst = methodNode.instructions;
        int new_start_offset = ilst.indexOf(start);
        int new_end_offset = ilst.indexOf(end);
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            int start_offset = ilst.indexOf(tcb.start);
            int end_offset = ilst.indexOf(tcb.end);
            if (AsmHelper.offsetBefore(ilst, new_start_offset, start_offset) && AsmHelper.offsetBefore(ilst, start_offset, new_end_offset) && AsmHelper.offsetBefore(ilst, new_end_offset, end_offset)) {
                new_start_offset = start_offset;
                continue;
            }
            if (!AsmHelper.offsetBefore(ilst, start_offset, new_start_offset) || !AsmHelper.offsetBefore(ilst, new_start_offset, end_offset) || !AsmHelper.offsetBefore(ilst, end_offset, new_end_offset)) continue;
            new_start_offset = end_offset;
        }
        start = ilst.get(new_start_offset);
        end = ilst.get(new_end_offset);
        LabelNode startLabel = (LabelNode)start;
        LabelNode endLabel = Weaver.getEndLabel(methodNode, end);
        return new TryCatchBlockNode(startLabel, endLabel, endLabel, null);
    }

    private static void insert(MethodNode methodNode, SCGenerator staticInfoHolder, PIResolver piResolver, WeavingInfo info, Snippet snippet, SnippetCode code, Shadow shadow, AbstractInsnNode loc) throws DynamicContextException {
        if (code.containsHandledException() && info.stackNotEmpty(loc)) {
            InsnList backup = info.backupStack(loc, methodNode.maxLocals);
            InsnList restore = info.restoreStack(loc, methodNode.maxLocals);
            methodNode.maxLocals += info.getStackHeight(loc);
            methodNode.instructions.insertBefore(loc, backup);
            methodNode.instructions.insert(loc, restore);
        }
        WeavingCode wCode = new WeavingCode(info, methodNode, code, snippet, shadow, loc);
        wCode.transform(staticInfoHolder, piResolver, false);
        methodNode.instructions.insert(loc, wCode.getiList());
        methodNode.tryCatchBlocks.addAll(wCode.getTCBs());
    }

    public static void instrument(ClassNode classNode, MethodNode methodNode, Map<Snippet, List<Shadow>> snippetMarkings, List<SyntheticLocalVar> syntheticLocalVars, SCGenerator staticInfoHolder, PIResolver piResolver) throws DynamicContextException {
        WeavingInfo info = new WeavingInfo(classNode, methodNode, snippetMarkings);
        for (Snippet snippet : info.getSortedSnippets()) {
            List<Shadow> shadows = snippetMarkings.get(snippet);
            SnippetCode code = snippet.getCode();
            if (code == null) continue;
            if (snippet.getAnnotationClass().equals(Before.class)) {
                for (Shadow shadow : shadows) {
                    AbstractInsnNode loc = shadow.getWeavingRegion().getStart();
                    Weaver.insert(methodNode, staticInfoHolder, piResolver, info, snippet, code, shadow, loc);
                }
            }
            if (snippet.getAnnotationClass().equals(AfterReturning.class) || snippet.getAnnotationClass().equals(After.class)) {
                for (Shadow shadow : shadows) {
                    for (AbstractInsnNode loc : shadow.getWeavingRegion().getEnds()) {
                        Weaver.insert(methodNode, staticInfoHolder, piResolver, info, snippet, code, shadow, loc);
                    }
                }
            }
            if (!snippet.getAnnotationClass().equals(AfterThrowing.class) && !snippet.getAnnotationClass().equals(After.class)) continue;
            for (Shadow shadow : shadows) {
                AbstractInsnNode loc;
                Shadow.WeavingRegion region = shadow.getWeavingRegion();
                loc = region.getAfterThrowEnd();
                WeavingCode wCode = new WeavingCode(info, methodNode, code, snippet, shadow, loc);
                wCode.transform(staticInfoHolder, piResolver, true);
                TryCatchBlockNode tcb = Weaver.getTryCatchBlock(methodNode, region.getAfterThrowStart(), loc);
                methodNode.instructions.insert((AbstractInsnNode)tcb.handler, wCode.getiList());
                methodNode.tryCatchBlocks.add(tcb);
                methodNode.tryCatchBlocks.addAll(wCode.getTCBs());
            }
        }
        Weaver.static2Local(methodNode, syntheticLocalVars);
        AdvancedSorter.sort(methodNode);
    }
}

