/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.utilinstr.tlvinserter;

import ch.usi.dag.disl.localvar.ThreadLocalVar;
import ch.usi.dag.disl.util.AsmHelper;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TLVInserter
extends ClassVisitor {
    private final Set<ThreadLocalVar> threadLocalVars;

    public TLVInserter(ClassVisitor cv, Set<ThreadLocalVar> tlvs) {
        super(262144, cv);
        this.threadLocalVars = tlvs;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        if ("<init>".equals(name)) {
            return new TLVInitializer(super.visitMethod(access, name, desc, sig, exceptions), access, name, desc);
        }
        return super.visitMethod(access, name, desc, sig, exceptions);
    }

    @Override
    public void visitEnd() {
        for (ThreadLocalVar tlv : this.threadLocalVars) {
            super.visitField(1, tlv.getName(), tlv.getTypeAsDesc(), null, null);
        }
        super.visitEnd();
    }

    private class TLVInitializer
    extends AdviceAdapter {
        private TLVInitializer(MethodVisitor mv, int access, String name, String desc) {
            super(262144, mv, access, name, desc);
        }

        protected void onMethodEnter() {
            String THREAD_CLASS_NAME = Type.getType(Thread.class).getInternalName();
            String CURRENTTHREAD_METHOD_NAME = "currentThread";
            String CURRENTTHREAD_METHOD_SIG = "()L" + THREAD_CLASS_NAME + ";";
            for (ThreadLocalVar tlv : TLVInserter.this.threadLocalVars) {
                Label getDefaultValue = new Label();
                Label putValue = new Label();
                this.visitVarInsn(25, 0);
                if (tlv.isInheritable()) {
                    this.visitMethodInsn(184, THREAD_CLASS_NAME, "currentThread", CURRENTTHREAD_METHOD_SIG);
                    this.visitJumpInsn(198, getDefaultValue);
                    this.visitMethodInsn(184, THREAD_CLASS_NAME, "currentThread", CURRENTTHREAD_METHOD_SIG);
                    this.visitFieldInsn(180, THREAD_CLASS_NAME, tlv.getName(), tlv.getTypeAsDesc());
                    this.visitJumpInsn(167, putValue);
                }
                this.visitLabel(getDefaultValue);
                Object defaultVal = tlv.getDefaultValue();
                if (defaultVal != null) {
                    this.visitLdcInsn(defaultVal);
                } else if (AsmHelper.isReferenceType(tlv.getType())) {
                    this.visitInsn(1);
                } else {
                    this.visitLdcInsn(0);
                }
                this.visitLabel(putValue);
                this.visitFieldInsn(181, THREAD_CLASS_NAME, tlv.getName(), tlv.getTypeAsDesc());
            }
        }
    }
}

