/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.util;

import ch.usi.dag.disl.exception.ReflectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHelper {
    public static <T> T createInstance(Class<T> classToInstantiate, Object ... args) throws ReflectionException {
        try {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Constructor<T> constructor = classToInstantiate.getConstructor(argTypes);
            constructor.setAccessible(true);
            return classToInstantiate.cast(constructor.newInstance(args));
        }
        catch (Exception e) {
            throw new ReflectionException("Class " + classToInstantiate.getName() + " cannot be instantiated", e);
        }
    }

    private static String asmNameToJavaName(String asmClassName) {
        return asmClassName.replace('/', '.');
    }

    public static Class<?> resolveClass(Type asmType) throws ReflectionException {
        try {
            return Class.forName(ReflectionHelper.asmNameToJavaName(asmType.getInternalName()));
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Class " + asmType.getClassName() + " cannot be resolved", e);
        }
    }

    public static Method resolveMethod(Class<?> methodOwner, String methodName) throws ReflectionException {
        try {
            return methodOwner.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Method " + methodName + " in class " + methodOwner.getName() + " cannot be found." + " Snippet was probably compiled against a modified" + " (different) class");
        }
    }

    public static boolean implementsInterface(Class<?> classToSearch, Class<?> interfaceToImplement) {
        while (classToSearch != null) {
            for (Class<?> iface : classToSearch.getInterfaces()) {
                if (!iface.equals(interfaceToImplement)) continue;
                return true;
            }
            classToSearch = classToSearch.getSuperclass();
        }
        return false;
    }
}

