/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.util;

import ch.usi.dag.disl.exception.DiSLFatalException;
import ch.usi.dag.disl.util.AsmHelper;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;
import org.objectweb.asm.tree.analysis.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameHelper {
    public static Analyzer<BasicValue> getBasicAnalyzer() {
        return new Analyzer<BasicValue>(new BasicInterpreter());
    }

    public static int getOffset(Frame<BasicValue> frame) {
        int offset = 0;
        for (int i = frame.getStackSize() - 1; i >= 0; --i) {
            BasicValue v = frame.getStack(i);
            offset += v.getSize();
        }
        return offset;
    }

    public static InsnList enter(Frame<BasicValue> frame, int offset) {
        InsnList ilst = new InsnList();
        for (int i = frame.getStackSize() - 1; i >= 0; --i) {
            BasicValue v = frame.getStack(i);
            ilst.add(new VarInsnNode(v.getType().getOpcode(54), offset));
            offset += v.getSize();
        }
        return ilst;
    }

    public static InsnList exit(Frame<BasicValue> frame, int offset) {
        InsnList ilst = new InsnList();
        ilst.add(new LabelNode());
        for (int i = frame.getStackSize() - 1; i >= 0; --i) {
            BasicValue v = frame.getStack(i);
            ilst.insertBefore(ilst.getFirst(), new VarInsnNode(v.getType().getOpcode(21), offset));
            offset += v.getSize();
        }
        return ilst;
    }

    public static Analyzer<SourceValue> getSourceAnalyzer() {
        return new Analyzer<SourceValue>(new SourceInterpreter());
    }

    public static <T extends Value> T getStack(Frame<T> frame, int depth) {
        int index = 0;
        while (depth > 0) {
            depth -= frame.getStack(frame.getStackSize() - 1 - index).getSize();
            ++index;
        }
        return frame.getStack(frame.getStackSize() - 1 - index);
    }

    public static <T extends Value> T getStackByIndex(Frame<T> frame, int index) {
        return frame.getStack(frame.getStackSize() - 1 - index);
    }

    public static int dupStack(Frame<SourceValue> frame, MethodNode method, int operand, Type type, int slot) {
        SourceValue source = FrameHelper.getStackByIndex(frame, operand);
        block6: for (AbstractInsnNode insn : source.insns) {
            switch (insn.getOpcode()) {
                case 92: {
                    if (source.size != 1) break;
                    FrameHelper.dupStack(frame, method, operand + 2, type, slot);
                    continue block6;
                }
                case 93: {
                    if (source.size != 1) break;
                    FrameHelper.dupStack(frame, method, operand + 3, type, slot);
                    continue block6;
                }
                case 94: {
                    if (source.size != 1) break;
                    SourceValue x2 = FrameHelper.getStackByIndex(frame, operand + 2);
                    FrameHelper.dupStack(frame, method, operand + (4 - x2.size), type, slot);
                    continue block6;
                }
                case 95: {
                    if (operand <= 0 || !FrameHelper.getStackByIndex(frame, (int)(operand - 1)).insns.contains(insn)) break;
                    method.instructions.insertBefore(insn, new InsnNode(89));
                    method.instructions.insertBefore(insn, AsmHelper.storeVar(type, slot));
                    continue block6;
                }
            }
            method.instructions.insert(insn, AsmHelper.storeVar(type, slot));
            method.instructions.insert(insn, new InsnNode(source.size == 2 ? 92 : 89));
        }
        return source.size;
    }

    public static <V extends Value> Frame<V>[] getFrames(Analyzer<V> analyzer, String clazz, MethodNode method) {
        try {
            analyzer.analyze(clazz, method);
        }
        catch (AnalyzerException e) {
            throw new DiSLFatalException("Cause by AnalyzerException : \n" + e.getMessage());
        }
        return analyzer.getFrames();
    }

    public static Frame<BasicValue>[] getBasicFrames(String clazz, MethodNode method) {
        return FrameHelper.getFrames(FrameHelper.getBasicAnalyzer(), clazz, method);
    }

    public static Frame<SourceValue>[] getSourceFrames(String clazz, MethodNode method) {
        return FrameHelper.getFrames(FrameHelper.getSourceAnalyzer(), clazz, method);
    }

    public static <V extends Value> Map<AbstractInsnNode, Frame<V>> createMapping(Analyzer<V> analyzer, String clazz, MethodNode method) {
        HashMap<AbstractInsnNode, Frame<Frame<V>>> mapping = new HashMap<AbstractInsnNode, Frame<Frame<V>>>();
        Frame<V>[] frames = FrameHelper.getFrames(analyzer, clazz, method);
        for (int i = 0; i < method.instructions.size(); ++i) {
            mapping.put(method.instructions.get(i), frames[i]);
        }
        return mapping;
    }

    public static Map<AbstractInsnNode, Frame<BasicValue>> createBasicMapping(String clazz, MethodNode method) {
        return FrameHelper.createMapping(FrameHelper.getBasicAnalyzer(), clazz, method);
    }

    public static Map<AbstractInsnNode, Frame<SourceValue>> createSourceMapping(String clazz, MethodNode method) {
        return FrameHelper.createMapping(FrameHelper.getSourceAnalyzer(), clazz, method);
    }
}

