/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.util;

import ch.usi.dag.disl.util.AsmHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBlockCalc {
    public static List<AbstractInsnNode> getAll(InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks, boolean isPrecise) {
        HashSet<AbstractInsnNode> bbStarts = new HashSet<AbstractInsnNode>(){

            @Override
            public boolean add(AbstractInsnNode insn) {
                return super.add(AsmHelper.skipVirtualInsnsForward(insn));
            }

            @Override
            public boolean addAll(Collection<? extends AbstractInsnNode> insns) {
                boolean result = false;
                for (AbstractInsnNode abstractInsnNode : insns) {
                    boolean modified = this.add(abstractInsnNode);
                    result = result || modified;
                }
                return result;
            }
        };
        bbStarts.add(instructions.getFirst());
        for (AbstractInsnNode insn : AsmHelper.allInsnsFrom(instructions)) {
            switch (insn.getType()) {
                case 7: {
                    AbstractInsnNode nextInsn;
                    bbStarts.add(((JumpInsnNode)insn).label);
                    if (insn.getOpcode() == 167 || (nextInsn = AsmHelper.nextNonVirtualInsn(insn)) == null) break;
                    bbStarts.add(nextInsn);
                    break;
                }
                case 12: {
                    LookupSwitchInsnNode lsInsn = (LookupSwitchInsnNode)insn;
                    bbStarts.addAll(lsInsn.labels);
                    bbStarts.add(lsInsn.dflt);
                    break;
                }
                case 11: {
                    TableSwitchInsnNode tsInsn = (TableSwitchInsnNode)insn;
                    bbStarts.addAll(tsInsn.labels);
                    bbStarts.add(tsInsn.dflt);
                    break;
                }
            }
            if (!isPrecise || !AsmHelper.mightThrowException(insn)) continue;
            bbStarts.add(insn.getNext());
        }
        for (TryCatchBlockNode tryCatchBlock : tryCatchBlocks) {
            bbStarts.add(tryCatchBlock.handler);
        }
        ArrayList<AbstractInsnNode> result = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode insn : AsmHelper.allInsnsFrom(instructions)) {
            if (!bbStarts.contains(insn)) continue;
            result.add(insn);
        }
        return result;
    }
}

