/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.staticcontext.uid;

import ch.usi.dag.disl.exception.StaticContextException;
import ch.usi.dag.disl.staticcontext.uid.AbstractIdCalculator;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

class IdHolder {
    private PrintWriter output = null;
    private AbstractIdCalculator idCalc;
    private Map<String, Integer> strToId = new HashMap<String, Integer>();

    public IdHolder(AbstractIdCalculator idCalc, String outputFileName) {
        this.idCalc = idCalc;
        try {
            this.output = new PrintWriter(outputFileName);
        }
        catch (FileNotFoundException e) {
            throw new StaticContextException("Cannot create output for AbstractUniqueId context", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                IdHolder.this.output.close();
            }
        });
    }

    public synchronized int getID(String forValue) {
        Integer alreadyAssignedId = this.strToId.get(forValue);
        if (alreadyAssignedId != null) {
            return alreadyAssignedId;
        }
        return this.newID(forValue);
    }

    private int newID(String forValue) {
        int newId = this.idCalc.getId();
        this.strToId.put(forValue, newId);
        this.output.println(newId + "\t" + forValue);
        this.output.flush();
        return newId;
    }
}

