/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.staticcontext.generator;

import ch.usi.dag.disl.coderep.StaticContextMethod;
import ch.usi.dag.disl.exception.ReflectionException;
import ch.usi.dag.disl.exception.StaticContextGenException;
import ch.usi.dag.disl.processor.ProcMethod;
import ch.usi.dag.disl.resolver.SCResolver;
import ch.usi.dag.disl.snippet.ProcInvocation;
import ch.usi.dag.disl.snippet.Shadow;
import ch.usi.dag.disl.snippet.Snippet;
import ch.usi.dag.disl.snippet.SnippetCode;
import ch.usi.dag.disl.staticcontext.StaticContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCGenerator {
    private final Map<StaticContextKey, Object> staticInfoData = new HashMap<StaticContextKey, Object>();

    private static boolean __nullOrEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    public SCGenerator(Map<Snippet, List<Shadow>> snippetMarkings) throws ReflectionException, StaticContextGenException {
        this.computeStaticInfo(snippetMarkings);
    }

    private void computeStaticInfo(Map<Snippet, List<Shadow>> snippetMarkings) throws ReflectionException, StaticContextGenException {
        for (Snippet snippet : snippetMarkings.keySet()) {
            for (Shadow shadow : snippetMarkings.get(snippet)) {
                SnippetCode snippetCode = snippet.getCode();
                Set<StaticContextMethod> scMethods = snippetCode.getStaticContexts();
                for (ProcInvocation pi : snippetCode.getInvokedProcessors().values()) {
                    for (ProcMethod pm : pi.getProcessor().getMethods()) {
                        scMethods.addAll(pm.getCode().getStaticContexts());
                    }
                }
                for (StaticContextMethod scm : scMethods) {
                    StaticContext staticContext = SCResolver.getInstance().getStaticContextInstance(scm.getReferencedClass(), shadow);
                    Object result = this.getStaticContextData(staticContext, scm.getMethod());
                    this.put(shadow, scm.getId(), result);
                }
            }
        }
    }

    private Object getStaticContextData(StaticContext staticContext, Method method) throws StaticContextGenException, ReflectionException {
        try {
            method.setAccessible(true);
            return method.invoke((Object)staticContext, new Object[0]);
        }
        catch (Exception e) {
            String message = String.format("Invocation of static context method %s failed", method.getName());
            throw new StaticContextGenException(message, e);
        }
    }

    public boolean contains(Shadow shadow, String infoClass, String infoMethod) {
        return this.staticInfoData.containsKey(new StaticContextKey(shadow, infoClass, infoMethod));
    }

    public Object get(Shadow shadow, String infoClass, String infoMethod) {
        return this.staticInfoData.get(new StaticContextKey(shadow, infoClass, infoMethod));
    }

    private void put(Shadow shadow, String methodId, Object value) {
        this.staticInfoData.put(new StaticContextKey(shadow, methodId), value);
    }

    private static final class StaticContextKey {
        private final Shadow shadow;
        private final String methodId;
        private static final int __PRIME__ = 31;

        public StaticContextKey(Shadow shadow, String methodId) {
            this.shadow = shadow;
            this.methodId = methodId;
        }

        public StaticContextKey(Shadow shadow, String className, String methodName) {
            this(shadow, className + "." + methodName);
        }

        public int hashCode() {
            int result = 31;
            result += this.shadow == null ? 0 : this.shadow.hashCode();
            result *= 31;
            return result += this.methodId == null ? 0 : this.methodId.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof StaticContextKey) {
                StaticContextKey that = (StaticContextKey)object;
                boolean shadowsEqual = SCGenerator.__nullOrEqual(this.shadow, that.shadow);
                if (shadowsEqual) {
                    return SCGenerator.__nullOrEqual(this.methodId, that.methodId);
                }
            }
            return false;
        }
    }
}

