/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.staticcontext;

import ch.usi.dag.disl.staticcontext.BasicBlockStaticContext;
import ch.usi.dag.disl.util.cfg.BasicBlock;
import ch.usi.dag.disl.util.cfg.CtrlFlowGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class LoopStaticContext
extends BasicBlockStaticContext {
    private Map<BasicBlock, Set<BasicBlock>> dominatormapping;

    protected CtrlFlowGraph produceCustomData() {
        boolean changed;
        MethodNode method = this.staticContextData.getMethodNode();
        CtrlFlowGraph cfg = CtrlFlowGraph.build(method);
        this.dominatormapping = new HashMap<BasicBlock, Set<BasicBlock>>();
        HashSet<BasicBlock> entries = new HashSet<BasicBlock>();
        entries.add(cfg.getBB(method.instructions.getFirst()));
        for (TryCatchBlockNode tcb : method.tryCatchBlocks) {
            entries.add(cfg.getBB(tcb.handler));
        }
        for (BasicBlock bb : cfg.getNodes()) {
            HashSet<BasicBlock> dominators = new HashSet<BasicBlock>();
            if (entries.contains(bb)) {
                dominators.add(bb);
            } else {
                dominators.addAll(cfg.getNodes());
            }
            this.dominatormapping.put(bb, dominators);
        }
        do {
            changed = false;
            for (BasicBlock bb : cfg.getNodes()) {
                if (entries.contains(bb)) continue;
                Set<BasicBlock> dominators = this.dominatormapping.get(bb);
                dominators.remove(bb);
                for (BasicBlock predecessor : bb.getPredecessors()) {
                    if (!dominators.retainAll((Collection)this.dominatormapping.get(predecessor))) continue;
                    changed = true;
                }
                dominators.add(bb);
            }
        } while (changed);
        return cfg;
    }

    public boolean isFirstOfLoop() {
        BasicBlock entry = this.customData.getBB(this.staticContextData.getRegionStart());
        for (BasicBlock bb : entry.getPredecessors()) {
            if (!this.dominatormapping.get(bb).contains(entry)) continue;
            return true;
        }
        return false;
    }
}

