/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.staticcontext;

import ch.usi.dag.disl.snippet.Shadow;
import ch.usi.dag.disl.staticcontext.AbstractStaticContext;
import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.cfg.CtrlFlowGraph;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;

public class BasicBlockStaticContext
extends AbstractStaticContext {
    private Map<String, CtrlFlowGraph> cache = new HashMap<String, CtrlFlowGraph>();
    protected CtrlFlowGraph customData;

    public void staticContextData(Shadow sa) {
        super.staticContextData(sa);
        String key = this.staticContextData.getClassNode().name + this.staticContextData.getMethodNode().name + this.staticContextData.getMethodNode().desc;
        this.customData = this.cache.get(key);
        if (this.customData == null) {
            this.customData = this.produceCustomData();
            this.cache.put(key, this.customData);
        }
    }

    public int getTotBBs() {
        return this.customData.getNodes().size();
    }

    public int getBBSize() {
        int count = 1;
        AbstractInsnNode start = this.staticContextData.getRegionStart();
        List<AbstractInsnNode> ends = this.staticContextData.getRegionEnds();
        while (!ends.contains(start)) {
            if (!AsmHelper.isVirtualInstr(start)) {
                ++count;
            }
            start = start.getNext();
        }
        return count;
    }

    public int getBBindex() {
        return this.customData.getIndex(this.staticContextData.getRegionStart());
    }

    protected CtrlFlowGraph produceCustomData() {
        return new CtrlFlowGraph(this.staticContextData.getMethodNode());
    }
}

