/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.snippet;

import ch.usi.dag.disl.coderep.Code;
import ch.usi.dag.disl.coderep.UnprocessedCode;
import ch.usi.dag.disl.dynamicbypass.DynamicBypass;
import ch.usi.dag.disl.exception.ProcessorException;
import ch.usi.dag.disl.exception.ReflectionException;
import ch.usi.dag.disl.exception.StaticContextGenException;
import ch.usi.dag.disl.localvar.LocalVars;
import ch.usi.dag.disl.marker.BytecodeMarker;
import ch.usi.dag.disl.marker.Marker;
import ch.usi.dag.disl.processor.Proc;
import ch.usi.dag.disl.processorcontext.ArgumentProcessorContext;
import ch.usi.dag.disl.processorcontext.ArgumentProcessorMode;
import ch.usi.dag.disl.snippet.ProcInvocation;
import ch.usi.dag.disl.snippet.SnippetCode;
import ch.usi.dag.disl.util.AsmHelper;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetUnprocessedCode
extends UnprocessedCode {
    private String className;
    private String methodName;
    private boolean dynamicBypass;
    private boolean usesProcessorContext;

    public SnippetUnprocessedCode(String className, String methodName, InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks, Set<String> declaredStaticContexts, boolean usesDynamicContext, boolean dynamicBypass, boolean usesClassContext, boolean usesProcessorContext) {
        super(instructions, tryCatchBlocks, declaredStaticContexts, usesDynamicContext, usesClassContext);
        this.className = className;
        this.methodName = methodName;
        this.dynamicBypass = dynamicBypass;
        this.usesProcessorContext = usesProcessorContext;
    }

    public SnippetCode process(LocalVars allLVs, Map<Type, Proc> processors, Marker marker, boolean exceptHandler, boolean useDynamicBypass) throws StaticContextGenException, ReflectionException, ProcessorException {
        Code code = super.process(allLVs);
        InsnList instructions = code.getInstructions();
        List<TryCatchBlockNode> tryCatchBlocks = code.getTryCatchBlocks();
        if (useDynamicBypass && this.dynamicBypass) {
            this.insertDynamicBypass(instructions);
        }
        if (exceptHandler) {
            this.insertExceptionHandler(instructions, tryCatchBlocks);
        }
        HashMap<Integer, ProcInvocation> invokedProcessors = new HashMap<Integer, ProcInvocation>();
        int insnIndex = 0;
        for (AbstractInsnNode insn : AsmHelper.allInsnsFrom(instructions)) {
            ProcessorInfo processor = this.insnInvokesProcessor(insn, insnIndex, processors, marker);
            if (processor != null) {
                invokedProcessors.put(processor.getInstrPos(), processor.getProcInvoke());
            }
            ++insnIndex;
        }
        return new SnippetCode(instructions, tryCatchBlocks, code.getReferencedSLVs(), code.getReferencedTLVs(), code.containsHandledException(), code.getStaticContexts(), code.usesDynamicContext(), code.usesClassContext(), this.usesProcessorContext, invokedProcessors);
    }

    private ProcessorInfo insnInvokesProcessor(AbstractInsnNode instr, int i, Map<Type, Proc> processors, Marker marker) throws ProcessorException, ReflectionException {
        String APPLY_METHOD = "apply";
        if (!(instr instanceof MethodInsnNode)) {
            return null;
        }
        MethodInsnNode min = (MethodInsnNode)instr;
        if (!min.owner.equals(Type.getInternalName(ArgumentProcessorContext.class)) || !min.name.equals("apply")) {
            return null;
        }
        AbstractInsnNode secondParam = instr.getPrevious();
        AbstractInsnNode firstParam = secondParam.getPrevious();
        if (firstParam == null || firstParam.getOpcode() != 18) {
            throw new ProcessorException("In snippet " + this.className + "." + this.methodName + " - pass the first (class)" + " argument of a ProcMethod.apply method direcltly." + " ex: ProcMethod.apply(ProcMethod.class," + " ArgumentProcessorMode.METHOD_ARGS)");
        }
        if (secondParam == null || secondParam.getOpcode() != 178) {
            throw new ProcessorException("In snippet " + this.className + "." + this.methodName + " - pass the second (type)" + " argument of a ProcMethod.apply method direcltly." + " ex: ProcMethod.apply(ProcMethod.class," + " ArgumentProcessorMode.METHOD_ARGS)");
        }
        Object asmType = ((LdcInsnNode)firstParam).cst;
        if (!(asmType instanceof Type)) {
            throw new ProcessorException("In snippet " + this.className + "." + this.methodName + " - unsupported processor type " + asmType.getClass().toString());
        }
        Type processorType = (Type)asmType;
        ArgumentProcessorMode procApplyType = ArgumentProcessorMode.valueOf(((FieldInsnNode)secondParam).name);
        if (ArgumentProcessorMode.CALLSITE_ARGS.equals((Object)procApplyType) && marker.getClass() != BytecodeMarker.class) {
            throw new ProcessorException("ArgumentProcessor applied in mode CALLSITE_ARGS in method " + this.className + "." + this.methodName + " can be used only with BytecodeMarker");
        }
        Proc processor = processors.get(processorType);
        if (processor == null) {
            throw new ProcessorException("In snippet " + this.className + "." + this.methodName + " - unknow processor used: " + processorType.getClassName());
        }
        ProcInvocation prcInv = new ProcInvocation(processor, procApplyType);
        return new ProcessorInfo(i, prcInv);
    }

    private void insertExceptionHandler(InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks) {
        Type typeSystem = Type.getType(System.class);
        Type typePS = Type.getType(PrintStream.class);
        Type typeString = Type.getType(String.class);
        Type typeThrowable = Type.getType(Throwable.class);
        LabelNode tryBegin = new LabelNode();
        instructions.insert(tryBegin);
        LabelNode handlerEnd = new LabelNode();
        instructions.add(new JumpInsnNode(167, handlerEnd));
        LabelNode tryEnd = new LabelNode();
        instructions.add(tryEnd);
        LabelNode handlerBegin = new LabelNode();
        instructions.add(handlerBegin);
        instructions.add(new FieldInsnNode(178, typeSystem.getInternalName(), "err", typePS.getDescriptor()));
        instructions.add(new LdcInsnNode("Snippet " + this.className + "." + this.methodName + " introduced exception that was not" + " handled. This would change the application control flow." + " Exiting..."));
        instructions.add(new MethodInsnNode(182, typePS.getInternalName(), "println", "(" + typeString.getDescriptor() + ")V"));
        instructions.add(new InsnNode(89));
        instructions.add(new MethodInsnNode(182, typeThrowable.getInternalName(), "printStackTrace", "()V"));
        int EXIT_CODE = 666;
        instructions.add(AsmHelper.loadConst(666));
        instructions.add(new MethodInsnNode(184, typeSystem.getInternalName(), "exit", "(I)V"));
        instructions.add(new InsnNode(191));
        instructions.add(handlerEnd);
        tryCatchBlocks.add(new TryCatchBlockNode(tryBegin, tryEnd, handlerBegin, null));
    }

    private void insertDynamicBypass(InsnList instructions) {
        Type typeDB = Type.getType(DynamicBypass.class);
        instructions.insert(new MethodInsnNode(184, typeDB.getInternalName(), "activate", "()V"));
        instructions.add(new MethodInsnNode(184, typeDB.getInternalName(), "deactivate", "()V"));
    }

    private static class ProcessorInfo {
        private Integer instrPos;
        private ProcInvocation procInvoke;

        public ProcessorInfo(Integer instrPos, ProcInvocation procInvoke) {
            this.instrPos = instrPos;
            this.procInvoke = procInvoke;
        }

        public Integer getInstrPos() {
            return this.instrPos;
        }

        public ProcInvocation getProcInvoke() {
            return this.procInvoke;
        }
    }
}

