/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.processor.generator;

import ch.usi.dag.disl.exception.DiSLFatalException;
import ch.usi.dag.disl.exception.ProcessorException;
import ch.usi.dag.disl.guard.GuardHelper;
import ch.usi.dag.disl.processor.Proc;
import ch.usi.dag.disl.processor.ProcArgType;
import ch.usi.dag.disl.processor.ProcMethod;
import ch.usi.dag.disl.processor.generator.PIResolver;
import ch.usi.dag.disl.processor.generator.ProcInstance;
import ch.usi.dag.disl.processor.generator.ProcMethodInstance;
import ch.usi.dag.disl.processorcontext.ArgumentProcessorMode;
import ch.usi.dag.disl.snippet.ProcInvocation;
import ch.usi.dag.disl.snippet.Shadow;
import ch.usi.dag.disl.snippet.Snippet;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcGenerator {
    Map<Proc, ProcInstance> insideMethodPIs = new HashMap<Proc, ProcInstance>();

    public PIResolver compute(Map<Snippet, List<Shadow>> snippetMarkings) throws ProcessorException {
        PIResolver piResolver = new PIResolver();
        for (Snippet snippet : snippetMarkings.keySet()) {
            Map<Integer, ProcInvocation> invokedProcs = snippet.getCode().getInvokedProcessors();
            for (Shadow shadow : snippetMarkings.get(snippet)) {
                for (Integer instrPos : invokedProcs.keySet()) {
                    ProcInvocation prcInv = invokedProcs.get(instrPos);
                    ProcInstance prcInst = null;
                    switch (prcInv.getProcApplyType()) {
                        case METHOD_ARGS: {
                            prcInst = this.computeInsideMethod(shadow, prcInv);
                            break;
                        }
                        case CALLSITE_ARGS: {
                            prcInst = this.computeBeforeInvocation(shadow, prcInv);
                            break;
                        }
                        default: {
                            throw new DiSLFatalException("Proc computation not defined");
                        }
                    }
                    if (prcInst == null) continue;
                    piResolver.set(shadow, instrPos, prcInst);
                }
            }
        }
        return piResolver;
    }

    private ProcInstance computeInsideMethod(Shadow shadow, ProcInvocation prcInv) {
        ProcInstance procInst = this.insideMethodPIs.get(prcInv.getProcessor());
        if (procInst == null) {
            procInst = this.createProcInstance(ArgumentProcessorMode.METHOD_ARGS, shadow.getMethodNode().desc, shadow, prcInv);
        }
        return procInst;
    }

    private ProcInstance computeBeforeInvocation(Shadow shadow, ProcInvocation prcInv) throws ProcessorException {
        if (shadow.getRegionEnds().size() > 1) {
            throw new DiSLFatalException("Expected only one end in marked region");
        }
        AbstractInsnNode instr = shadow.getRegionEnds().get(0);
        String fullMethodName = shadow.getClassNode().name + "." + shadow.getMethodNode().name;
        if (!(instr instanceof MethodInsnNode)) {
            throw new ProcessorException("ArgumentProcessor " + prcInv.getProcessor().getName() + " is not applied before method invocation in method " + fullMethodName);
        }
        MethodInsnNode methodInvocation = (MethodInsnNode)instr;
        return this.createProcInstance(ArgumentProcessorMode.CALLSITE_ARGS, methodInvocation.desc, shadow, prcInv);
    }

    private ProcInstance createProcInstance(ArgumentProcessorMode procApplyType, String methodDesc, Shadow shadow, ProcInvocation prcInv) {
        LinkedList<ProcMethodInstance> procMethodInstances = new LinkedList<ProcMethodInstance>();
        Type[] argTypeArray = Type.getArgumentTypes(methodDesc);
        for (int i = 0; i < argTypeArray.length; ++i) {
            List<ProcMethodInstance> pmis = this.createMethodInstances(i, argTypeArray.length, argTypeArray[i], prcInv.getProcessor(), shadow, prcInv);
            procMethodInstances.addAll(pmis);
        }
        if (procMethodInstances.isEmpty()) {
            return null;
        }
        return new ProcInstance(procApplyType, procMethodInstances);
    }

    private List<ProcMethodInstance> createMethodInstances(int argPos, int argsCount, Type argType, Proc processor, Shadow shadow, ProcInvocation prcInv) {
        ProcArgType methodArgType = ProcArgType.valueOf(argType);
        LinkedList<ProcMethodInstance> result = new LinkedList<ProcMethodInstance>();
        for (ProcMethod method : processor.getMethods()) {
            if (!method.getTypes().contains((Object)methodArgType)) continue;
            ProcMethodInstance pmi = new ProcMethodInstance(argPos, argsCount, methodArgType, argType.getDescriptor(), method.getCode());
            if (!this.isPMGuardApplicable(method.getGuard(), shadow, pmi)) continue;
            result.add(pmi);
        }
        return result;
    }

    private boolean isPMGuardApplicable(Method guard, Shadow shadow, ProcMethodInstance pmi) {
        return GuardHelper.guardApplicable(guard, shadow, pmi.getArgPos(), pmi.getArgTypeDesc(), pmi.getArgsCount());
    }
}

