/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.processor.generator;

import ch.usi.dag.disl.processor.generator.ProcInstance;
import ch.usi.dag.disl.snippet.Shadow;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PIResolver {
    private Map<ResolverKey, ProcInstance> piStore = new HashMap<ResolverKey, ProcInstance>();

    public ProcInstance get(Shadow shadow, int instrPos) {
        ResolverKey key = new ResolverKey(shadow, instrPos);
        return this.piStore.get(key);
    }

    public void set(Shadow shadow, int instrPos, ProcInstance processorInstance) {
        ResolverKey key = new ResolverKey(shadow, instrPos);
        this.piStore.put(key, processorInstance);
    }

    public Collection<ProcInstance> getAllProcInstances() {
        return this.piStore.values();
    }

    private static class ResolverKey {
        private Shadow shadow;
        private int instrPos;

        public ResolverKey(Shadow shadow, int instrPos) {
            this.shadow = shadow;
            this.instrPos = instrPos;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.instrPos;
            result = 31 * result + (this.shadow == null ? 0 : this.shadow.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResolverKey other = (ResolverKey)obj;
            if (this.instrPos != other.instrPos) {
                return false;
            }
            return !(this.shadow == null ? other.shadow != null : !this.shadow.equals(other.shadow));
        }
    }
}

