/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.marker;

import ch.usi.dag.disl.exception.MarkerException;
import ch.usi.dag.disl.marker.Marker;
import ch.usi.dag.disl.snippet.Shadow;
import ch.usi.dag.disl.snippet.Snippet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMarker
implements Marker {
    @Override
    public List<Shadow> mark(ClassNode classNode, MethodNode methodNode, Snippet snippet) throws MarkerException {
        List<MarkedRegion> regions = this.mark(methodNode);
        LinkedList<Shadow> result = new LinkedList<Shadow>();
        for (MarkedRegion mr : regions) {
            if (!mr.valid()) {
                throw new MarkerException("Marker " + this.getClass() + " produced invalid MarkedRegion (some MarkedRegion" + " fields where not set)");
            }
            result.add(new Shadow(classNode, methodNode, snippet, mr.getStart(), mr.getEnds(), mr.getWeavingRegion()));
        }
        return result;
    }

    public abstract List<MarkedRegion> mark(MethodNode var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarkedRegion {
        private AbstractInsnNode start;
        private List<AbstractInsnNode> ends;
        private Shadow.WeavingRegion weavingRegion;

        public AbstractInsnNode getStart() {
            return this.start;
        }

        public void setStart(AbstractInsnNode start) {
            this.start = start;
        }

        public List<AbstractInsnNode> getEnds() {
            return this.ends;
        }

        public void addEnd(AbstractInsnNode exitpoint) {
            this.ends.add(exitpoint);
        }

        public Shadow.WeavingRegion getWeavingRegion() {
            return this.weavingRegion;
        }

        public void setWeavingRegion(Shadow.WeavingRegion weavingRegion) {
            this.weavingRegion = weavingRegion;
        }

        public MarkedRegion(AbstractInsnNode start) {
            this.start = start;
            this.ends = new LinkedList<AbstractInsnNode>();
        }

        public MarkedRegion(AbstractInsnNode start, AbstractInsnNode end) {
            this.start = start;
            this.ends = new LinkedList<AbstractInsnNode>();
            this.ends.add(end);
        }

        public MarkedRegion(AbstractInsnNode start, List<AbstractInsnNode> ends) {
            this.start = start;
            this.ends = ends;
        }

        public MarkedRegion(AbstractInsnNode start, List<AbstractInsnNode> ends, Shadow.WeavingRegion weavingRegion) {
            this.start = start;
            this.ends = ends;
            this.weavingRegion = weavingRegion;
        }

        public boolean valid() {
            return this.start != null && this.ends != null && this.weavingRegion != null;
        }

        public Shadow.WeavingRegion computeDefaultWeavingRegion(MethodNode methodNode) {
            AbstractInsnNode wstart = this.start;
            AbstractInsnNode afterThrowStart = this.start;
            AbstractInsnNode afterThrowEnd = null;
            HashSet<AbstractInsnNode> endsSet = new HashSet<AbstractInsnNode>(this.ends);
            for (AbstractInsnNode instr = methodNode.instructions.getLast(); instr != null; instr = instr.getPrevious()) {
                if (!endsSet.contains(instr)) continue;
                afterThrowEnd = instr;
                break;
            }
            if (afterThrowEnd instanceof LabelNode) {
                HashSet<LabelNode> tcb_ends = new HashSet<LabelNode>();
                for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
                    tcb_ends.add(tcb.end);
                }
                while (tcb_ends.contains(afterThrowEnd)) {
                    afterThrowEnd = afterThrowEnd.getPrevious();
                }
            }
            return new Shadow.WeavingRegion(wstart, null, afterThrowStart, afterThrowEnd);
        }
    }
}

