/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.guard;

import ch.usi.dag.disl.exception.DiSLFatalException;
import ch.usi.dag.disl.exception.GuardException;
import ch.usi.dag.disl.exception.GuardRuntimeException;
import ch.usi.dag.disl.exception.ReflectionException;
import ch.usi.dag.disl.guard.ArgumentContextImpl;
import ch.usi.dag.disl.guard.GuardContextImpl;
import ch.usi.dag.disl.guardcontext.GuardContext;
import ch.usi.dag.disl.processorcontext.ArgumentContext;
import ch.usi.dag.disl.resolver.GuardMethod;
import ch.usi.dag.disl.resolver.GuardResolver;
import ch.usi.dag.disl.resolver.SCResolver;
import ch.usi.dag.disl.snippet.Shadow;
import ch.usi.dag.disl.staticcontext.StaticContext;
import ch.usi.dag.disl.util.ReflectionHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GuardHelper {
    public static Method findAndValidateGuardMethod(Class<?> guardClass, Set<Class<?>> validArgs) throws GuardException {
        if (guardClass == null) {
            return null;
        }
        GuardMethod guardMethod = GuardResolver.getInstance().getGuardMethod(guardClass);
        GuardHelper.validateGuardMethod(guardMethod, validArgs);
        return guardMethod.getMethod();
    }

    private static void validateGuardMethod(GuardMethod guardMethod, Set<Class<?>> validArgs) throws GuardException {
        if (guardMethod.getArgTypes() != null) {
            if (validArgs.containsAll(guardMethod.getArgTypes())) {
                return;
            }
            HashSet invalidArgTypes = new HashSet(guardMethod.getArgTypes());
            invalidArgTypes.removeAll(validArgs);
            throw new GuardException(String.format("Guard %s is using interface %s not allowed in this particular case (misused guard?)", guardMethod.getMethod().getDeclaringClass().getName(), ((Class)invalidArgTypes.iterator().next()).getName()));
        }
        Method method = guardMethod.getMethod();
        String methodName = GuardHelper.__fullMethodName(method);
        if (!method.getReturnType().equals(Boolean.TYPE)) {
            throw new GuardException("Guard method " + methodName + " MUST return boolean type");
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new GuardException("Guard method " + methodName + " MUST be static");
        }
        HashSet argTypes = new HashSet();
        for (Class<?> argType : method.getParameterTypes()) {
            argTypes.add(GuardHelper.validateArgument(methodName, argType, validArgs));
        }
        guardMethod.setArgTypes(argTypes);
    }

    private static Class<?> validateArgument(String guardMethodName, Class<?> argClass, Set<Class<?>> validArgClasses) throws GuardException {
        for (Class<?> allowedInterface : validArgClasses) {
            if (argClass.equals(allowedInterface)) {
                return allowedInterface;
            }
            if (!allowedInterface.equals(StaticContext.class) || !ReflectionHelper.implementsInterface(argClass, allowedInterface)) continue;
            return allowedInterface;
        }
        Formatter message = new Formatter().format("Guard argument %s in %s is not in the set of allowed interface (misused guard?): ", argClass.getName(), guardMethodName);
        String comma = "";
        for (Class<?> allowedInterface : validArgClasses) {
            message.format("%s%s", comma, allowedInterface.getName());
            comma = ", ";
        }
        throw new GuardException(message.toString());
    }

    public static Set<Class<?>> snippetContextSet() {
        HashSet allowedSet = new HashSet();
        allowedSet.add(GuardContext.class);
        allowedSet.add(StaticContext.class);
        return allowedSet;
    }

    public static Set<Class<?>> processorContextSet() {
        HashSet allowedSet = new HashSet();
        allowedSet.add(GuardContext.class);
        allowedSet.add(StaticContext.class);
        allowedSet.add(ArgumentContext.class);
        return allowedSet;
    }

    public static boolean guardApplicable(Method guardMethod, Shadow shadow) {
        if (guardMethod == null) {
            return true;
        }
        return GuardHelper.invokeGuardMethod(guardMethod, shadow, null);
    }

    public static boolean guardApplicable(Method guardMethod, Shadow shadow, int position, String typeDescriptor, int totalCount) {
        if (guardMethod == null) {
            return true;
        }
        return GuardHelper.invokeGuardMethod(guardMethod, shadow, new ArgumentContextImpl(position, typeDescriptor, totalCount));
    }

    static boolean invokeGuard(Class<?> guardClass, Shadow shadow, ArgumentContext ac) throws GuardException {
        GuardMethod guardMethod = GuardResolver.getInstance().getGuardMethod(guardClass);
        Set<Class<?>> validationSet = ac == null ? GuardHelper.snippetContextSet() : GuardHelper.processorContextSet();
        GuardHelper.validateGuardMethod(guardMethod, validationSet);
        return GuardHelper.invokeGuardMethod(guardMethod.getMethod(), shadow, ac);
    }

    private static boolean invokeGuardMethod(Method guardMethod, Shadow shadow, ArgumentContext ac) {
        Class<?>[] paramTypes = guardMethod.getParameterTypes();
        Object[] arguments = new Object[paramTypes.length];
        for (int argIndex = 0; argIndex < arguments.length; ++argIndex) {
            Class<?> parameterType = paramTypes[argIndex];
            if (ArgumentContext.class.equals(parameterType)) {
                if (ac == null) {
                    throw new DiSLFatalException("Missing argument context");
                }
                arguments[argIndex] = ac;
                continue;
            }
            if (GuardContext.class.equals(parameterType)) {
                arguments[argIndex] = new GuardContextImpl(shadow, ac);
                continue;
            }
            try {
                arguments[argIndex] = SCResolver.getInstance().getStaticContextInstance(parameterType, shadow);
                continue;
            }
            catch (ReflectionException re) {
                String message = String.format("Static context initialization for guard %s failed", GuardHelper.__fullMethodName(guardMethod));
                throw new GuardRuntimeException(message, re);
            }
        }
        try {
            return (Boolean)guardMethod.invoke(null, arguments);
        }
        catch (Exception e) {
            String message = String.format("Invocation of guard method %s failed", GuardHelper.__fullMethodName(guardMethod));
            throw new GuardRuntimeException(message, e);
        }
    }

    private static String __fullMethodName(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName();
    }
}

