/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.exclusion;

import ch.usi.dag.disl.cbloader.ManifestHelper;
import ch.usi.dag.disl.exception.ExclusionPrepareException;
import ch.usi.dag.disl.exception.ManifestInfoException;
import ch.usi.dag.disl.exception.ScopeParserException;
import ch.usi.dag.disl.scope.Scope;
import ch.usi.dag.disl.scope.ScopeImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExclusionSet {
    private static final String PROP_EXCLIST = "disl.exclusionList";
    private static final String excListPath = System.getProperty("disl.exclusionList", null);
    private static final String JAR_PATH_BEGIN = "/";
    private static final String JAR_PATH_END = "!";
    private static final char JAR_ENTRY_DELIM = '/';
    private static final char CLASS_DELIM = '.';
    private static final String ALL_METHODS = ".*";

    public static Set<Scope> prepare() throws ScopeParserException, ManifestInfoException, ExclusionPrepareException {
        Set<Scope> exclSet = ExclusionSet.defaultExcludes();
        exclSet.addAll(ExclusionSet.instrumentationJar());
        exclSet.addAll(ExclusionSet.readExlusionList());
        return exclSet;
    }

    private static Set<Scope> defaultExcludes() throws ScopeParserException {
        String EXCLUDE_CLASSES = ".*.*";
        HashSet<Scope> exclSet = new HashSet<Scope>();
        exclSet.add(new ScopeImpl("ch.usi.dag.dislagent.*.*"));
        exclSet.add(new ScopeImpl("ch.usi.dag.disl.dynamicbypass.*.*"));
        exclSet.add(new ScopeImpl("ch.usi.dag.dislre.*.*"));
        exclSet.add(new ScopeImpl("sun.instrument.*.*"));
        exclSet.add(new ScopeImpl("java.lang.Object.finalize"));
        return exclSet;
    }

    private static Set<Scope> instrumentationJar() throws ManifestInfoException, ExclusionPrepareException, ScopeParserException {
        try {
            HashSet<Scope> exclSet = new HashSet<Scope>();
            ManifestHelper.ManifestInfo mi = ManifestHelper.getDiSLManifestInfo();
            if (mi == null) {
                return exclSet;
            }
            URL manifestURL = ManifestHelper.getDiSLManifestInfo().getResource();
            String manifestPath = manifestURL.getPath();
            int jarPathBegin = manifestPath.indexOf(JAR_PATH_BEGIN);
            int jarPathEnd = manifestPath.indexOf(JAR_PATH_END);
            String jarPath = manifestPath.substring(jarPathBegin, jarPathEnd);
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                String className = entryName.replace('/', '.');
                int classNameEnd = className.lastIndexOf(".class");
                className = className.substring(0, classNameEnd);
                String classExcl = className + ALL_METHODS;
                exclSet.add(new ScopeImpl(classExcl));
            }
            jarFile.close();
            return exclSet;
        }
        catch (IOException e) {
            throw new ExclusionPrepareException(e);
        }
    }

    private static Set<Scope> readExlusionList() throws ExclusionPrepareException, ScopeParserException {
        String COMMENT_START = "#";
        try {
            HashSet<Scope> exclSet = new HashSet<Scope>();
            if (excListPath != null) {
                Scanner scanner = new Scanner(new FileInputStream(excListPath));
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.startsWith("#")) continue;
                    exclSet.add(new ScopeImpl(line));
                }
                scanner.close();
            }
            return exclSet;
        }
        catch (FileNotFoundException e) {
            throw new ExclusionPrepareException(e);
        }
    }
}

