/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.coderep;

import ch.usi.dag.disl.coderep.Code;
import ch.usi.dag.disl.coderep.StaticContextMethod;
import ch.usi.dag.disl.exception.ReflectionException;
import ch.usi.dag.disl.exception.StaticContextGenException;
import ch.usi.dag.disl.localvar.LocalVars;
import ch.usi.dag.disl.localvar.SyntheticLocalVar;
import ch.usi.dag.disl.localvar.ThreadLocalVar;
import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.ReflectionHelper;
import ch.usi.dag.disl.util.cfg.CtrlFlowGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnprocessedCode {
    private InsnList instructions;
    private List<TryCatchBlockNode> tryCatchBlocks;
    private Set<String> declaredStaticContexts;
    private boolean usesDynamicContext;
    private boolean usesClassContext;
    private static final Type threadType = Type.getType(Thread.class);
    private static final String currentThreadName = "currentThread";
    private static final Type currentThreadType = Type.getMethodType(threadType, new Type[0]);

    public UnprocessedCode(InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks, Set<String> declaredStaticContexts, boolean usesDynamicContext, boolean usesClassContext) {
        this.instructions = instructions;
        this.tryCatchBlocks = tryCatchBlocks;
        this.declaredStaticContexts = declaredStaticContexts;
        this.usesDynamicContext = usesDynamicContext;
        this.usesClassContext = usesClassContext;
    }

    public Code process(LocalVars allLVs) throws StaticContextGenException, ReflectionException {
        HashSet<SyntheticLocalVar> slvList = new HashSet<SyntheticLocalVar>();
        HashSet<ThreadLocalVar> tlvList = new HashSet<ThreadLocalVar>();
        for (AbstractInsnNode insn : AsmHelper.allInsnsFrom(this.instructions)) {
            SyntheticLocalVar slv = this.insnUsesField(insn, allLVs.getSyntheticLocals());
            if (slv != null) {
                slvList.add(slv);
                continue;
            }
            ThreadLocalVar tlv = this.insnUsesField(insn, allLVs.getThreadLocals());
            if (tlv == null) continue;
            tlvList.add(tlv);
        }
        boolean containsHandledException = this.containsHandledException(this.instructions, this.tryCatchBlocks);
        AsmHelper.replaceRetWithGoto(this.instructions);
        this.translateThreadLocalVars(this.instructions, tlvList);
        HashMap<String, StaticContextMethod> staticContexts = new HashMap<String, StaticContextMethod>();
        for (AbstractInsnNode instr : AsmHelper.allInsnsFrom(this.instructions)) {
            StaticContextMethod scm = this.insnInvokesStaticContext(this.declaredStaticContexts, instr, staticContexts.keySet());
            if (scm == null) continue;
            staticContexts.put(scm.getId(), scm);
        }
        return new Code(this.instructions, this.tryCatchBlocks, slvList, tlvList, new HashSet<StaticContextMethod>(staticContexts.values()), this.usesDynamicContext, this.usesClassContext, containsHandledException);
    }

    private StaticContextMethod insnInvokesStaticContext(Set<String> knownStAnClasses, AbstractInsnNode instr, Set<String> knownMethods) throws StaticContextGenException, ReflectionException {
        if (!(instr instanceof MethodInsnNode)) {
            return null;
        }
        MethodInsnNode methodInstr = (MethodInsnNode)instr;
        if (!knownStAnClasses.contains(methodInstr.owner)) {
            return null;
        }
        Method asmMethod = new Method(methodInstr.name, methodInstr.desc);
        Type[] methodArguments = asmMethod.getArgumentTypes();
        if (methodArguments.length != 0) {
            throw new StaticContextGenException("Static context method " + methodInstr.name + " in the class " + methodInstr.owner + " shouldn't have a parameter.");
        }
        Type methodReturn = asmMethod.getReturnType();
        if (!(methodReturn.equals(Type.BOOLEAN_TYPE) || methodReturn.equals(Type.BYTE_TYPE) || methodReturn.equals(Type.CHAR_TYPE) || methodReturn.equals(Type.DOUBLE_TYPE) || methodReturn.equals(Type.FLOAT_TYPE) || methodReturn.equals(Type.INT_TYPE) || methodReturn.equals(Type.LONG_TYPE) || methodReturn.equals(Type.SHORT_TYPE) || methodReturn.equals(Type.getType(String.class)))) {
            throw new StaticContextGenException("Static context method " + methodInstr.name + " in the class " + methodInstr.owner + " can have only basic type or String as a return type.");
        }
        String methodID = methodInstr.owner + "." + methodInstr.name;
        if (knownMethods.contains(methodID)) {
            return null;
        }
        Class<?> stAnClass = ReflectionHelper.resolveClass(Type.getObjectType(methodInstr.owner));
        java.lang.reflect.Method stAnMethod = ReflectionHelper.resolveMethod(stAnClass, methodInstr.name);
        return new StaticContextMethod(methodID, stAnMethod, stAnClass);
    }

    private <T> T insnUsesField(AbstractInsnNode instr, Map<String, T> allPossibleFieldNames) {
        if (!(instr instanceof FieldInsnNode)) {
            return null;
        }
        FieldInsnNode fieldInstr = (FieldInsnNode)instr;
        String wholeFieldName = SyntheticLocalVar.fqFieldNameFor(fieldInstr.owner, fieldInstr.name);
        return allPossibleFieldNames.get(wholeFieldName);
    }

    private boolean containsHandledException(InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks) {
        if (tryCatchBlocks.size() == 0) {
            return false;
        }
        CtrlFlowGraph cfg = new CtrlFlowGraph(instructions, tryCatchBlocks);
        cfg.visit(instructions.getFirst());
        for (int i = tryCatchBlocks.size() - 1; i >= 0; --i) {
            TryCatchBlockNode tcb = tryCatchBlocks.get(i);
            if (cfg.visit(tcb.handler).size() == 0) continue;
            return true;
        }
        return false;
    }

    private void translateThreadLocalVars(InsnList instructions, Set<ThreadLocalVar> threadLocalVars) {
        HashSet<String> tlvIds = new HashSet<String>();
        for (ThreadLocalVar tlv : threadLocalVars) {
            tlvIds.add(tlv.getID());
        }
        for (AbstractInsnNode instr : instructions.toArray()) {
            int opcode = instr.getOpcode();
            if (!AsmHelper.isStaticFieldAccess(opcode)) continue;
            FieldInsnNode fieldInsn = (FieldInsnNode)instr;
            String fieldId = ThreadLocalVar.fqFieldNameFor(fieldInsn.owner, fieldInsn.name);
            if (!tlvIds.contains(fieldId)) continue;
            instructions.insertBefore((AbstractInsnNode)fieldInsn, AsmHelper.invokeStatic(threadType, currentThreadName, currentThreadType));
            if (opcode == 178) {
                instructions.insertBefore((AbstractInsnNode)fieldInsn, AsmHelper.getField(threadType.getInternalName(), fieldInsn.name, fieldInsn.desc));
            } else {
                if (Type.getType(fieldInsn.desc).getSize() == 1) {
                    instructions.insertBefore((AbstractInsnNode)fieldInsn, new InsnNode(95));
                } else {
                    instructions.insertBefore((AbstractInsnNode)fieldInsn, new InsnNode(91));
                    instructions.insertBefore((AbstractInsnNode)fieldInsn, new InsnNode(87));
                }
                instructions.insertBefore((AbstractInsnNode)fieldInsn, AsmHelper.putField(threadType.getInternalName(), fieldInsn.name, fieldInsn.desc));
            }
            instructions.remove(fieldInsn);
        }
    }
}

