/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.classparser;

import ch.usi.dag.disl.annotation.SyntheticLocal;
import ch.usi.dag.disl.annotation.ThreadLocal;
import ch.usi.dag.disl.classparser.ParserHelper;
import ch.usi.dag.disl.exception.ParserException;
import ch.usi.dag.disl.localvar.LocalVars;
import ch.usi.dag.disl.localvar.SyntheticLocalVar;
import ch.usi.dag.disl.localvar.ThreadLocalVar;
import ch.usi.dag.disl.util.AsmHelper;
import ch.usi.dag.disl.util.FrameHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractParser {
    protected LocalVars allLocalVars = new LocalVars();

    AbstractParser() {
    }

    public LocalVars getAllLocalVars() {
        return this.allLocalVars;
    }

    protected void processLocalVars(ClassNode classNode) throws ParserException {
        LocalVars localVars = this.parseLocalVars(classNode.name, classNode.fields);
        this.allLocalVars.putAll(localVars);
        MethodNode cinit = null;
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("<clinit>")) continue;
            cinit = method;
            break;
        }
        if (cinit != null && cinit.instructions != null) {
            this.parseInitCodeForSLV(cinit.instructions, localVars.getSyntheticLocals());
            this.parseInitCodeForTLV(classNode.name, cinit, localVars.getThreadLocals());
        }
    }

    private LocalVars parseLocalVars(String className, List<FieldNode> fields) throws ParserException {
        LocalVars result = new LocalVars();
        for (FieldNode field : fields) {
            if (field.invisibleAnnotations == null) {
                throw new ParserException("DiSL annotation for field " + className + "." + field.name + " is missing");
            }
            if (field.invisibleAnnotations.size() > 1) {
                throw new ParserException("Field " + className + "." + field.name + " may have only one anotation");
            }
            AnnotationNode annotation = field.invisibleAnnotations.get(0);
            Type annotationType = Type.getType(annotation.desc);
            if (annotationType.equals(Type.getType(ThreadLocal.class))) {
                ThreadLocalVar tlv = this.parseThreadLocal(className, field, annotation);
                result.getThreadLocals().put(tlv.getID(), tlv);
                continue;
            }
            if (annotationType.equals(Type.getType(SyntheticLocal.class))) {
                SyntheticLocalVar slv = this.parseSyntheticLocal(className, field, annotation);
                result.getSyntheticLocals().put(slv.getID(), slv);
                continue;
            }
            throw new ParserException("Field " + className + "." + field.name + " has unsupported DiSL annotation");
        }
        return result;
    }

    private ThreadLocalVar parseThreadLocal(String className, FieldNode field, AnnotationNode annotation) throws ParserException {
        if ((field.access & 8) == 0) {
            throw new ParserException("Field " + className + "." + field.name + " declared as ThreadLocal but is not static");
        }
        TLAnnotationData tlad = new TLAnnotationData();
        ParserHelper.parseAnnotation(tlad, annotation);
        Type fieldType = Type.getType(field.desc);
        return new ThreadLocalVar(className, field.name, fieldType, tlad.inheritable);
    }

    private SyntheticLocalVar parseSyntheticLocal(String className, FieldNode field, AnnotationNode annotation) throws ParserException {
        if ((field.access & 8) == 0) {
            throw new ParserException("Field " + field.name + className + "." + " declared as SyntheticLocal but is not static");
        }
        SLAnnotationData slad = new SLAnnotationData();
        ParserHelper.parseAnnotation(slad, annotation);
        SyntheticLocal.Initialize slvInit = SyntheticLocal.Initialize.ALWAYS;
        if (slad.initialize != null) {
            slvInit = SyntheticLocal.Initialize.valueOf(slad.initialize[1]);
        }
        Type fieldType = Type.getType(field.desc);
        return new SyntheticLocalVar(className, field.name, fieldType, slvInit);
    }

    private void parseInitCodeForSLV(InsnList initInsns, Map<String, SyntheticLocalVar> slvs) {
        AbstractInsnNode firstInitInsn = initInsns.getFirst();
        for (AbstractInsnNode insn : AsmHelper.allInsnsFrom(initInsns)) {
            if (AsmHelper.isReturn(insn.getOpcode())) break;
            if (!(insn instanceof FieldInsnNode)) continue;
            FieldInsnNode lastInitInsn = (FieldInsnNode)insn;
            SyntheticLocalVar slv = slvs.get(SyntheticLocalVar.fqFieldNameFor(lastInitInsn.owner, lastInitInsn.name));
            if (slv == null) continue;
            if (slv.hasInitCode()) {
                System.out.printf("DiSL: warning, replacing initialization code for synthetic local variable %s\n", slv.getID());
            }
            slv.setInitCode(this.simpleInsnListClone(firstInitInsn, lastInitInsn));
            firstInitInsn = insn.getNext();
        }
    }

    private InsnList simpleInsnListClone(AbstractInsnNode first, AbstractInsnNode last) {
        InsnList result = new InsnList();
        AbstractInsnNode end = last.getNext();
        Map<LabelNode, LabelNode> dummy = Collections.emptyMap();
        for (AbstractInsnNode insn = first; insn != end; insn = insn.getNext()) {
            if (AsmHelper.isVirtualInstr(insn)) continue;
            result.add(insn.clone(dummy));
        }
        return result;
    }

    private void parseInitCodeForTLV(String className, MethodNode cinitMethod, Map<String, ThreadLocalVar> tlvs) throws ParserException {
        Frame<SourceValue>[] frames = FrameHelper.getSourceFrames(className, cinitMethod);
        block15: for (int i = 0; i < frames.length; ++i) {
            AbstractInsnNode instr = cinitMethod.instructions.get(i);
            if (instr.getOpcode() != 179) continue;
            FieldInsnNode fieldInsn = (FieldInsnNode)instr;
            ThreadLocalVar tlv = tlvs.get(ThreadLocalVar.fqFieldNameFor(className, fieldInsn.name));
            if (tlv == null) continue;
            Set<AbstractInsnNode> sources = frames[i].getStack((int)(frames[i].getStackSize() - 1)).insns;
            if (sources.size() != 1) {
                throw new ParserException(String.format("Thread local variable %s can be only initialized by a single constant", tlv.getName()));
            }
            AbstractInsnNode source = sources.iterator().next();
            switch (source.getOpcode()) {
                case 2: {
                    tlv.setDefaultValue(-1);
                    continue block15;
                }
                case 3: {
                    if (fieldInsn.desc.equals("Z")) {
                        tlv.setDefaultValue(false);
                        continue block15;
                    }
                    tlv.setDefaultValue(0);
                    continue block15;
                }
                case 9: {
                    tlv.setDefaultValue(0);
                    continue block15;
                }
                case 11: 
                case 14: {
                    tlv.setDefaultValue(0.0);
                    continue block15;
                }
                case 4: {
                    if (fieldInsn.desc.equals("Z")) {
                        tlv.setDefaultValue(true);
                        continue block15;
                    }
                    tlv.setDefaultValue(1);
                    continue block15;
                }
                case 10: {
                    tlv.setDefaultValue(1);
                    continue block15;
                }
                case 12: 
                case 15: {
                    tlv.setDefaultValue(1.0);
                    continue block15;
                }
                case 5: 
                case 13: {
                    tlv.setDefaultValue(2);
                    continue block15;
                }
                case 6: {
                    tlv.setDefaultValue(3);
                    continue block15;
                }
                case 7: {
                    tlv.setDefaultValue(4);
                    continue block15;
                }
                case 8: {
                    tlv.setDefaultValue(5);
                    continue block15;
                }
                case 16: 
                case 17: {
                    tlv.setDefaultValue(((IntInsnNode)source).operand);
                    continue block15;
                }
                case 18: {
                    tlv.setDefaultValue(((LdcInsnNode)source).cst);
                    continue block15;
                }
                default: {
                    throw new ParserException("Initialization is not defined for thread local variable " + tlv.getName());
                }
            }
        }
    }

    private static class SLAnnotationData {
        public String[] initialize = null;

        private SLAnnotationData() {
        }
    }

    private static class TLAnnotationData {
        public boolean inheritable = false;

        private TLAnnotationData() {
        }
    }
}

