/*
 * Decompiled with CFR 0.152.
 */
package ch.usi.dag.disl.cbloader;

import ch.usi.dag.disl.cbloader.ManifestHelper;
import ch.usi.dag.disl.exception.InitException;
import ch.usi.dag.disl.exception.ManifestInfoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassByteLoader {
    public static final String PROP_DISL_CLASSES = "disl.classes";
    public static final String DISL_CLASSES_DELIM = ":";
    public static final String DISL_CLASSES_EXT = ".class";
    public static final char CLASS_DELIM = '.';
    public static final char FILE_DELIM = '/';

    public static List<InputStream> loadDiSLClasses() throws InitException {
        try {
            List<InputStream> result = ClassByteLoader.loadClassesFromProperty();
            if (result == null) {
                result = ClassByteLoader.loadClassesFromManifest();
            }
            return result;
        }
        catch (IOException e) {
            throw new InitException(e);
        }
        catch (ManifestInfoException e) {
            throw new InitException(e);
        }
    }

    private static List<InputStream> loadClassesFromProperty() throws IOException {
        String classesList = System.getProperty(PROP_DISL_CLASSES);
        if (classesList == null || classesList.isEmpty()) {
            return null;
        }
        LinkedList<InputStream> dislClasses = new LinkedList<InputStream>();
        for (String fileName : classesList.split(DISL_CLASSES_DELIM)) {
            File file = new File(fileName);
            dislClasses.add(new FileInputStream(file));
        }
        return dislClasses;
    }

    private static List<InputStream> loadClassesFromManifest() throws IOException, ManifestInfoException {
        ManifestHelper.ManifestInfo mi = ManifestHelper.getDiSLManifestInfo();
        if (mi == null) {
            return null;
        }
        String classesList = mi.getDislClasses();
        if (classesList.isEmpty()) {
            return null;
        }
        LinkedList<InputStream> dislClasses = new LinkedList<InputStream>();
        for (String className : classesList.split(DISL_CLASSES_DELIM)) {
            String fileName = className.replace('.', '/') + DISL_CLASSES_EXT;
            ClassLoader cl = ClassByteLoader.class.getClassLoader();
            dislClasses.add(cl.getResourceAsStream(fileName));
        }
        return dislClasses;
    }
}

