/*
 * Decompiled with CFR 0.152.
 */
package kieker.examples.analysis.opad;

import kieker.analysis.AnalysisController;
import kieker.analysis.IProjectContext;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.reader.filesystem.FSReader;
import kieker.common.configuration.Configuration;
import kieker.examples.analysis.opad.AnomalyPrinter;
import kieker.tools.opad.filter.AnomalyDetectionFilter;
import kieker.tools.opad.filter.AnomalyScoreCalculationFilter;
import kieker.tools.opad.filter.ExtractionFilter;
import kieker.tools.opad.filter.ForecastingFilter;
import kieker.tools.opad.filter.TimeSeriesPointAggregatorFilter;
import kieker.tools.opad.filter.UniteMeasurementPairFilter;

public final class AnalysisStarter {
    private AnalysisStarter() {
    }

    public static void main(String[] stringArray) throws InterruptedException, IllegalStateException, AnalysisConfigurationException {
        AnalysisController analysisController = new AnalysisController();
        Configuration configuration = new Configuration();
        configuration.setProperty("inputDirs", "testdata");
        FSReader fSReader = new FSReader(configuration, (IProjectContext)analysisController);
        ExtractionFilter extractionFilter = new ExtractionFilter(new Configuration(), (IProjectContext)analysisController);
        Configuration configuration2 = new Configuration();
        configuration2.setProperty("aggregationSpan", "1");
        configuration2.setProperty("timeUnit", "NANOSECONDS");
        configuration2.setProperty("aggregationMethod", "MEANJAVA");
        TimeSeriesPointAggregatorFilter timeSeriesPointAggregatorFilter = new TimeSeriesPointAggregatorFilter(configuration2, (IProjectContext)analysisController);
        Configuration configuration3 = new Configuration();
        configuration3.setProperty("fcmethod", "MEANJAVA");
        ForecastingFilter forecastingFilter = new ForecastingFilter(configuration3, (IProjectContext)analysisController);
        UniteMeasurementPairFilter uniteMeasurementPairFilter = new UniteMeasurementPairFilter(new Configuration(), (IProjectContext)analysisController);
        AnomalyScoreCalculationFilter anomalyScoreCalculationFilter = new AnomalyScoreCalculationFilter(new Configuration(), (IProjectContext)analysisController);
        AnomalyDetectionFilter anomalyDetectionFilter = new AnomalyDetectionFilter(new Configuration(), (IProjectContext)analysisController);
        AnomalyPrinter anomalyPrinter = new AnomalyPrinter(new Configuration(), (IProjectContext)analysisController);
        AnomalyPrinter anomalyPrinter2 = new AnomalyPrinter(new Configuration(), (IProjectContext)analysisController);
        analysisController.connect((AbstractPlugin)fSReader, "monitoringRecords", (AbstractPlugin)extractionFilter, "inputRecord");
        analysisController.connect((AbstractPlugin)extractionFilter, "outputData", (AbstractPlugin)timeSeriesPointAggregatorFilter, "tspoint");
        analysisController.connect((AbstractPlugin)timeSeriesPointAggregatorFilter, "aggregatedTSPoint", (AbstractPlugin)forecastingFilter, "tspoint");
        analysisController.connect((AbstractPlugin)timeSeriesPointAggregatorFilter, "aggregatedTSPoint", (AbstractPlugin)uniteMeasurementPairFilter, "tspoint");
        analysisController.connect((AbstractPlugin)forecastingFilter, "forecastedcurrent", (AbstractPlugin)uniteMeasurementPairFilter, "forecast");
        analysisController.connect((AbstractPlugin)uniteMeasurementPairFilter, "forecastedcurrent", (AbstractPlugin)anomalyScoreCalculationFilter, "currentforecast");
        analysisController.connect((AbstractPlugin)anomalyScoreCalculationFilter, "anomalyscore", (AbstractPlugin)anomalyDetectionFilter, "anomalyscore");
        analysisController.connect((AbstractPlugin)anomalyDetectionFilter, "anomalyscore_anomaly", (AbstractPlugin)anomalyPrinter, "receivedEvents");
        analysisController.connect((AbstractPlugin)anomalyDetectionFilter, "anomalyscore_else", (AbstractPlugin)anomalyPrinter2, "receivedEvents");
        analysisController.run();
    }
}

