/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.systemModel.repository;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import kieker.tools.traceAnalysis.systemModel.ExecutionContainer;
import kieker.tools.traceAnalysis.systemModel.RootExecutionContainer;
import kieker.tools.traceAnalysis.systemModel.repository.AbstractSystemSubRepository;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

public class ExecutionEnvironmentRepository
extends AbstractSystemSubRepository {
    public static final ExecutionContainer ROOT_EXECUTION_CONTAINER = new RootExecutionContainer();
    private final Map<String, ExecutionContainer> executionContainersByName = new Hashtable<String, ExecutionContainer>();
    private final Map<Integer, ExecutionContainer> executionContainersById = new Hashtable<Integer, ExecutionContainer>();

    public ExecutionEnvironmentRepository(SystemModelRepository systemFactory) {
        super(systemFactory);
    }

    public final ExecutionContainer lookupExecutionContainerByNamedIdentifier(String namedIdentifier) {
        return this.executionContainersByName.get(namedIdentifier);
    }

    public final ExecutionContainer lookupExecutionContainerByContainerId(int containerId) {
        return this.executionContainersById.get(containerId);
    }

    public final ExecutionContainer createAndRegisterExecutionContainer(String namedIdentifier, String name) {
        if (this.executionContainersByName.containsKey(namedIdentifier)) {
            throw new IllegalArgumentException("Element with name " + namedIdentifier + "exists already");
        }
        int id = this.getAndIncrementNextId();
        ExecutionContainer newInst = new ExecutionContainer(id, null, name);
        this.executionContainersById.put(id, newInst);
        this.executionContainersByName.put(namedIdentifier, newInst);
        return newInst;
    }

    public final Collection<ExecutionContainer> getExecutionContainers() {
        return this.executionContainersById.values();
    }
}

