/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kieker.tools.traceAnalysis.filter.visualization.graph.Color;
import kieker.tools.traceAnalysis.filter.visualization.graph.IOriginRetentionPolicy;

public abstract class AbstractGraphElement<O> {
    private volatile Color color = Color.BLACK;
    private volatile String description;
    private final Set<O> origins = new HashSet<O>();

    protected AbstractGraphElement(O origin, IOriginRetentionPolicy originPolicy) {
        originPolicy.handleOrigin(this, origin);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<O> getOrigins() {
        return Collections.unmodifiableSet(this.origins);
    }

    public final void addOrigin(O origin) {
        if (origin != null) {
            this.origins.add(origin);
        }
    }

    public abstract String getIdentifier();
}

