/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.util.signature.Signature;
import kieker.tools.traceAnalysis.systemModel.AllocationComponent;
import kieker.tools.traceAnalysis.systemModel.AssemblyComponent;
import kieker.tools.traceAnalysis.systemModel.ComponentType;
import kieker.tools.traceAnalysis.systemModel.Execution;
import kieker.tools.traceAnalysis.systemModel.ExecutionContainer;
import kieker.tools.traceAnalysis.systemModel.Operation;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;

@Plugin(repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)})
public abstract class AbstractTraceAnalysisFilter
extends AbstractFilterPlugin {
    public static final String CONFIG_PROPERTY_VALUE_VERBOSE = "false";
    public static final String REPOSITORY_PORT_NAME_SYSTEM_MODEL = "systemModelRepository";
    protected static final Log LOG = LogFactory.getLog(AbstractTraceAnalysisFilter.class);
    private volatile SystemModelRepository systemEntityFactory;

    public AbstractTraceAnalysisFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    public static final Execution createExecutionByEntityNames(SystemModelRepository systemModelRepository, String executionContainerName, String assemblyComponentTypeName, String componentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        Operation op;
        String allocationComponentName = executionContainerName + "::" + assemblyComponentTypeName;
        String operationFactoryName = componentTypeName + "." + operationSignature;
        AllocationComponent allocInst = systemModelRepository.getAllocationFactory().lookupAllocationComponentInstanceByNamedIdentifier(allocationComponentName);
        if (allocInst == null) {
            ExecutionContainer execContainer;
            AssemblyComponent assemblyComponent = systemModelRepository.getAssemblyFactory().lookupAssemblyComponentInstanceByNamedIdentifier(assemblyComponentTypeName);
            if (assemblyComponent == null) {
                ComponentType componentType = systemModelRepository.getTypeRepositoryFactory().lookupComponentTypeByNamedIdentifier(assemblyComponentTypeName);
                if (componentType == null) {
                    componentType = systemModelRepository.getTypeRepositoryFactory().createAndRegisterComponentType(assemblyComponentTypeName, assemblyComponentTypeName);
                }
                assemblyComponent = systemModelRepository.getAssemblyFactory().createAndRegisterAssemblyComponentInstance(assemblyComponentTypeName, componentType);
            }
            if ((execContainer = systemModelRepository.getExecutionEnvironmentFactory().lookupExecutionContainerByNamedIdentifier(executionContainerName)) == null) {
                execContainer = systemModelRepository.getExecutionEnvironmentFactory().createAndRegisterExecutionContainer(executionContainerName, executionContainerName);
            }
            allocInst = systemModelRepository.getAllocationFactory().createAndRegisterAllocationComponentInstance(allocationComponentName, assemblyComponent, execContainer);
        }
        if ((op = systemModelRepository.getOperationFactory().lookupOperationByNamedIdentifier(operationFactoryName)) == null) {
            op = systemModelRepository.getOperationFactory().createAndRegisterOperation(operationFactoryName, allocInst.getAssemblyComponent().getType(), operationSignature);
            allocInst.getAssemblyComponent().getType().addOperation(op);
        }
        return new Execution(op, allocInst, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    public static final Execution createExecutionByEntityNames(SystemModelRepository systemModelRepository, String executionContainerName, String assemblyComponentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        return AbstractTraceAnalysisFilter.createExecutionByEntityNames(systemModelRepository, executionContainerName, assemblyComponentTypeName, assemblyComponentTypeName, operationSignature, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    protected final Execution createExecutionByEntityNames(String executionContainerName, String assemblyComponentTypeName, String componentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        return AbstractTraceAnalysisFilter.createExecutionByEntityNames(this.getSystemEntityFactory(), executionContainerName, assemblyComponentTypeName, componentTypeName, operationSignature, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    protected final Execution createExecutionByEntityNames(String executionContainerName, String assemblyComponentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        return AbstractTraceAnalysisFilter.createExecutionByEntityNames(this.getSystemEntityFactory(), executionContainerName, assemblyComponentTypeName, assemblyComponentTypeName, operationSignature, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    protected void printDebugLogMessage(String[] lines) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("");
            LOG.debug("#");
            LOG.debug("# Plugin: " + this.getName());
            for (String l : lines) {
                LOG.debug(l);
            }
        }
    }

    protected void printErrorLogMessage(String[] lines) {
        LOG.error("");
        LOG.error("#");
        LOG.error("# Plugin: " + this.getName());
        for (String l : lines) {
            LOG.error(l);
        }
    }

    public final SystemModelRepository getSystemEntityFactory() {
        if (this.systemEntityFactory == null) {
            this.systemEntityFactory = (SystemModelRepository)this.getRepository(REPOSITORY_PORT_NAME_SYSTEM_MODEL);
        }
        if (this.systemEntityFactory == null) {
            LOG.error("Failed to connect to system model repository via repository port 'systemModelRepository' (not connected?)");
        }
        return this.systemEntityFactory;
    }
}

