/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.record;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public class StorableDetectionResult
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 36;
    private static final long serialVersionUID = 6603400678579037205L;
    public static final Class<?>[] TYPES = new Class[]{String.class, Double.TYPE, Long.TYPE, Double.TYPE, Double.TYPE};
    private final String applicationName;
    private final double value;
    private final long timestamp;
    private final double forecast;
    private final double score;

    public StorableDetectionResult(String applicationName, double value, long timestamp, double forecast, double score) {
        this.applicationName = applicationName == null ? "" : applicationName;
        this.value = value;
        this.timestamp = timestamp;
        this.forecast = forecast;
        this.score = score;
    }

    public StorableDetectionResult(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.applicationName = (String)values[0];
        this.value = (Double)values[1];
        this.timestamp = (Long)values[2];
        this.forecast = (Double)values[3];
        this.score = (Double)values[4];
    }

    protected StorableDetectionResult(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.applicationName = (String)values[0];
        this.value = (Double)values[1];
        this.timestamp = (Long)values[2];
        this.forecast = (Double)values[3];
        this.score = (Double)values[4];
    }

    public StorableDetectionResult(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.applicationName = stringRegistry.get(buffer.getInt());
        this.value = buffer.getDouble();
        this.timestamp = buffer.getLong();
        this.forecast = buffer.getDouble();
        this.score = buffer.getDouble();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getApplicationName(), this.getValue(), this.getTimestamp(), this.getForecast(), this.getScore()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putInt(stringRegistry.get(this.getApplicationName()));
        buffer.putDouble(this.getValue());
        buffer.putLong(this.getTimestamp());
        buffer.putDouble(this.getForecast());
        buffer.putDouble(this.getScore());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    public final double getValue() {
        return this.value;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final double getForecast() {
        return this.forecast;
    }

    public final double getScore() {
        return this.score;
    }
}

