/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.filter;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.AbstractUpdateableFilterPlugin;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.common.configuration.Configuration;
import kieker.tools.opad.model.ForecastMeasurementPair;
import kieker.tools.opad.model.IForecastMeasurementPair;
import kieker.tools.opad.model.NamedDoubleTimeSeriesPoint;
import kieker.tools.tslib.ForecastMethod;
import kieker.tools.tslib.ITimeSeries;
import kieker.tools.tslib.TimeSeries;
import kieker.tools.tslib.forecast.IForecastResult;
import kieker.tools.tslib.forecast.IForecaster;

@Plugin(name="Forecast Filter", outputPorts={@OutputPort(eventTypes={IForecastResult.class}, name="forecast"), @OutputPort(eventTypes={IForecastMeasurementPair.class}, name="forecastedcurrent")}, configuration={@Property(name="deltatime", defaultValue="1000"), @Property(name="deltaunit", defaultValue="MILLISECONDS"), @Property(name="fcmethod", defaultValue="MEAN", updateable=true), @Property(name="tswcapacity", defaultValue="60")})
public class ForecastingFilter
extends AbstractUpdateableFilterPlugin {
    public static final String INPUT_PORT_NAME_TSPOINT = "tspoint";
    public static final String OUTPUT_PORT_NAME_FORECAST = "forecast";
    public static final String OUTPUT_PORT_NAME_FORECASTED_AND_CURRENT = "forecastedcurrent";
    public static final String CONFIG_PROPERTY_NAME_DELTA_TIME = "deltatime";
    public static final String CONFIG_PROPERTY_NAME_DELTA_UNIT = "deltaunit";
    public static final String CONFIG_PROPERTY_NAME_FC_METHOD = "fcmethod";
    public static final String CONFIG_PROPERTY_NAME_TS_WINDOW_CAPACITY = "tswcapacity";
    private final ConcurrentHashMap<String, ITimeSeries<Double>> applicationForecastingWindow;
    private AtomicInteger timeSeriesWindowCapacity;
    private final AtomicReference<ForecastMethod> forecastMethod = new AtomicReference();
    private AtomicLong deltat;
    private TimeUnit tunit;

    public ForecastingFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.applicationForecastingWindow = new ConcurrentHashMap();
        this.setCurrentConfiguration(configuration, false);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_DELTA_TIME, Long.toString(this.deltat.get()));
        configuration.setProperty(CONFIG_PROPERTY_NAME_DELTA_UNIT, this.tunit.name());
        configuration.setProperty(CONFIG_PROPERTY_NAME_FC_METHOD, this.forecastMethod.get().name());
        configuration.setProperty(CONFIG_PROPERTY_NAME_TS_WINDOW_CAPACITY, Integer.toString(this.timeSeriesWindowCapacity.get()));
        return configuration;
    }

    @Override
    public void setCurrentConfiguration(Configuration config, boolean update) {
        if (!update || this.isPropertyUpdateable(CONFIG_PROPERTY_NAME_DELTA_TIME)) {
            this.deltat = new AtomicLong(config.getLongProperty(CONFIG_PROPERTY_NAME_DELTA_TIME));
        }
        if (!update || this.isPropertyUpdateable(CONFIG_PROPERTY_NAME_DELTA_UNIT)) {
            this.tunit = TimeUnit.valueOf(config.getStringProperty(CONFIG_PROPERTY_NAME_DELTA_UNIT));
        }
        if (!update || this.isPropertyUpdateable(CONFIG_PROPERTY_NAME_FC_METHOD)) {
            this.forecastMethod.set(ForecastMethod.valueOf(config.getStringProperty(CONFIG_PROPERTY_NAME_FC_METHOD)));
        }
        if (!update || this.isPropertyUpdateable(CONFIG_PROPERTY_NAME_TS_WINDOW_CAPACITY)) {
            this.timeSeriesWindowCapacity = new AtomicInteger(config.getIntProperty(CONFIG_PROPERTY_NAME_TS_WINDOW_CAPACITY));
        }
    }

    @InputPort(eventTypes={NamedDoubleTimeSeriesPoint.class}, name="tspoint")
    public void inputEvent(NamedDoubleTimeSeriesPoint input) {
        if (this.checkInitialization(input.getName())) {
            this.processInput(input, input.getTime(), input.getName());
        } else {
            this.applicationForecastingWindow.put(input.getName(), new TimeSeries(input.getTime(), this.recordsTimeUnitFromProjectContext, this.deltat.get(), this.timeSeriesWindowCapacity.get()));
            this.processInput(input, input.getTime(), input.getName());
        }
    }

    public void processInput(NamedDoubleTimeSeriesPoint input, long timestamp, String name) {
        ITimeSeries<Double> currentWindow = this.applicationForecastingWindow.get(name);
        currentWindow.append((Double)input.getValue());
        IForecaster<Double> forecaster = this.forecastMethod.get().getForecaster(currentWindow);
        IForecastResult result = forecaster.forecast(1);
        super.deliver(OUTPUT_PORT_NAME_FORECAST, result);
        if (result.getForecast().getPoints().size() > 0) {
            ForecastMeasurementPair fmp = new ForecastMeasurementPair(name, result.getForecast().getPoints().get(0).getValue(), (Double)input.getValue(), timestamp);
            super.deliver(OUTPUT_PORT_NAME_FORECASTED_AND_CURRENT, fmp);
        } else {
            this.log.error("There are no forecast points to deliver. Perhaps Rserve is not running?");
        }
    }

    private boolean checkInitialization(String name) {
        return this.applicationForecastingWindow.containsKey(name);
    }
}

