/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.util.OutputStream2StandardLog;
import org.math.R.Rsession;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPVector;

public final class RBridgeControl {
    private static final Log LOG = LogFactory.getLog(RBridgeControl.class);
    private static final AtomicInteger NEXTVARID = new AtomicInteger(1);
    private Rsession rCon;

    protected RBridgeControl() {
        OutputStream2StandardLog out = new OutputStream2StandardLog();
        try {
            this.rCon = Rsession.newLocalInstance((PrintStream)new PrintStream((OutputStream)out, true, "UTF-8"), null);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.toString(), e);
        }
    }

    public Object evalWithR(String input) {
        REXP out = null;
        try {
            out = this.rCon.eval(input);
            String output = null;
            output = out instanceof REXPString ? ((REXPString)out).asString() : (out instanceof REXPLogical ? ((REXPLogical)out).toDebugString() : out);
            LOG.trace("> REXP: " + input + " return: " + output);
        }
        catch (REXPMismatchException exc) {
            LOG.error("Error R expr.: " + input + " Cause: " + (Object)((Object)exc), exc);
        }
        return out;
    }

    public void toTS(String variable) {
        if (variable != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(variable);
            buf.append(" <<- ts(");
            buf.append(variable);
            buf.append(')');
            this.evalWithR(buf.toString());
        }
    }

    public void toTS(String variable, long frequency) {
        if (variable != null) {
            StringBuffer buf = new StringBuffer(21);
            buf.append(variable);
            buf.append(" <<- ts(");
            buf.append(variable);
            buf.append(", frequency=");
            buf.append(frequency);
            buf.append(')');
            this.evalWithR(buf.toString());
        }
    }

    public double eDbl(String input) {
        try {
            return ((REXPDouble)this.evalWithR(input)).asDouble();
        }
        catch (REXPMismatchException exc) {
            LOG.error("Error casting value from R: " + input + " Cause: " + (Object)((Object)exc));
            return -666.666;
        }
    }

    public String eString(String input) {
        REXPString str = (REXPString)this.evalWithR(input);
        if (str != null) {
            return str.toString();
        }
        return "";
    }

    public double[] eDblArr(String input) {
        try {
            REXPVector res = (REXPVector)this.evalWithR(input);
            return res.asDoubles();
        }
        catch (REXPMismatchException e) {
            return new double[0];
        }
    }

    public void assign(String variable, double[] values) {
        StringBuffer buf = new StringBuffer();
        buf.append(variable);
        buf.append(" <<- c(");
        boolean first = true;
        for (double item : values) {
            if (!first) {
                buf.append(',');
            } else {
                first = false;
            }
            buf.append(item);
        }
        buf.append(')');
        this.evalWithR(buf.toString());
    }

    public void assign(String variable, Double[] values) {
        StringBuffer buf = new StringBuffer();
        buf.append(variable);
        buf.append(" <<- c(");
        boolean first = true;
        for (Double item : values) {
            if (!first) {
                buf.append(',');
            } else {
                first = false;
            }
            if (null == item || item.isNaN()) {
                buf.append("NA");
                continue;
            }
            buf.append(item);
        }
        buf.append(')');
        this.evalWithR(buf.toString());
    }

    public void assign(String variable, Long[] values) {
        StringBuffer buf = new StringBuffer();
        buf.append(variable);
        buf.append(" <<- c(");
        boolean first = true;
        for (Long item : values) {
            if (!first) {
                buf.append(',');
            } else {
                first = false;
            }
            buf.append(item);
        }
        buf.append(',');
        this.evalWithR(buf.toString());
    }

    public static String uniqueVarname() {
        return String.format("var_%s", NEXTVARID.getAndIncrement());
    }

    public static final RBridgeControl getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static final class LazyHolder {
        static final RBridgeControl INSTANCE = new RBridgeControl();

        private LazyHolder() {
        }
    }
}

