/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.systemModel.repository;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import kieker.analysis.IProjectContext;
import kieker.analysis.repository.AbstractRepository;
import kieker.analysis.repository.annotation.Repository;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.systemModel.AllocationComponent;
import kieker.tools.traceAnalysis.systemModel.AssemblyComponent;
import kieker.tools.traceAnalysis.systemModel.ComponentType;
import kieker.tools.traceAnalysis.systemModel.Execution;
import kieker.tools.traceAnalysis.systemModel.ExecutionContainer;
import kieker.tools.traceAnalysis.systemModel.Operation;
import kieker.tools.traceAnalysis.systemModel.repository.AllocationComponentOperationPairFactory;
import kieker.tools.traceAnalysis.systemModel.repository.AllocationRepository;
import kieker.tools.traceAnalysis.systemModel.repository.AssemblyComponentOperationPairFactory;
import kieker.tools.traceAnalysis.systemModel.repository.AssemblyRepository;
import kieker.tools.traceAnalysis.systemModel.repository.ExecutionEnvironmentRepository;
import kieker.tools.traceAnalysis.systemModel.repository.OperationRepository;
import kieker.tools.traceAnalysis.systemModel.repository.TypeRepository;

@Repository(name="System model repository", description="Model manager for Kieker's component model ")
public class SystemModelRepository
extends AbstractRepository {
    public static final Execution ROOT_EXECUTION = new Execution(OperationRepository.ROOT_OPERATION, AllocationRepository.ROOT_ALLOCATION_COMPONENT, -1L, "-1", -1, -1, -1L, -1L, false);
    public static final String ROOT_NODE_LABEL = "'Entry'";
    private static final String ENCODING = "UTF-8";
    private final TypeRepository typeRepositoryFactory = new TypeRepository(this);
    private final AssemblyRepository assemblyFactory = new AssemblyRepository(this);
    private final ExecutionEnvironmentRepository executionEnvironmentFactory = new ExecutionEnvironmentRepository(this);
    private final AllocationRepository allocationFactory = new AllocationRepository(this);
    private final OperationRepository operationFactory = new OperationRepository(this);
    private final AllocationComponentOperationPairFactory allocationPairFactory = new AllocationComponentOperationPairFactory(this);
    private final AssemblyComponentOperationPairFactory assemblyPairFactory = new AssemblyComponentOperationPairFactory(this);

    public SystemModelRepository(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    public final AllocationRepository getAllocationFactory() {
        return this.allocationFactory;
    }

    public final AssemblyRepository getAssemblyFactory() {
        return this.assemblyFactory;
    }

    public final ExecutionEnvironmentRepository getExecutionEnvironmentFactory() {
        return this.executionEnvironmentFactory;
    }

    public final OperationRepository getOperationFactory() {
        return this.operationFactory;
    }

    public final TypeRepository getTypeRepositoryFactory() {
        return this.typeRepositoryFactory;
    }

    public AllocationComponentOperationPairFactory getAllocationPairFactory() {
        return this.allocationPairFactory;
    }

    public AssemblyComponentOperationPairFactory getAssemblyPairFactory() {
        return this.assemblyPairFactory;
    }

    private String htmlEntityLabel(int id, String caption, EntityType entityType) {
        StringBuilder strBuild = new StringBuilder(64);
        strBuild.append("<a name=\"").append(SystemModelRepository.simpleHTMLEscape(entityType.toString())).append('-').append(id).append("\">").append(caption).append("</a>");
        return strBuild.toString();
    }

    private String htmlEntityRef(int id, String caption, EntityType entityType) {
        StringBuilder strBuild = new StringBuilder(64);
        strBuild.append("<a href=\"#").append(SystemModelRepository.simpleHTMLEscape(entityType.toString())).append('-').append(id).append("\">").append(caption).append("</a>");
        return strBuild.toString();
    }

    private void printOpenHtmlTable(PrintStream ps, String title, String[] columnTitle) {
        ps.println("<table class=\"tab\" border=\"1\" style=\"width:100%\">");
        ps.println("<tr><th class=\"tabTitle\" colspan=\"" + columnTitle.length + "\">" + title + "</th></tr>");
        ps.println("<tr>");
        for (String cell : columnTitle) {
            ps.println("<th class=\"colTitle space\">" + cell + "</th>");
        }
        ps.println("</tr>");
    }

    private void printHtmlTableRow(PrintStream ps, String[] cells) {
        ps.println("<tr class=\"cell\">");
        for (String cell : cells) {
            ps.println("<td class=\"space\">" + (cell.length() == 0 ? "&nbsp;" : cell) + "</td>");
        }
        ps.println("</tr>");
    }

    private void printCloseHtmlTable(PrintStream ps) {
        ps.println("</table>");
    }

    private void htmlHSpace(PrintStream ps, int numLines) {
        if (numLines <= 0) {
            return;
        }
        StringBuilder strBuild = new StringBuilder("<pre>\n");
        for (int i = 0; i < numLines; ++i) {
            strBuild.append(".\n");
        }
        strBuild.append("</pre>");
        ps.println(strBuild.toString());
    }

    public void saveSystemToHTMLFile(String outputFn) throws FileNotFoundException, UnsupportedEncodingException {
        String[] cells;
        PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(outputFn), false, ENCODING);
        ps.println("<html><head><title>System Model Reconstructed by Kieker.TraceAnalysis</title>");
        ps.println("<style type=\"text/css\">\n.colTitle {font-size: 11px; background: linear-gradient(to bottom, #FDFDFD, #DDDDDD) transparent }\n.cell {font-family: monospace; font-size: 10px; font-family: inherited}\n.tabTitle {padding: 4px 4px; font-size: 12px; background: linear-gradient(to bottom, #FFFFFF, #CCEEFF) transparent; border: 1px solid #4DC4FF;color: #333399}\n.tab {border-collapse: collapse;  border: 1px solid #9D9D9D; font-family: \"Segoe UI\", \"Verdana\", \"Arial\", sans-serif}\n.space{padding: 4px 10px;}\n</style>");
        ps.println("</head><body>");
        this.htmlHSpace(ps, 10);
        this.printOpenSurroundingSpan(ps);
        this.printOpenHtmlTable(ps, "Component Types", new String[]{"ID", "Package", "Name", "Operations"});
        Collection<ComponentType> componentTypes = this.typeRepositoryFactory.getComponentTypes();
        for (ComponentType type : componentTypes) {
            StringBuilder opListBuilder = new StringBuilder();
            if (type.getOperations().size() > 0) {
                for (Operation op : type.getOperations()) {
                    opListBuilder.append("<li>").append(this.htmlEntityRef(op.getId(), SystemModelRepository.simpleHTMLEscape(op.getSignature().toString()), EntityType.OPERATION)).append("</li>");
                }
            }
            String[] cells2 = new String[]{this.htmlEntityLabel(type.getId(), Integer.toString(type.getId()), EntityType.COMPONENT_TYPE), SystemModelRepository.simpleHTMLEscape(type.getPackageName()), SystemModelRepository.simpleHTMLEscape(type.getTypeName()), opListBuilder.toString()};
            this.printHtmlTableRow(ps, cells2);
        }
        this.printCloseHtmlTable(ps);
        this.printLinebreak(ps);
        this.printOpenHtmlTable(ps, "Operations", new String[]{"ID", "Component type", "Name", "Parameter types", "Return type"});
        Collection<Operation> operations = this.operationFactory.getOperations();
        for (Operation op : operations) {
            StringBuilder paramListStrBuild = new StringBuilder();
            for (String paramType : op.getSignature().getParamTypeList()) {
                paramListStrBuild.append("<li>").append(SystemModelRepository.simpleHTMLEscape(paramType)).append("</li>");
            }
            cells = new String[]{this.htmlEntityLabel(op.getId(), Integer.toString(op.getId()), EntityType.OPERATION), this.htmlEntityRef(op.getComponentType().getId(), SystemModelRepository.simpleHTMLEscape(op.getComponentType().getFullQualifiedName()), EntityType.COMPONENT_TYPE), SystemModelRepository.simpleHTMLEscape(op.getSignature().getName()), paramListStrBuild.toString(), SystemModelRepository.simpleHTMLEscape(op.getSignature().getReturnType())};
            this.printHtmlTableRow(ps, cells);
        }
        this.printCloseHtmlTable(ps);
        this.printLinebreak(ps);
        this.printOpenHtmlTable(ps, "Assembly Components", new String[]{"ID", "Name", "Component type"});
        Collection<AssemblyComponent> assemblyComponents = this.assemblyFactory.getAssemblyComponentInstances();
        for (AssemblyComponent ac : assemblyComponents) {
            cells = new String[]{this.htmlEntityLabel(ac.getId(), Integer.toString(ac.getId()), EntityType.ASSEMBLY_COMPONENT), ac.getName(), this.htmlEntityRef(ac.getType().getId(), SystemModelRepository.simpleHTMLEscape(ac.getType().getFullQualifiedName()), EntityType.COMPONENT_TYPE)};
            this.printHtmlTableRow(ps, cells);
        }
        this.printCloseHtmlTable(ps);
        this.printLinebreak(ps);
        this.printOpenHtmlTable(ps, "Execution Containers", new String[]{"ID", "Name"});
        Collection<ExecutionContainer> containers = this.executionEnvironmentFactory.getExecutionContainers();
        for (ExecutionContainer container : containers) {
            String[] cells3 = new String[]{this.htmlEntityLabel(container.getId(), Integer.toString(container.getId()), EntityType.EXECUTION_CONTAINER), SystemModelRepository.simpleHTMLEscape(container.getName())};
            this.printHtmlTableRow(ps, cells3);
        }
        this.printCloseHtmlTable(ps);
        this.printLinebreak(ps);
        this.printOpenHtmlTable(ps, "Deployment Components", new String[]{"ID", "Assembly component", "Execution container"});
        Collection<AllocationComponent> allocationComponentInstances = this.allocationFactory.getAllocationComponentInstances();
        for (AllocationComponent allocationComponent : allocationComponentInstances) {
            String[] cells4 = new String[]{this.htmlEntityLabel(allocationComponent.getId(), Integer.toString(allocationComponent.getId()), EntityType.ALLOCATION_COMPONENT), this.htmlEntityRef(allocationComponent.getAssemblyComponent().getId(), SystemModelRepository.simpleHTMLEscape(allocationComponent.getAssemblyComponent().toString()), EntityType.ALLOCATION_COMPONENT), this.htmlEntityRef(allocationComponent.getExecutionContainer().getId(), SystemModelRepository.simpleHTMLEscape(allocationComponent.getExecutionContainer().getName()), EntityType.EXECUTION_CONTAINER)};
            this.printHtmlTableRow(ps, cells4);
        }
        this.printCloseHtmlTable(ps);
        this.printCloseSurroundingSpan(ps);
        this.htmlHSpace(ps, 50);
        ps.println("</body></html>");
        ps.flush();
        ps.close();
    }

    private void printOpenSurroundingSpan(PrintStream ps) {
        ps.println("<span style=\"display: inline-block\">");
    }

    private void printCloseSurroundingSpan(PrintStream ps) {
        ps.println("</span>");
    }

    private void printLinebreak(PrintStream ps) {
        ps.println("<br/>");
    }

    private static String simpleHTMLEscape(String input) {
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }

    private static enum EntityType {
        COMPONENT_TYPE,
        OPERATION,
        ASSEMBLY_COMPONENT,
        ALLOCATION_COMPONENT,
        EXECUTION_CONTAINER;

    }
}

