/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.bridge.connector.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import kieker.common.record.IMonitoringRecord;
import kieker.tools.bridge.LookupEntity;
import kieker.tools.bridge.connector.tcp.TCPMultiServerConnectionRunnable;

public class TCPMultiServerPortListenerRunnable
implements Runnable {
    private final ServerSocket serverSocket;
    private final BlockingQueue<IMonitoringRecord> recordQueue;
    private volatile boolean active = true;
    private final ConcurrentMap<Integer, LookupEntity> lookupEntityMap;
    private final ExecutorService executor;

    public TCPMultiServerPortListenerRunnable(int port, BlockingQueue<IMonitoringRecord> recordQueue, ConcurrentMap<Integer, LookupEntity> lookupEntityMap, ExecutorService executor) throws IOException {
        this.recordQueue = recordQueue;
        this.lookupEntityMap = lookupEntityMap;
        this.serverSocket = new ServerSocket(port);
        this.executor = executor;
    }

    @Override
    public void run() {
        try {
            while (this.active) {
                this.executor.execute(new TCPMultiServerConnectionRunnable(this.serverSocket.accept(), this.lookupEntityMap, this.recordQueue));
            }
            this.serverSocket.close();
        }
        catch (IOException e) {
            this.active = false;
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

