/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.jms;

import kieker.common.configuration.Configuration;
import kieker.monitoring.writer.AbstractAsyncWriter;
import kieker.monitoring.writer.jms.JMSWriterThread;

public final class AsyncJMSWriter
extends AbstractAsyncWriter {
    private static final String PREFIX = AsyncJMSWriter.class.getName() + ".";
    public static final String CONFIG_PROVIDERURL = PREFIX + "ProviderUrl";
    public static final String CONFIG_TOPIC = PREFIX + "Topic";
    public static final String CONFIG_CONTEXTFACTORYTYPE = PREFIX + "ContextFactoryType";
    public static final String CONFIG_FACTORYLOOKUPNAME = PREFIX + "FactoryLookupName";
    public static final String CONFIG_MESSAGETTL = PREFIX + "MessageTimeToLive";
    private final String configContextFactoryType;
    private final String configProviderUrl;
    private final String configFactoryLookupName;
    private final String configTopic;
    private final long configMessageTimeToLive;

    public AsyncJMSWriter(Configuration configuration) {
        super(configuration);
        this.configContextFactoryType = configuration.getStringProperty(CONFIG_CONTEXTFACTORYTYPE);
        this.configProviderUrl = configuration.getStringProperty(CONFIG_PROVIDERURL);
        this.configFactoryLookupName = configuration.getStringProperty(CONFIG_FACTORYLOOKUPNAME);
        this.configTopic = configuration.getStringProperty(CONFIG_TOPIC);
        this.configMessageTimeToLive = configuration.getLongProperty(CONFIG_MESSAGETTL);
    }

    @Override
    protected void init() throws Exception {
        this.addWorker(new JMSWriterThread(this.monitoringController, this.blockingQueue, this.configContextFactoryType, this.configProviderUrl, this.configFactoryLookupName, this.configTopic, this.configMessageTimeToLive));
        this.addWorker(new JMSWriterThread(this.monitoringController, this.prioritizedBlockingQueue, this.configContextFactoryType, this.configProviderUrl, this.configFactoryLookupName, this.configTopic, this.configMessageTimeToLive));
    }
}

